/* *##%
 * Copyright (c) 2009 poussin. All rights reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *##%*/

package org.nuiton.wikitty;

import java.util.Collection;

/**
 * WikittyStorage is used to abstract data and extension storage in WikittyService.
 *
 * @author poussin
 * @version $Revision: 130 $
 *
 * Last update: $Date: 2010-06-17 14:56:46 +0200 (jeu., 17 juin 2010) $
 * by : $Author: echatellier $
 */
public interface WikittyStorage {

    /**
     * Store wikitty in storage.
     * 
     * @param transaction transaction
     * @param wikitties wikitty collection
     * @param disableAutoVersionIncrement
     * 
     * @return information usefull for client side update data
     */
    public UpdateResponse store(WikittyTransaction transaction, Collection<Wikitty> wikitties, boolean disableAutoVersionIncrement);

    /**
     * Return true if id exists in storage.
     * 
     * @param transaction transaction
     * @param id id to check
     * @return {@code true} if wikitty id exists
     */
    public boolean exists(WikittyTransaction transaction, String id);

    /**
     * Return true if wikitty object with this id are marked deleted.
     * 
     * @param transaction transaction
     * @param id id to check
     * @return {@code true} if wikitty id is deleted
     */
    public boolean isDeleted(WikittyTransaction transaction, String id);

    /**
     * Restore list of wikitty object.
     * 
     * @param transaction transaction
     * @param id list of wikitty id
     * @param fqFieldName list of field that must be loaded, other fields
     *      can be not loaded
     * @return found wikitty
     * @throws WikittyException if wikitty not found
     */
    public Wikitty restore(WikittyTransaction transaction, String id,
            String ... fqFieldName) throws WikittyException;

    /**
     * Delete all object with id argument.
     * 
     * @param transaction transaction
     * @param idList
     * @return delete response
     * @throws WikittyException If id is not valid or don't exist.
     */
    public UpdateResponse delete(WikittyTransaction transaction, Collection<String> idList) throws WikittyException;

    /**
     * Scan all wikitties with specific scanner, even if the wikitty is deleted.
     * 
     * @param transaction transaction
     * @param scanner scanner
     */
    void scanWikitties(WikittyTransaction transaction, Scanner scanner);

    /**
     * Call each time wikitty is scan.
     */
    public static interface Scanner {
        void scan(String wikittyId);
    }

    /**
     * Remove all wikitty.
     * 
     * @param transaction transaction
     */
    public void clear(WikittyTransaction transaction);

}
