/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.filter;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.web.jmx.ServletStatisticsService;

public class MonitoringFilter
implements Filter {
    private static final Log log = LogFactory.getLog(MonitoringFilter.class);
    protected ObjectName servletStatisticsMBeanName;
    protected ServletStatisticsService servletStatisticsService;

    public void init(FilterConfig filterConfig) throws ServletException {
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            this.servletStatisticsService = new ServletStatisticsService();
            this.servletStatisticsMBeanName = new ObjectName("Servlet:application=Statistics");
            server.registerMBean(this.servletStatisticsService, this.servletStatisticsMBeanName);
            log.info((Object)("mbean " + this.servletStatisticsService + " attached as " + this.servletStatisticsMBeanName));
        }
        catch (MalformedObjectNameException e) {
            log.error((Object)"unable to register mbean", (Throwable)e);
        }
        catch (InstanceAlreadyExistsException e) {
            log.error((Object)"unable to register mbean", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error((Object)"unable to register mbean", (Throwable)e);
        }
        catch (NotCompliantMBeanException e) {
            log.error((Object)"unable to register mbean", (Throwable)e);
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        this.servletStatisticsService.preFilter(servletRequest, servletResponse, filterChain);
        filterChain.doFilter(servletRequest, servletResponse);
        this.servletStatisticsService.postFilter(servletRequest, servletResponse, filterChain);
    }

    public void destroy() {
        log.info((Object)("statistics:\n" + this.servletStatisticsService.toCsv()));
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            server.unregisterMBean(this.servletStatisticsMBeanName);
            log.info((Object)("mbean detached " + this.servletStatisticsMBeanName));
        }
        catch (InstanceNotFoundException e) {
            log.error((Object)"unable to unregister mbean", (Throwable)e);
        }
        catch (MBeanRegistrationException e) {
            log.error((Object)"unable to unregister mbean", (Throwable)e);
        }
    }
}

