/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.jmx;

import java.util.HashMap;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.nuiton.web.jmx.RequestStatistics;
import org.nuiton.web.jmx.ServletStatisticsServiceMBean;

public class ServletStatisticsService
implements ServletStatisticsServiceMBean {
    protected Map<ServletRequest, Long> requestStartTime = new HashMap<ServletRequest, Long>();
    protected Map<String, RequestStatistics> perRequestStatistics = new HashMap<String, RequestStatistics>();

    public void preFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        long start = System.currentTimeMillis();
        this.requestStartTime.put(servletRequest, start);
    }

    public void postFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) {
        String contentType = servletResponse.getContentType();
        if (contentType != null && contentType.startsWith("text/html")) {
            long stop = System.currentTimeMillis();
            long start = this.requestStartTime.get(servletRequest);
            if (servletRequest instanceof HttpServletRequest) {
                String requestURI = ((HttpServletRequest)servletRequest).getRequestURI();
                RequestStatistics requestStatistics = this.perRequestStatistics.get(requestURI);
                if (requestStatistics == null) {
                    requestStatistics = new RequestStatistics();
                    this.perRequestStatistics.put(requestURI, requestStatistics);
                }
                requestStatistics.count(start, stop);
            }
        }
        this.requestStartTime.remove(servletRequest);
    }

    @Override
    public Map<String, RequestStatistics> getPerRequestStatistics() {
        return this.perRequestStatistics;
    }

    @Override
    public String toCsv() {
        StringBuilder csv = new StringBuilder();
        csv.append("PAGE,NOMBRE_DEMANDES,DUREE_TOTALE,DUREE_MOYENNE,DUREE_MIN,DUREE_MAX\n");
        for (Map.Entry<String, RequestStatistics> requestStatistics : this.perRequestStatistics.entrySet()) {
            String request = requestStatistics.getKey();
            RequestStatistics statistics = requestStatistics.getValue();
            csv.append(request).append(',').append(statistics.getCount()).append(',').append(statistics.getElapsedSum()).append(',').append(statistics.getAverageElapsed()).append(',').append(statistics.getLowestElapsed()).append(',').append(statistics.getHighestElapsed()).append('\n');
        }
        return csv.toString();
    }

    @Override
    public void reset() {
        this.perRequestStatistics.clear();
    }
}

