/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.web.security.actions;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaRuntimeException;
import org.nuiton.web.SecurityDAOHelper;
import org.nuiton.web.security.SecurityRole;
import org.nuiton.web.security.SecurityRoleDAO;
import org.nuiton.web.security.SecurityRoleImpl;
import org.nuiton.web.security.actions.AbstractAction;

public class RoleAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RoleAction.class);
    protected SecurityRoleDAO securityRoleDAO;
    protected SecurityRole role;

    public SecurityRole getRole() {
        if (this.role == null) {
            String roleId = this.getParameter("roleId");
            if (StringUtils.isNotBlank((CharSequence)roleId)) {
                try {
                    TopiaContext transaction = this.rootContext.beginTransaction();
                    this.securityRoleDAO = SecurityDAOHelper.getSecurityRoleDAO(transaction);
                    this.role = (SecurityRole)this.securityRoleDAO.findByTopiaId(roleId);
                    transaction.closeContext();
                }
                catch (TopiaException ex) {
                    throw new TopiaRuntimeException((Throwable)ex);
                }
            } else {
                this.role = new SecurityRoleImpl();
            }
        }
        return this.role;
    }

    public String delete() throws Exception {
        block3: {
            try {
                String roleId = this.getParameter("roleId");
                if (StringUtils.isNotBlank((CharSequence)roleId)) {
                    TopiaContext transaction = this.rootContext.beginTransaction();
                    this.securityRoleDAO = SecurityDAOHelper.getSecurityRoleDAO(transaction);
                    SecurityRole role = (SecurityRole)this.securityRoleDAO.findByTopiaId(roleId);
                    this.securityRoleDAO.delete(role);
                    transaction.commitTransaction();
                    transaction.closeContext();
                }
            }
            catch (Exception ex) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Can't delete role", (Throwable)ex);
            }
        }
        return "success";
    }

    public String execute() throws Exception {
        String result = super.execute();
        try {
            TopiaContext transaction = this.rootContext.beginTransaction();
            this.securityRoleDAO = SecurityDAOHelper.getSecurityRoleDAO(transaction);
            if (this.getRole().getTopiaId() == null) {
                this.securityRoleDAO.create(this.getRole());
            } else {
                this.securityRoleDAO.update(this.getRole());
            }
            transaction.commitTransaction();
            transaction.closeContext();
        }
        catch (Exception ex) {
            this.addActionError(ex.getMessage());
            result = this.input();
        }
        return result;
    }
}

