/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.service.servers;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.XmlRpcHandler;
import org.apache.xmlrpc.XmlRpcRequest;
import org.apache.xmlrpc.server.XmlRpcHandlerMapping;
import org.apache.xmlrpc.server.XmlRpcStreamServer;
import org.apache.xmlrpc.webserver.WebServer;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.service.TopiaApplicationService;
import org.nuiton.topia.service.TopiaServiceServerAbstract;

public class XMLRPCServer
extends TopiaServiceServerAbstract
implements XmlRpcHandler,
XmlRpcHandlerMapping {
    private static final Log logger = LogFactory.getLog(XMLRPCServer.class);
    private WebServer webServer;
    public static final int DEFAUTL_PORT = 9090;
    protected boolean alreadyLaunched = false;

    public XMLRPCServer(int port) {
        this.webServer = new WebServer(port);
        XmlRpcStreamServer xmlRpcServer = this.webServer.getXmlRpcServer();
        xmlRpcServer.setHandlerMapping((XmlRpcHandlerMapping)this);
    }

    public XMLRPCServer() {
        this(9090);
    }

    @Override
    public void addService(Class<? extends TopiaApplicationService> clazz) {
    }

    @Override
    public void launch() {
        if (!this.alreadyLaunched) {
            try {
                this.webServer.start();
                logger.info((Object)"XML-RPC server running...");
            }
            catch (IOException e) {
                logger.debug((Object)"I/O erreur while launching xml-rpc web serveur", (Throwable)e);
            }
            this.alreadyLaunched = true;
        }
    }

    public XmlRpcHandler getHandler(String className) throws XmlRpcException {
        logger.debug((Object)("Request handler for " + className));
        return this;
    }

    public Object execute(XmlRpcRequest xmlrequest) throws XmlRpcException {
        Object result = null;
        Object[] args = new Object[xmlrequest.getParameterCount()];
        Class[] argsTypes = new Class[xmlrequest.getParameterCount()];
        for (int i = 0; i < xmlrequest.getParameterCount(); ++i) {
            args[i] = xmlrequest.getParameter(i);
            argsTypes[i] = xmlrequest.getParameter(i).getClass();
        }
        String call = xmlrequest.getMethodName();
        String className = call.substring(0, call.lastIndexOf("."));
        String methodName = call.substring(call.lastIndexOf(".") + 1);
        logger.debug((Object)("Receiving request : " + className + "." + methodName + "(" + Arrays.toString(args) + ")"));
        try {
            Class<?> clazz = Class.forName(className);
            Method method = MethodUtils.getAccessibleMethod(clazz, (String)methodName, (Class[])argsTypes);
            result = super.invoke(method, args);
        }
        catch (ClassNotFoundException e) {
            logger.debug((Object)("Class " + className + " not found !"), (Throwable)e);
        }
        if (result instanceof List) {
            result = this.listToMap((List)result);
        } else if (result instanceof TopiaEntity) {
            result = this.entityToMap((TopiaEntity)result);
        } else if (result instanceof Long) {
            result = Long.toString((Long)result);
        }
        return result;
    }

    private <E extends TopiaEntity> Map listToMap(List<E> list) {
        HashMap<String, Map> resultMap = new HashMap<String, Map>();
        for (TopiaEntity entity : list) {
            Map entityMap = this.entityToMap(entity);
            resultMap.put(entity.getTopiaId(), entityMap);
        }
        return resultMap;
    }

    private <E extends TopiaEntity> Map entityToMap(E entity) {
        HashMap<String, Object> entityMap = new HashMap<String, Object>();
        for (Method m : entity.getClass().getMethods()) {
            if (!m.getName().startsWith("get")) continue;
            logger.info((Object)("* method " + m));
            String attributeName = m.getName().replace("get", "");
            try {
                Object o = m.invoke(entity, new Object[0]);
                if (o instanceof String && !o.equals("")) {
                    entityMap.put(attributeName, o);
                    continue;
                }
                if (o instanceof Date && o != null) {
                    entityMap.put(attributeName, o.toString());
                    continue;
                }
                if (o instanceof TopiaEntity && o != null) {
                    entityMap.put(attributeName, ((TopiaEntity)o).getTopiaId());
                    continue;
                }
                if (!(o instanceof Collection) || o == null || ((Collection)o).size() <= 0) continue;
                String[] composite = new String[((Collection)o).size()];
                int index = 0;
                for (Object obj : (Collection)o) {
                    composite[index++] = ((TopiaEntity)obj).getTopiaId();
                }
                entityMap.put(attributeName, composite);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return entityMap;
    }
}

