package org.nuiton.topia.security.entities.authorization;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class TopiaExpressionLinkDAOAbstract<E extends TopiaExpressionLink> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)TopiaExpressionLink.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByReplace :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut replace le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByReplace(String v) throws TopiaException {
        E result = findByProperty(TopiaExpressionLink.REPLACE, v);
        return result;
    }

    /**
     * findAllByReplace :
     * Retourne les éléments ayant comme valeur pour l'attribut replace le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByReplace(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaExpressionLink.REPLACE, v);
        return result;
    }

    /**
     * findByBy :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut by le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByBy(String v) throws TopiaException {
        E result = findByProperty(TopiaExpressionLink.BY, v);
        return result;
    }

    /**
     * findAllByBy :
     * Retourne les éléments ayant comme valeur pour l'attribut by le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByBy(String v) throws TopiaException {
        List<E> result = findAllByProperty(TopiaExpressionLink.BY, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }


} //TopiaExpressionLinkDAOAbstract<E extends TopiaExpressionLink>
