/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.replication;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.nuiton.topia.TestHelper;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;
import org.nuiton.topia.replication.AbstractTopiaReplicationServiceTest;
import org.nuiton.topia.replication.TopiaReplicationServiceImpl;
import org.nuiton.topia.replication.operation.AttachAssociation;
import org.nuiton.topia.replication.operation.DettachAssociation;
import org.nuiton.topia.replication.operation.Duplicate;
import org.nuiton.topia.replication.operation.FakeOperation;
import org.nuiton.topia.replication.operation.UncreatableOperation;
import org.nuiton.topia.replication.operation.UnregistredOperation;
import org.nuiton.topia.test.entities.Person;
import org.nuiton.topia.test.entities.PersonImpl;
import org.nuiton.topia.test.entities.Pet;
import org.nuiton.topia.test.entities.PetImpl;
import org.nuiton.topia.test.entities.Race;
import org.nuiton.topia.test.entities.RaceImpl;

public class TopiaReplicationServiceImplTest
extends AbstractTopiaReplicationServiceTest {
    private static final Log log = LogFactory.getLog(TopiaReplicationServiceImplTest.class);
    protected static final TopiaEntityEnum[] contracts = new TopiaEntityEnum[]{TopiaTestDAOHelper.TopiaTestEntityEnum.Person, TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, TopiaTestDAOHelper.TopiaTestEntityEnum.Race};
    protected static final String entitiesList = PersonImpl.class.getName() + "," + PetImpl.class.getName() + "," + RaceImpl.class.getName();
    protected static Person person;
    protected static Person person2;
    protected static Pet pet;
    protected static Pet pet2;
    protected static Pet pet3;
    protected static Race race;
    protected static Race race2;
    protected static Race race3;
    protected static File tesDir;

    @BeforeClass
    public static void beforeClass() throws IOException {
        tesDir = TestHelper.getTestBasedir(TopiaReplicationServiceImplTest.class);
    }

    @AfterClass
    public static void after() throws Exception {
        AbstractTopiaReplicationServiceTest.after();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        person = this.update(person);
        person2 = this.update(person2);
        pet = this.update(pet);
        pet2 = this.update(pet2);
        race = this.update(race);
        race2 = this.update(race2);
        race3 = this.update(race3);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.dstCtxt != null && !this.dstCtxt.isClosed()) {
            this.dstCtxt.closeContext();
        }
    }

    @Override
    @Test
    public void testDetectTypes() throws Exception {
        this.detectTypes((TopiaEntity)race, Race.class);
        this.detectTypes((TopiaEntity)pet, Pet.class, Person.class, Race.class);
        this.detectTypes((TopiaEntity)person, Pet.class, Person.class, Race.class);
        this.detectTypes((TopiaEntity)pet2, Pet.class);
        this.detectTypes((TopiaEntity)person2, Person.class);
        this.detectTypes((TopiaEntity)race2, Race.class);
        this.detectTypes((TopiaEntity)race3, Race.class);
        this.detectTypes((TopiaEntity)pet3, Pet.class, Race.class);
    }

    @Override
    @Test
    public void testGetOperation() throws Exception {
        this.getOperation(UnregistredOperation.class, false);
        this.getOperation(UncreatableOperation.class, true);
        this.getOperation(FakeOperation.class, true);
        this.getOperation(Duplicate.class, true);
        this.getOperation(AttachAssociation.class, true);
        this.getOperation(DettachAssociation.class, true);
    }

    @Override
    @Test
    public void testDetectAssociations() throws Exception {
        this.detectAssociations((TopiaEntity)person, TopiaTestDAOHelper.TopiaTestEntityEnum.Person, "pet");
        this.detectAssociations((TopiaEntity)race, new Object[0]);
        this.detectAssociations((TopiaEntity)pet, new Object[0]);
        this.detectAssociations((TopiaEntity)person2, new Object[0]);
        this.detectAssociations((TopiaEntity)race2, new Object[0]);
        this.detectAssociations((TopiaEntity)pet2, new Object[0]);
    }

    @Override
    @Test
    public void testDetectDirectDependencies() throws Exception {
        this.detectDirectDependencies((TopiaEntity)person, new Object[0]);
        this.detectDirectDependencies((TopiaEntity)race, new Object[0]);
        this.detectDirectDependencies((TopiaEntity)pet, TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, "person", TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, "race");
        this.detectDirectDependencies((TopiaEntity)person2, new Object[0]);
        this.detectDirectDependencies((TopiaEntity)race2, new Object[0]);
        this.detectDirectDependencies((TopiaEntity)pet2, new Object[0]);
    }

    @Override
    @Test
    public void testDetectShell() throws Exception {
        this.detectShell((TopiaEntity)person, new TopiaEntityEnum[]{TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, TopiaTestDAOHelper.TopiaTestEntityEnum.Race});
        this.detectShell((TopiaEntity)race, new TopiaEntityEnum[0]);
        this.detectShell((TopiaEntity)pet, new TopiaEntityEnum[]{TopiaTestDAOHelper.TopiaTestEntityEnum.Person, TopiaTestDAOHelper.TopiaTestEntityEnum.Race});
        this.detectShell((TopiaEntity)person2, new TopiaEntityEnum[0]);
        this.detectShell((TopiaEntity)race2, new TopiaEntityEnum[0]);
        this.detectShell((TopiaEntity)pet2, new TopiaEntityEnum[0]);
    }

    @Override
    @Test
    public void testDetectDependencies() throws Exception {
        this.detectDependencies((TopiaEntity)person, new TopiaEntityEnum[][]{{TopiaTestDAOHelper.TopiaTestEntityEnum.Race}, {TopiaTestDAOHelper.TopiaTestEntityEnum.Person}, {TopiaTestDAOHelper.TopiaTestEntityEnum.Pet}});
        this.detectDependencies((TopiaEntity)race, new TopiaEntityEnum[][]{{TopiaTestDAOHelper.TopiaTestEntityEnum.Race}});
        this.detectDependencies((TopiaEntity)pet, new TopiaEntityEnum[][]{{TopiaTestDAOHelper.TopiaTestEntityEnum.Race}, {TopiaTestDAOHelper.TopiaTestEntityEnum.Person}, {TopiaTestDAOHelper.TopiaTestEntityEnum.Pet}});
        this.detectDependencies((TopiaEntity)person2, new TopiaEntityEnum[][]{{TopiaTestDAOHelper.TopiaTestEntityEnum.Person}});
        this.detectDependencies((TopiaEntity)race2, new TopiaEntityEnum[][]{{TopiaTestDAOHelper.TopiaTestEntityEnum.Race}});
        this.detectDependencies((TopiaEntity)pet2, new TopiaEntityEnum[][]{{TopiaTestDAOHelper.TopiaTestEntityEnum.Pet}});
    }

    @Override
    @Test
    public void testDetectObjectsToDettach() throws Exception {
        this.detectObjectsToDettach((TopiaEntity)person, TopiaTestDAOHelper.TopiaTestEntityEnum.Person, new String[]{"pet"});
        this.detectObjectsToDettach((TopiaEntity)race, new Object[0]);
        this.detectObjectsToDettach((TopiaEntity)pet, TopiaTestDAOHelper.TopiaTestEntityEnum.Person, new String[]{"pet"});
        this.detectObjectsToDettach((TopiaEntity)person2, new Object[0]);
        this.detectObjectsToDettach((TopiaEntity)race2, new Object[0]);
        this.detectObjectsToDettach((TopiaEntity)pet2, new Object[0]);
        this.detectObjectsToDettach((TopiaEntity)race3, new Object[0]);
        this.detectObjectsToDettach((TopiaEntity)pet3, new Object[0]);
    }

    @Override
    @Test
    public void testDetectOperations() throws Exception {
        this.detectOperations((TopiaEntity)person, new Object[0]);
        this.detectOperations((TopiaEntity)pet, new Object[0]);
        this.detectOperations((TopiaEntity)race, new Object[0]);
        this.detectOperations((TopiaEntity)person2, new Object[0]);
        this.detectOperations((TopiaEntity)pet2, new Object[0]);
        this.detectOperations((TopiaEntity)race2, new Object[0]);
        this.detectOperations((TopiaEntity)race3, new Object[0]);
        this.detectOperations((TopiaEntity)pet3, new Object[0]);
    }

    @Override
    @Test
    public void testDoReplicate() throws Exception {
        this.doReplicate((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Person, new TopiaEntity[]{person});
        this.doReplicate((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Person, new TopiaEntity[]{person2});
        this.doReplicate((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Person, new TopiaEntity[]{person, person2});
        this.doReplicate((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, new TopiaEntity[]{pet});
        this.doReplicate((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, new TopiaEntity[]{pet2});
        this.doReplicate((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, new TopiaEntity[]{pet, pet2, pet3});
        this.doReplicate((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Pet, new TopiaEntity[]{person2, pet3});
        this.doReplicate((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Race, new TopiaEntity[]{race});
        this.doReplicate((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Race, new TopiaEntity[]{race2});
        this.doReplicate((TopiaEntityEnum)TopiaTestDAOHelper.TopiaTestEntityEnum.Race, new TopiaEntity[]{race, race2});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=TopiaException.class)
    public void testSimpleReplicateFailed() throws Exception {
        TopiaContext dstRootCtxt = this.createDb2("testSimpleReplicateFailed");
        TopiaContext srcCtxt = ctxt.beginTransaction();
        this.dstCtxt = (TopiaContextImplementor)dstRootCtxt.beginTransaction();
        try {
            srcCtxt.replicateEntity((TopiaContext)this.dstCtxt, (TopiaEntity)pet);
            this.dstCtxt.commitTransaction();
        }
        finally {
            srcCtxt.rollbackTransaction();
            srcCtxt.closeContext();
            this.dstCtxt.closeContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleReplicateNotSure() throws Exception {
        TopiaContext dstRootCtxt = this.createDb2("testSimpleReplicateNotSure");
        TopiaContext srcCtxt = ctxt;
        this.dstCtxt = (TopiaContextImplementor)dstRootCtxt.beginTransaction();
        try {
            srcCtxt.replicateEntity((TopiaContext)this.dstCtxt, (TopiaEntity)race);
            pet.setPerson(null);
            srcCtxt.replicateEntity((TopiaContext)this.dstCtxt, (TopiaEntity)pet);
            srcCtxt.rollbackTransaction();
            srcCtxt.replicateEntity((TopiaContext)this.dstCtxt, (TopiaEntity)person);
            this.dstCtxt.commitTransaction();
            ((Pet)this.dstCtxt.findByTopiaId(pet.getTopiaId())).setPerson((Person)this.dstCtxt.findByTopiaId(person.getTopiaId()));
            this.dstCtxt.commitTransaction();
            srcCtxt.rollbackTransaction();
            person = this.update(person);
            this.assertEntityEquals((TopiaEntity)person, this.dstCtxt.findByTopiaId(person.getTopiaId()), null);
        }
        finally {
            srcCtxt.rollbackTransaction();
            this.dstCtxt.closeContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSimpleReplicateSure() throws Exception {
        TopiaContext dstRootCtxt = this.createDb2("testSimpleReplicateSure");
        TopiaContext srcCtxt = ctxt;
        this.dstCtxt = (TopiaContextImplementor)dstRootCtxt.beginTransaction();
        try {
            srcCtxt.replicateEntity((TopiaContext)this.dstCtxt, (TopiaEntity)race);
            person.setPet(null);
            srcCtxt.replicateEntity((TopiaContext)this.dstCtxt, (TopiaEntity)person);
            srcCtxt.replicateEntity((TopiaContext)this.dstCtxt, (TopiaEntity)pet);
            srcCtxt.rollbackTransaction();
            this.dstCtxt.commitTransaction();
            srcCtxt.rollbackTransaction();
            srcCtxt.closeContext();
            this.dstCtxt.closeContext();
            ctxt = context.beginTransaction();
            this.dstCtxt = (TopiaContextImplementor)dstRootCtxt.beginTransaction();
            person = this.update(person);
            this.assertEntityEquals((TopiaEntity)person, this.dstCtxt.findByTopiaId(person.getTopiaId()), null);
        }
        finally {
            this.dstCtxt.closeContext();
        }
    }

    @Override
    protected TopiaContext createDb(String name) throws Exception {
        Properties config = this.getH2Properties(name);
        context = TopiaContextFactory.getContext((Properties)config);
        TopiaContextImplementor tx = (TopiaContextImplementor)context.beginTransaction();
        person = (Person)tx.getDAO(Person.class).create(new Object[]{"name", "pudding master"});
        race = (Race)tx.getDAO(Race.class).create(new Object[]{"name", "race I"});
        pet = (Pet)tx.getDAO(Pet.class).create(new Object[]{"name", "pudding", "person", person, "race", race});
        person2 = (Person)tx.getDAO(Person.class).create(new Object[]{"name", "pudding II master"});
        pet2 = (Pet)tx.getDAO(Pet.class).create(new Object[]{"name", "pudding II"});
        race2 = (Race)tx.getDAO(Race.class).create(new Object[]{"name", "race II"});
        race3 = (Race)tx.getDAO(Race.class).create(new Object[]{"name", "race III"});
        pet3 = (Pet)tx.getDAO(Pet.class).create(new Object[]{"name", "pudding III", "race", race3});
        tx.commitTransaction();
        tx.closeContext();
        return context;
    }

    @Override
    protected TopiaContext createDb2(String name) throws Exception {
        Properties config = this.getH2Properties(name);
        return TopiaContextFactory.getContext((Properties)config);
    }

    @Override
    protected TopiaEntityEnum[] getContracts() {
        return contracts;
    }

    @Override
    protected Log getLog() {
        return log;
    }

    protected Properties getH2Properties(String dbName) throws IOException {
        Properties config = TestHelper.initTopiaContextConfiguration((File)tesDir, (String)dbName);
        config.setProperty("topia.persistence.classes", entitiesList);
        config.setProperty("topia.service.replication", TopiaReplicationServiceImpl.class.getName());
        return config;
    }
}

