/*
 * #%L
 * ToPIA :: Service Migration
 * 
 * $Id: MapAdapter.java 2010 2010-06-13 18:18:35Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.3.4/topia-service-migration/src/main/java/org/nuiton/topia/migration/common/MapAdapter.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.migration.common;

import org.nuiton.topia.migration.TopiaMigrationEngine;

import java.io.Serializable;
import java.util.Map;

/**
 * MapAdapter.java
 *
 * Interface developpeur, contenant juste les methodes qui lui sont nécessaires.
 * 
 * @author Chatellier Eric
 * @author Chevallereau Benjamin
 * @author Eon Sébastien
 * @author Trève Vincent
 * @deprecated since 2.3.4, please use now the simplify service {@link TopiaMigrationEngine}
 */
@Deprecated
public interface MapAdapter {

    /**
     * Accesseur permettant de récupérer les valeurs de l'objet entrant.
     *
     * @param key Clé du champ
     * @return Valeur du champ
     * @throws ExceptionAttributeUndefined
     */
    Serializable getOldValue(String key) throws ExceptionAttributeUndefined;

    /**
     * Accesseur permettant de récupérer les valeurs de l'objet sortant.
     *
     * @param key Clé du champ
     * @return Valeur du champ
     * @throws ExceptionAttributeUndefined
     */
    Serializable getValue(String key) throws ExceptionAttributeUndefined;

    /**
     * Modificateur permettant de définir la valeur d'un attribut de l'objet
     * sortant.
     *
     * @param nameAtt Nom de l'attribut
     * @param valueAtt Valeur de l'attribut
     */
    void setValue(String nameAtt, Serializable valueAtt);

    /**
     * Recopie un attribut
     * @param nameAtt le nom de l'attribut
     */
    void copy(String nameAtt);

    /**
     * Recopie tous les attributs.
     */
    void copyAll();

    /**
     * Suppression d'un attribut de la map de sortie.
     * @param nameAtt Nom de l'attribut.
     * @throws ExceptionAttributeUndefined
     */
    void delete(String nameAtt) throws ExceptionAttributeUndefined;

    /**
     * Suppression de tous les attributs de la map de sortie.
     */
    void deleteAll();

    /**
     * Fonction qui permet de récupérer une Map afin de la sauvegarder
     * directement en base.
     *
     * @return La map complète.
     */
    Map<String, Object> getOuterMap();

    /**
     * Fonction qui permet de récupérer une Map contenant toutes les
     * informations de l'objet en entrée.
     *
     * @return La map complète.
     */
    Map<String, Object> getInnerMap();

    /**
     * Retourne l'identifiant de l'objet.
     * @return l'identifiant.
     */
    Serializable getIdInner();
}
