/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.migration;

import java.lang.reflect.Array;
import java.util.Arrays;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.migration.TMSVersion;
import org.nuiton.topia.migration.TMSVersionDAO;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityEnum;

public class MigrationServiceDAOHelper {
    public static final String entitiesList = "org.nuiton.topia.migration.TMSVersionImpl";

    protected MigrationServiceDAOHelper() {
    }

    public static String getModelVersion() {
        return "1";
    }

    public static TMSVersionDAO getTMSVersionDAO(TopiaContext context) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        TMSVersionDAO result = (TMSVersionDAO)ci.getDAO(TMSVersion.class);
        return result;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, Class<T> klass) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        MigrationServiceEntityEnum constant = MigrationServiceEntityEnum.valueOf(klass);
        TopiaDAO dao = ci.getDAO(constant.getContract());
        return (D)dao;
    }

    public static <T extends TopiaEntity, D extends TopiaDAO<? super T>> D getDAO(TopiaContext context, T entity) throws TopiaException {
        TopiaContextImplementor ci = (TopiaContextImplementor)context;
        MigrationServiceEntityEnum constant = MigrationServiceEntityEnum.valueOf(entity);
        TopiaDAO dao = ci.getDAO(constant.getContract());
        return (D)dao;
    }

    public static <T extends TopiaEntity> Class<T> getContractClass(Class<T> klass) {
        MigrationServiceEntityEnum constant = MigrationServiceEntityEnum.valueOf(klass);
        return constant.getContract();
    }

    public static <T extends TopiaEntity> Class<T> getImplementationClass(Class<T> klass) {
        MigrationServiceEntityEnum constant = MigrationServiceEntityEnum.valueOf(klass);
        return constant.getImplementation();
    }

    public static Class<? extends TopiaEntity>[] getContractClasses() {
        MigrationServiceEntityEnum[] values = MigrationServiceEntityEnum.values();
        Class[] result = (Class[])Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getContract();
        }
        return result;
    }

    public static Class<? extends TopiaEntity>[] getImplementationClasses() {
        MigrationServiceEntityEnum[] values = MigrationServiceEntityEnum.values();
        Class[] result = (Class[])Array.newInstance(Class.class, values.length);
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i].getImplementation();
        }
        return result;
    }

    public static String getImplementationClassesAsString() {
        StringBuilder buffer = new StringBuilder();
        for (Class<? extends TopiaEntity> aClass : MigrationServiceDAOHelper.getImplementationClasses()) {
            buffer.append(',').append(aClass.getName());
        }
        return buffer.substring(1);
    }

    public static MigrationServiceEntityEnum[] getContracts() {
        return MigrationServiceEntityEnum.values();
    }

    public static enum MigrationServiceEntityEnum implements TopiaEntityEnum
    {
        TMSVersion(TMSVersion.class);

        private Class<? extends TopiaEntity> contract;
        private String implementationFQN;
        private Class<? extends TopiaEntity> implementation;

        private MigrationServiceEntityEnum(Class<? extends TopiaEntity> contract) {
            this.contract = contract;
            this.implementationFQN = contract.getName() + "Impl";
        }

        public Class<? extends TopiaEntity> getContract() {
            return this.contract;
        }

        @Deprecated
        public Class<? extends TopiaEntity> getContractClass() {
            return this.getContract();
        }

        @Deprecated
        public Class<? extends TopiaEntity> getImplementationClass() {
            return this.getImplementation();
        }

        public String getImplementationFQN() {
            return this.implementationFQN;
        }

        public synchronized void setImplementationFQN(String implementationFQN) {
            this.implementationFQN = implementationFQN;
            this.implementation = null;
        }

        public boolean accept(Class<? extends TopiaEntity> klass) {
            return MigrationServiceDAOHelper.getContractClass(klass) == this.contract;
        }

        public Class<? extends TopiaEntity> getImplementation() {
            if (this.implementation == null) {
                try {
                    this.implementation = Class.forName(this.implementationFQN);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("could not find class " + this.implementationFQN);
                }
            }
            return this.implementation;
        }

        public static MigrationServiceEntityEnum valueOf(TopiaEntity entity) {
            return MigrationServiceEntityEnum.valueOf(entity.getClass());
        }

        public static MigrationServiceEntityEnum valueOf(Class<?> klass) {
            if (klass.isInterface()) {
                return MigrationServiceEntityEnum.valueOf(klass.getSimpleName());
            }
            for (MigrationServiceEntityEnum entityEnum : MigrationServiceEntityEnum.values()) {
                if (!entityEnum.getContract().isAssignableFrom(klass)) continue;
                return entityEnum;
            }
            throw new IllegalArgumentException("no entity defined for the class " + klass + " in : " + Arrays.toString((Object[])MigrationServiceEntityEnum.values()));
        }
    }
}

