package org.nuiton.topia.history.entities;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.EntityVisitor;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.topia.persistence.TopiaEntityAbstract;


public abstract class HistoryAbstract extends TopiaEntityAbstract implements History {

    protected Date actionDate;
    protected String userId;
    protected int action;
    protected String type;
    protected String target;
    /**
     * update :
     * @throws TopiaException
     */

    public void update() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(History.class).update(this);
}

    /**
     * delete :
     * @throws TopiaException
     */

    public void delete() throws TopiaException {
        ((TopiaContextImplementor)getTopiaContext()).getDAO(History.class).delete(this);
}

    /**
     * accept :
     * Envoi via les methodes du visitor l'ensemble des champs de l'entity
avec leur nom, type et valeur.
     * @param visitor le visiteur de l'entite.
     * @throws TopiaException
     */

    public void accept(EntityVisitor visitor) throws TopiaException {
        visitor.start(this);
        visitor.visit(this, ACTION_DATE, Date.class, actionDate);
        visitor.visit(this, USER_ID, String.class, userId);
        visitor.visit(this, ACTION, int.class, action);
        visitor.visit(this, TYPE, String.class, type);
        visitor.visit(this, TARGET, String.class, target);
        visitor.end(this);
}

    /**
     * accept :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> accept() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            result.add(entity);
            result.addAll(entity.getAggregate());
        }

        return result;
}

    /**
     * getComposite :
     * @return List<TopiaEntity> 
     * @throws TopiaException
     */

    public List<TopiaEntity> getComposite() throws TopiaException {
        List<TopiaEntity> tmp = new ArrayList<TopiaEntity>();

        // pour tous les attributs rechecher les composites et les class d'asso
        // on les ajoute dans tmp

        // on refait un tour sur chaque entity de tmp pour recuperer leur
        // composite
        List<TopiaEntity> result = new ArrayList<TopiaEntity>();
        for (TopiaEntity entity : tmp) {
            if (entity != null) {
                result.add(entity);
                result.addAll(entity.getComposite());
            }
        }

        return result;
}

    /**
     * setActionDate :
     * @param value 
     */

    public void setActionDate(Date value) {
        Date _oldValue = this.actionDate;
        fireOnPreWrite(ACTION_DATE, _oldValue, value);
        this.actionDate = value;
        fireOnPostWrite(ACTION_DATE, _oldValue, value);
}

    /**
     * getActionDate :
     * @return Date 
     */

    public Date getActionDate() {
        fireOnPreRead(ACTION_DATE, actionDate);
        Date result = this.actionDate;
        fireOnPostRead(ACTION_DATE, actionDate);
        return result;
}

    /**
     * setUserId :
     * @param value 
     */

    public void setUserId(String value) {
        String _oldValue = this.userId;
        fireOnPreWrite(USER_ID, _oldValue, value);
        this.userId = value;
        fireOnPostWrite(USER_ID, _oldValue, value);
}

    /**
     * getUserId :
     * @return String 
     */

    public String getUserId() {
        fireOnPreRead(USER_ID, userId);
        String result = this.userId;
        fireOnPostRead(USER_ID, userId);
        return result;
}

    /**
     * setAction :
     * @param value 
     */

    public void setAction(int value) {
        int _oldValue = this.action;
        fireOnPreWrite(ACTION, _oldValue, value);
        this.action = value;
        fireOnPostWrite(ACTION, _oldValue, value);
}

    /**
     * getAction :
     * @return int 
     */

    public int getAction() {
        fireOnPreRead(ACTION, action);
        int result = this.action;
        fireOnPostRead(ACTION, action);
        return result;
}

    /**
     * setType :
     * @param value 
     */

    public void setType(String value) {
        String _oldValue = this.type;
        fireOnPreWrite(TYPE, _oldValue, value);
        this.type = value;
        fireOnPostWrite(TYPE, _oldValue, value);
}

    /**
     * getType :
     * @return String 
     */

    public String getType() {
        fireOnPreRead(TYPE, type);
        String result = this.type;
        fireOnPostRead(TYPE, type);
        return result;
}

    /**
     * setTarget :
     * @param value 
     */

    public void setTarget(String value) {
        String _oldValue = this.target;
        fireOnPreWrite(TARGET, _oldValue, value);
        this.target = value;
        fireOnPostWrite(TARGET, _oldValue, value);
}

    /**
     * getTarget :
     * @return String 
     */

    public String getTarget() {
        fireOnPreRead(TARGET, target);
        String result = this.target;
        fireOnPostRead(TARGET, target);
        return result;
}

    /**
     * toString :
     * @return String 
     */

    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
            append(ACTION_DATE, this.actionDate).
            append(USER_ID, this.userId).
            append(ACTION, this.action).
            append(TYPE, this.type).
            append(TARGET, this.target).
         toString();
        return result;
}


} //HistoryAbstract
