package org.nuiton.topia.persistence.jdbc;

/*
 * #%L
 * ToPIA :: Persistence
 * %%
 * Copyright (C) 2004 - 2015 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.io.Serializable;
import java.sql.Driver;

/**
 * Jdbc part of the configuration needed to instantiate a {@link org.nuiton.topia.persistence.TopiaApplicationContext}.
 *
 * Please use an instance of {@link org.nuiton.topia.persistence.jdbc.JdbcConfigurationBuilder} to build a new
 * JdbcTopiaConfiguration.
 *
 * @author Brendan Le Ny (Code Lutin)
 * @author Arnaud Thimel (Code Lutin)
 * @since 3.0
 */
public interface JdbcConfiguration extends Serializable {

    String getJdbcConnectionUrl();

    String getJdbcConnectionUser();

    String getJdbcConnectionPassword();

    Class<? extends Driver> getJdbcDriverClass();

}
