package org.nuiton.topia.persistence;

/*
 * #%L
 * ToPIA :: Persistence
 * $Id: TopiaEntity.java 3101 2014-05-09 05:52:11Z tchemit $
 * $HeadURL: https://svn.nuiton.org/topia/tags/topia-3.0-beta-4/topia-persistence/src/main/java/org/nuiton/topia/persistence/TopiaEntity.java $
 * %%
 * Copyright (C) 2004 - 2014 CodeLutin, Chemit Tony
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.Date;

/**
 * The TopiaEntity is the main interface for each generated entity.
 * <p/>
 * An entity is just a persistent bean mapped with Hibernate. The manipulation on entities (create, update, delete,
 * find) is made by the associated {@link org.nuiton.topia.persistence.TopiaDao}.
 * <p/>
 * Setter methods have to be used only in internal. They are in the interface to make easier their usages in internal.
 *
 * @author poussin <poussin@codelutin.com>
 * @author fdesbois <fdesbois@codelutin.com>
 */
public interface TopiaEntity extends Serializable {

    String PROPERTY_TOPIA_ID = "topiaId";

    /**
     * @deprecated since 3.0, will be removed in 3.1, use {@link TopiaEntity#PROPERTY_TOPIA_ID} instead
     */
    @Deprecated
    String TOPIA_ID = PROPERTY_TOPIA_ID;

    String PROPERTY_TOPIA_CREATE_DATE = "topiaCreateDate";

    /**
     * @deprecated since 3.0, will be removed in 3.1, use {@link TopiaEntity#PROPERTY_TOPIA_CREATE_DATE} instead
     */
    @Deprecated
    String TOPIA_CREATE_DATE = PROPERTY_TOPIA_CREATE_DATE;

    String PROPERTY_TOPIA_VERSION = "topiaVersion";

    /**
     * @deprecated since 3.0, will be removed in 3.1, use {@link TopiaEntity#PROPERTY_TOPIA_VERSION} instead
     */
    @Deprecated
    String TOPIA_VERSION = PROPERTY_TOPIA_VERSION;

    /**
     * @deprecated since 3.0, will be removed in 3.1, unused
     */
    @Deprecated
    String COMPOSITE = "composite";

    /**
     * @deprecated since 3.0, will be removed in 3.1, unused
     */
    @Deprecated
    String AGGREGATE = "aggregate";

    /**
     * Unique technical Id of the entity. This id contains the fully qualified name of the entity interface. This id
     * also has an index and is used to uniquely identify the entity in the database.
     *
     * @return the technical Id of the entity
     */
    String getTopiaId();

    /**
     * Set the technical {@code id} of the entity. Make sure to use this method only for copy. The technical id is
     * generated by ToPIA when the entity is persisted using the {@link org.nuiton.topia.persistence.TopiaDao#create()}
     * methods.
     *
     * @param id technical id to set
     */
    void setTopiaId(String id);

    /**
     * Technical property to keep versionning of the entity. The version is incremented on each change of the entity.
     *
     * @return the current version of the entity
     */
    long getTopiaVersion();

    /**
     * Set the technical {@code version} of the entity. Make sure to use this method only for copy. The version is
     * automatically incremented on entity changes.
     *
     * @param version technical version to set
     */
    void setTopiaVersion(long version);

    /**
     * Technical date creation of the entity. This date doesn't change through time and was initialized on entity
     * creation when using the {@link org.nuiton.topia.persistence.TopiaDao#create()} methods.
     *
     * @return the creation date of the entity
     */
    Date getTopiaCreateDate();

    /**
     * Set the technical creation {@code date} of the entity. Make sure to use this method only for copy. This date is
     * immutable and was created on entity creation.
     *
     * @param date technical create date to set
     */
    void setTopiaCreateDate(Date date);

    /**
     * This method must be used to know if the current entity is present on the persistent support. If the entity is not
     * yet persisted or if the entity has been removed, this method will return false.
     *
     * @return true if the entity is persisted and not yet deleted
     * @since 3.0
     */
    boolean isPersisted();

    /**
     * @return Is the entity was removed from persistent support ?
     * @since 3.0
     */
    boolean isDeleted();

    /**
     * Notifies the current entity instance than it has been removed from the persistent support.
     *
     * @since 3.0
     */
    void notifyDeleted();

    /**
     * Route the entity using a {@code visitor}.
     *
     * @param visitor to used
     */
    void accept(TopiaEntityVisitor visitor);

    //------------------------------------------------------------------------//
    //-- PropertyListener (read) methods -------------------------------------//
    //------------------------------------------------------------------------//

    /**
     * Adds a {@link java.beans.PropertyChangeListener} on any property reading.
     *
     * @param listener the listener to register
     * @see java.beans.PropertyChangeSupport
     */
    void addPropertyListener(PropertyChangeListener listener);

    /**
     * Adds a {@link java.beans.PropertyChangeListener} on the given property reading.
     *
     * @param propertyName the property name to listen
     * @param listener     the listener to register
     * @see java.beans.PropertyChangeSupport
     */
    void addPropertyListener(String propertyName, PropertyChangeListener listener);

    /**
     * Remove the given {@link java.beans.PropertyChangeListener} registered for any property reading.
     *
     * @param listener the listener to unregister
     * @see java.beans.PropertyChangeSupport
     */
    void removePropertyListener(PropertyChangeListener listener);

    /**
     * Remove the given {@link java.beans.PropertyChangeListener} registered the given property reading.
     *
     * @param propertyName the property name to unregister reading
     * @param listener     the listener to unregister
     * @see java.beans.PropertyChangeSupport
     */
    void removePropertyListener(String propertyName, PropertyChangeListener listener);

    //------------------------------------------------------------------------//
    //-- PropertyChangeListener (write) methods ------------------------------//
    //------------------------------------------------------------------------//

    /**
     * Adds a {@link java.beans.PropertyChangeListener} on any property writing.
     *
     * @param listener the listener to register
     * @see java.beans.PropertyChangeSupport
     */
    void addPropertyChangeListener(PropertyChangeListener listener);

    /**
     * Adds a {@link java.beans.PropertyChangeListener} on the given property writing.
     *
     * @param propertyName the property name to listen
     * @param listener     the listener to register
     * @see java.beans.PropertyChangeSupport
     */
    void addPropertyChangeListener(String propertyName, PropertyChangeListener listener);

    /**
     * Remove the given {@link java.beans.PropertyChangeListener} registered for any property writing.
     *
     * @param listener the listener to unregister
     * @see java.beans.PropertyChangeSupport
     */
    void removePropertyChangeListener(PropertyChangeListener listener);

    /**
     * Remove the given {@link java.beans.PropertyChangeListener} registered the given property writing.
     *
     * @param propertyName the property name to unregister writing
     * @param listener     the listener to unregister
     * @see java.beans.PropertyChangeSupport
     */
    void removePropertyChangeListener(String propertyName, PropertyChangeListener listener);

    //------------------------------------------------------------------------//
    //-- VetoableListener (read) methods -------------------------------------//
    //------------------------------------------------------------------------//

    /**
     * Adds a {@link java.beans.VetoableChangeListener} on any property reading.
     *
     * @param vetoable the listener to register
     * @see java.beans.VetoableChangeSupport
     */
    void addVetoableListener(VetoableChangeListener vetoable);

    /**
     * Adds a {@link java.beans.VetoableChangeListener} on the given property reading.
     *
     * @param propertyName the property name to listen
     * @param vetoable     the listener to register
     * @see java.beans.VetoableChangeSupport
     */
    void addVetoableListener(String propertyName, VetoableChangeListener vetoable);

    /**
     * Remove the given {@link java.beans.VetoableChangeListener} registered for any property reading.
     *
     * @param vetoable the listener to unregister
     * @see java.beans.VetoableChangeSupport
     */
    void removeVetoableListener(VetoableChangeListener vetoable);

    /**
     * Remove the given {@link java.beans.VetoableChangeListener} registered the given property reading.
     *
     * @param propertyName the property name to unregister reading
     * @param vetoable     the listener to unregister
     * @see java.beans.VetoableChangeSupport
     */
    void removeVetoableListener(String propertyName, VetoableChangeListener vetoable);

    //------------------------------------------------------------------------//
    //-- VetoableChangeListener (write) methods ------------------------------//
    //------------------------------------------------------------------------//

    /**
     * Adds a {@link java.beans.VetoableChangeListener} on any property writing.
     *
     * @param vetoable the listener to register
     * @see java.beans.VetoableChangeSupport
     */
    void addVetoableChangeListener(VetoableChangeListener vetoable);

    /**
     * Adds a {@link java.beans.VetoableChangeListener} on the given property writing.
     *
     * @param propertyName the property name to listen
     * @param vetoable     the listener to register
     * @see java.beans.VetoableChangeSupport
     */
    void addVetoableChangeListener(String propertyName, VetoableChangeListener vetoable);

    /**
     * Remove the given {@link java.beans.VetoableChangeListener} registered for any property writing.
     *
     * @param vetoable the listener to unregister
     * @see java.beans.VetoableChangeSupport
     */
    void removeVetoableChangeListener(VetoableChangeListener vetoable);

    /**
     * Remove the given {@link java.beans.VetoableChangeListener} registered the given property writing.
     *
     * @param propertyName the property name to unregister writing
     * @param vetoable     the listener to unregister
     * @see java.beans.VetoableChangeSupport
     */
    void removeVetoableChangeListener(String propertyName, VetoableChangeListener vetoable);

}
