/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.topia.framework;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.EntityFilter;
import org.nuiton.topia.persistence.TopiaEntity;
import org.nuiton.util.StringUtil;

public class TopiaQuery {
    private static final Log log = LogFactory.getLog(TopiaQuery.class);
    public static final String FROM_SEPARATOR_DEFAULT = ",";
    public static final String FROM_SEPARATOR_JOIN = "JOIN";
    public static final String FROM_SEPARATOR_LEFT_JOIN = "LEFT JOIN";
    protected List<Object> params;
    protected StringBuilder select;
    protected boolean distinct;
    protected StringBuilder from;
    protected StringBuilder where;
    protected StringBuilder orderBy;
    protected StringBuilder groupBy;
    protected Integer startIndex;
    protected Integer endIndex;
    protected boolean parentheses = true;
    protected List<String> propertiesToLoad;
    protected String mainAlias;

    public TopiaQuery() {
    }

    public TopiaQuery(Class<? extends TopiaEntity> mainEntityClass) {
        this();
        this.setFrom(mainEntityClass);
    }

    public TopiaQuery(Class<? extends TopiaEntity> mainEntityClass, String alias) {
        this();
        this.setFrom(mainEntityClass, alias);
    }

    public TopiaQuery setFrom(Class<? extends TopiaEntity> mainEntityClass) {
        this.setFrom(mainEntityClass, null);
        return this;
    }

    public TopiaQuery setFrom(Class<? extends TopiaEntity> mainEntityClass, String alias) {
        this.from = new StringBuilder(" FROM ").append(mainEntityClass.getName());
        this.mainAlias = alias;
        if (StringUtils.isNotEmpty((String)this.mainAlias)) {
            this.from.append(' ').append(alias);
        }
        return this;
    }

    @Deprecated
    public TopiaQuery addFrom(String str) {
        return this.addFrom(FROM_SEPARATOR_DEFAULT, str, null);
    }

    protected TopiaQuery addFrom(String separator, String property, String alias) {
        if (!separator.equals(FROM_SEPARATOR_DEFAULT)) {
            this.from.append(' ');
        }
        this.from.append(separator).append(' ').append(property);
        if (alias != null) {
            this.from.append(' ').append(alias);
        }
        return this;
    }

    public TopiaQuery addJoin(String property, String alias, boolean fetch) {
        return this.addFromJoin(FROM_SEPARATOR_JOIN, property, alias, fetch);
    }

    public TopiaQuery addLeftJoin(String property, String alias, boolean fetch) {
        return this.addFromJoin(FROM_SEPARATOR_LEFT_JOIN, property, alias, fetch);
    }

    protected TopiaQuery addFromJoin(String separator, String property, String alias, boolean fetch) {
        String sep = separator;
        if (fetch) {
            sep = separator + " FETCH";
        }
        return this.addFrom(sep, property, alias);
    }

    public TopiaQuery addFrom(Class<? extends TopiaEntity> entityClass) {
        return this.addFrom(entityClass, null);
    }

    public TopiaQuery addFrom(Class<? extends TopiaEntity> entityClass, String alias) {
        return this.addFrom(FROM_SEPARATOR_DEFAULT, entityClass.getName(), alias);
    }

    public String fullQuery() {
        StringBuilder result = new StringBuilder();
        StringBuilder selectStatement = new StringBuilder("SELECT ");
        if (this.distinct) {
            selectStatement.append("DISTINCT ");
        }
        if (this.select != null) {
            result.append((CharSequence)selectStatement).append((CharSequence)this.select);
        } else if (StringUtils.contains((String)this.from.toString(), (char)',') && StringUtils.isNotEmpty((String)this.mainAlias)) {
            result.append((CharSequence)selectStatement).append(this.mainAlias);
        }
        result.append((CharSequence)this.from);
        if (this.where != null) {
            result.append((CharSequence)this.where);
        }
        if (this.groupBy != null) {
            result.append((CharSequence)this.groupBy);
        }
        if (this.orderBy != null) {
            result.append((CharSequence)this.orderBy);
        }
        return StringUtils.trim((String)result.toString());
    }

    public TopiaQuery addParam(String id, Object paramValue) {
        this.getParams().add(id);
        this.getParams().add(paramValue);
        return this;
    }

    public TopiaQuery addParams(List<Object> params) {
        for (int i = 0; i < params.size(); i += 2) {
            String paramName = (String)params.get(i);
            this.addParam(this.getValueName(paramName), params.get(i + 1));
        }
        return this;
    }

    public List<Object> getParams() {
        if (this.params == null) {
            this.params = new ArrayList<Object>();
        }
        return this.params;
    }

    public String getMainAlias() {
        return this.mainAlias;
    }

    public TopiaQuery addLoad(String ... properties) {
        this.getPropertiesToLoad().addAll(Arrays.asList(properties));
        return this;
    }

    public TopiaQuery addFetch(String ... properties) {
        boolean needAlias = false;
        if (StringUtils.isEmpty((String)this.mainAlias)) {
            this.mainAlias = RandomStringUtils.randomAlphabetic((int)4);
            this.from.append(' ').append(this.mainAlias);
            needAlias = true;
        }
        if (this.select == null) {
            this.setSelect(this.mainAlias);
        }
        for (String current : properties) {
            String property = needAlias ? TopiaQuery.getProperty(this.mainAlias, current) : current;
            String[] parts = property.split("\\.");
            String alias = parts[0];
            for (int i = 1; i < parts.length; ++i) {
                String propertyToJoin = TopiaQuery.getProperty(alias, parts[i]);
                alias = i + 1 < parts.length ? RandomStringUtils.randomAlphabetic((int)4) : null;
                this.addLeftJoin(propertyToJoin, alias, true);
            }
        }
        return this;
    }

    protected List<String> getPropertiesToLoad() {
        if (this.propertiesToLoad == null) {
            this.propertiesToLoad = new ArrayList<String>();
        }
        return this.propertiesToLoad;
    }

    @Deprecated
    public TopiaQuery add(String where) {
        return this.addWhere(where);
    }

    public TopiaQuery addWhere(String where) {
        if (StringUtils.isEmpty((String)where)) {
            return this;
        }
        if (this.where == null) {
            this.where = new StringBuilder(" WHERE ");
        } else {
            this.where.append(" AND ");
        }
        if (this.parentheses) {
            this.where.append('(');
        }
        this.where.append(where);
        if (this.parentheses) {
            this.where.append(')');
        }
        this.parentheses = true;
        return this;
    }

    @Deprecated
    public TopiaQuery add(String paramName, Op constraint, Object paramValue) {
        return this.addWhere(paramName, constraint, paramValue);
    }

    public TopiaQuery addWhere(String paramName, Op operator, Object paramValue) {
        StringBuilder result = new StringBuilder(paramName).append(' ');
        if (log.isTraceEnabled()) {
            log.trace((Object)("paramValue = " + paramValue));
        }
        if (paramValue == null) {
            result.append((Object)Op.NULL);
        } else {
            String valueName = this.getValueName(paramName);
            result.append((Object)operator).append(" :").append(valueName);
            this.addParam(valueName, paramValue);
        }
        this.parentheses = false;
        return this.addWhere(result.toString());
    }

    protected String getValueName(String paramName) {
        int dot = paramName.lastIndexOf(46);
        String valueName = paramName;
        if (dot != -1) {
            valueName = paramName.substring(dot + 1);
        }
        if (this.getParams().contains(valueName)) {
            valueName = valueName + "_" + RandomStringUtils.randomAlphanumeric((int)4);
        }
        return valueName;
    }

    public TopiaQuery add(String paramName, Object ... paramValue) {
        return this.addEquals(paramName, paramValue);
    }

    public TopiaQuery addEquals(String paramName, Object ... paramValue) {
        if (paramValue == null) {
            return this.addWhere(paramName, Op.EQ, null);
        }
        int length = paramValue.length;
        if (length == 0) {
            return this;
        }
        if (length == 1) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("Only one value " + Arrays.toString(paramValue)));
            }
            return this.addWhere(paramName, Op.EQ, paramValue[0]);
        }
        StringBuilder values = new StringBuilder();
        int count = 1;
        boolean addNull = false;
        for (Object value : paramValue) {
            if (value != null) {
                String valueName = this.getValueName(paramName + count);
                if (count != 1) {
                    values.append(", ");
                }
                values.append(':').append(valueName);
                this.addParam(valueName, value);
                ++count;
                continue;
            }
            addNull = true;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(paramName).append(" IN (").append((CharSequence)values).append(")");
        if (addNull) {
            buffer.append(" OR ").append(paramName).append(' ').append(Op.NULL.toString());
        } else {
            this.parentheses = false;
        }
        return this.addWhere(buffer.toString());
    }

    @Deprecated
    public TopiaQuery add(Map<String, Object> properties) {
        return this.addEquals(properties);
    }

    public TopiaQuery addEquals(Map<String, Object> properties) {
        for (String key : properties.keySet()) {
            this.addEquals(key, properties.get(key));
        }
        return this;
    }

    public TopiaQuery addNotNull(String paramName) {
        StringBuilder result = new StringBuilder(paramName).append(' ').append((Object)Op.NOT_NULL);
        this.parentheses = false;
        this.addWhere(result.toString());
        this.parentheses = true;
        return this;
    }

    public TopiaQuery addNullOr(String paramName, Op constraint, Object paramValue) {
        String valueName = this.getValueName(paramName);
        StringBuilder result = new StringBuilder(paramName).append(' ').append((Object)Op.NULL).append(" OR ").append(paramName).append((Object)constraint).append(" :").append(valueName);
        this.addParam(valueName, paramValue);
        return this.addWhere(result.toString());
    }

    public TopiaQuery addNull(String paramName) {
        this.addWhere(paramName, Op.EQ, null);
        return this;
    }

    public TopiaQuery addBetween(String paramName, Object value1, Object value2) {
        String valueName = this.getValueName(paramName);
        String valueName1 = valueName + '1';
        String valueName2 = valueName + '2';
        this.addParam(valueName1, value1);
        this.addParam(valueName2, value2);
        StringBuilder builder = new StringBuilder(paramName).append(" BETWEEN ").append(':').append(valueName1).append(" AND ").append(':').append(valueName2);
        this.parentheses = false;
        this.addWhere(builder.toString());
        this.parentheses = true;
        return this;
    }

    public TopiaQuery addInElements(String elementProperty, String containerProperty) {
        StringBuilder builder = new StringBuilder(elementProperty).append(" IN elements(").append(containerProperty).append(')');
        this.parentheses = false;
        this.addWhere(builder.toString());
        this.parentheses = true;
        return this;
    }

    public TopiaQuery addSubQuery(String queryPart, TopiaQuery subquery) {
        List<Object> subqueryParams = subquery.getParams();
        String subqueryString = subquery.fullQuery();
        if (CollectionUtils.isEmpty(this.params)) {
            this.addParams(subqueryParams);
        } else {
            for (int i = 0; i < subqueryParams.size(); i += 2) {
                String paramName = (String)subqueryParams.get(i);
                Object paramValue = subqueryParams.get(i + 1);
                int index = this.params.indexOf(paramName);
                if (index == -1) {
                    this.addParam(paramName, paramValue);
                    continue;
                }
                Object existingValue = this.params.get(index + 1);
                if (ObjectUtils.equals((Object)existingValue, (Object)paramValue)) continue;
                String newParamName = this.getValueName(paramName);
                subqueryString = subqueryString.replace(":" + paramName, ":" + newParamName);
                this.addParam(newParamName, paramValue);
            }
        }
        String result = queryPart.replace("?", subqueryString);
        return this.addWhere(result);
    }

    public TopiaQuery addSelect(String ... select) {
        String str = this.convertStringArray(select);
        if (this.mainAlias != null && str.equals(this.mainAlias)) {
            return this;
        }
        if (this.select != null) {
            this.select.append(", ");
        } else {
            this.select = this.mainAlias != null ? new StringBuilder(this.mainAlias).append(", ") : new StringBuilder();
        }
        this.select.append(this.convertStringArray(select));
        return this;
    }

    public TopiaQuery setSelect(String ... select) {
        this.select = new StringBuilder(this.convertStringArray(select));
        return this;
    }

    public TopiaQuery addDistinct() {
        this.distinct = true;
        return this;
    }

    public TopiaQuery addOrder(String ... order) {
        if (this.orderBy == null) {
            this.orderBy = new StringBuilder(" ORDER BY ");
        } else {
            this.orderBy.append(", ");
        }
        this.orderBy.append(this.convertStringArray(order));
        return this;
    }

    public TopiaQuery addOrderDesc(String order) {
        return this.addOrder(order + " DESC");
    }

    public TopiaQuery addGroup(String ... group) {
        if (this.groupBy == null) {
            this.groupBy = new StringBuilder(" GROUP BY ");
        } else {
            this.groupBy.append(", ");
        }
        this.groupBy.append(this.convertStringArray(group));
        return this;
    }

    protected String convertStringArray(String ... array) {
        StringBuilder result = new StringBuilder();
        for (String value : array) {
            result.append(", ").append(value);
        }
        String str = "";
        if (result.length() > 0) {
            str = result.substring(2);
        }
        return str;
    }

    public TopiaQuery setLimit(int start, int end) {
        this.startIndex = start;
        this.endIndex = end;
        return this;
    }

    public TopiaQuery resetLimit() {
        this.startIndex = null;
        this.endIndex = null;
        return this;
    }

    public TopiaQuery setMaxResults(int max) {
        return this.setLimit(0, max - 1);
    }

    public TopiaQuery addFilter(EntityFilter filter) throws IllegalArgumentException {
        return this.addFilter(filter, null);
    }

    public TopiaQuery addFilter(EntityFilter filter, String propertyToFilter) throws IllegalArgumentException {
        if (propertyToFilter == null) {
            propertyToFilter = this.mainAlias;
        }
        Integer startIndex = filter.getStartIndex();
        Integer endIndex = filter.getEndIndex();
        String orderBy = filter.getOrderBy();
        String referenceId = filter.getReferenceId();
        String referenceProperty = filter.getReferenceProperty();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Filter added to the query : " + filter));
        }
        if (startIndex != null && endIndex != null) {
            this.setLimit(startIndex, endIndex);
        } else if (endIndex != null) {
            this.setMaxResults(endIndex);
        }
        if (orderBy != null) {
            ArrayList<String> order = new ArrayList<String>();
            for (String elmt : orderBy.split(FROM_SEPARATOR_DEFAULT)) {
                String property = TopiaQuery.getProperty(propertyToFilter, elmt.trim());
                order.add(property);
            }
            this.addOrder(order.toArray(new String[order.size()]));
        } else {
            this.addOrderDesc(this.getPropertyCreateDate(propertyToFilter));
        }
        if (filter.hasReference()) {
            if (referenceProperty == null) {
                throw new IllegalArgumentException("Reference property need to be defined in filter to use referenceId = " + referenceId);
            }
            this.addEquals(this.getPropertyId(referenceProperty), referenceId);
        }
        return this;
    }

    public List execute(TopiaContext transaction) throws TopiaException {
        String query = this.fullQuery();
        if (log.isDebugEnabled()) {
            log.debug((Object)this);
        }
        if (this.startIndex != null && this.endIndex != null) {
            return transaction.find(query, this.startIndex, this.endIndex, this.getParams().toArray());
        }
        return transaction.find(query, this.getParams().toArray());
    }

    public <E extends TopiaEntity> List<E> executeToEntityList(TopiaContext transaction, Class<E> entityClass) throws TopiaException, ClassCastException {
        List res = this.execute(transaction);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Properties to load : " + this.getPropertiesToLoad()));
        }
        ArrayList<TopiaEntity> results = new ArrayList<TopiaEntity>();
        for (Object o : res) {
            if (o == null) continue;
            if (o instanceof Object[]) {
                o = ((Object[])o)[0];
            }
            if (!entityClass.isAssignableFrom(o.getClass())) {
                throw new ClassCastException(o.getClass().getName() + " can't be cast to " + entityClass.getName() + " o : " + o);
            }
            TopiaEntity entity = (TopiaEntity)o;
            if (this.distinct && results.contains(entity)) continue;
            if (!this.getPropertiesToLoad().isEmpty()) {
                this.loadProperties(entity);
            }
            results.add(entity);
        }
        return results;
    }

    public <E extends TopiaEntity, K> Map<K, E> executeToEntityMap(TopiaContext transaction, Class<E> entityClass, String keyName, Class<K> keyClass) throws TopiaException, ClassCastException {
        LinkedHashMap<Object, TopiaEntity> results = new LinkedHashMap<Object, TopiaEntity>();
        List<E> list = this.executeToEntityList(transaction, entityClass);
        for (TopiaEntity elmt : list) {
            Object value = this.loadProperty(elmt, keyName);
            if (value != null && !keyClass.isAssignableFrom(value.getClass())) {
                throw new ClassCastException(value.getClass().getName() + " can't be cast to " + keyClass.getName());
            }
            results.put(value, elmt);
        }
        return results;
    }

    public <E extends TopiaEntity> Map<String, E> executeToEntityMap(TopiaContext transaction, Class<E> entityClass) throws TopiaException, ClassCastException {
        return this.executeToEntityMap(transaction, entityClass, "topiaId", String.class);
    }

    public <E extends TopiaEntity> E executeToEntity(TopiaContext transaction, Class<E> entityClass) throws TopiaException, ClassCastException {
        this.setMaxResults(1);
        List<E> results = this.executeToEntityList(transaction, entityClass);
        this.resetLimit();
        return (E)(!results.isEmpty() ? (TopiaEntity)results.get(0) : null);
    }

    public Object executeToObject(TopiaContext transaction, String select) throws TopiaException {
        StringBuilder oldValue = this.select;
        if (!StringUtils.isEmpty((String)select)) {
            this.setSelect(select);
        }
        Object result = null;
        this.setMaxResults(1);
        List results = this.execute(transaction);
        if (!results.isEmpty()) {
            result = results.get(0);
        }
        this.select = oldValue;
        this.resetLimit();
        return result;
    }

    public int executeToInteger(TopiaContext transaction, String select) throws TopiaException {
        Long res = (Long)this.executeToObject(transaction, select);
        return res != null ? res.intValue() : 0;
    }

    public String executeToString(TopiaContext transaction, String select) throws TopiaException {
        Object res = this.executeToObject(transaction, select);
        return res != null ? (String)res : "";
    }

    public int executeCount(TopiaContext transaction) throws TopiaException {
        StringBuilder oldOrder = this.orderBy;
        this.orderBy = null;
        StringBuilder count = new StringBuilder("COUNT(");
        if (this.distinct && StringUtils.isNotEmpty((String)this.mainAlias)) {
            count.append("DISTINCT ").append(this.mainAlias);
        } else {
            count.append('*');
        }
        count.append(')');
        int result = this.executeToInteger(transaction, count.toString());
        this.orderBy = oldOrder;
        return result;
    }

    protected void loadProperties(TopiaEntity entity) throws TopiaException {
        for (String prop : this.getPropertiesToLoad()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("load property " + prop + " ..."));
            }
            List<String> str = Arrays.asList(prop.split("\\."));
            Iterator<String> it = str.iterator();
            TopiaEntity currEntity = entity;
            while (it.hasNext()) {
                String s = it.next();
                if (this.mainAlias != null && s.equals(this.mainAlias)) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)("Skip alias : " + this.mainAlias));
                    continue;
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Current entity : " + currEntity.getClass().getSimpleName()));
                    log.trace((Object)("Current loading : " + s));
                }
                if (it.hasNext()) {
                    currEntity = this.loadEntityProperty(currEntity, s);
                    continue;
                }
                this.loadProperty(currEntity, s);
            }
        }
    }

    protected <T extends TopiaEntity> TopiaEntity loadEntityProperty(T entity, String property) throws TopiaException {
        return (TopiaEntity)this.loadProperty(entity, property);
    }

    protected <T extends TopiaEntity> Object loadProperty(T entity, String property) throws TopiaException {
        try {
            Object res = PropertyUtils.getProperty(entity, (String)property);
            if (log.isDebugEnabled()) {
                log.debug((Object)("load property '" + property + "' for '" + entity.getClass().getSimpleName() + "'"));
            }
            if (res != null && Collection.class.isAssignableFrom(res.getClass())) {
                Collection list = (Collection)res;
                list.size();
            }
            return res;
        }
        catch (IllegalAccessException eee) {
            throw new TopiaException("Illegal access on property " + property + " from entity " + entity.getClass().getName(), eee);
        }
        catch (InvocationTargetException eee) {
            throw new TopiaException("Invocation error on entity " + entity.getClass().getName() + " for property " + property, eee);
        }
        catch (NoSuchMethodException eee) {
            throw new TopiaException("Getter method does not exist for property " + property + " from entity " + entity.getClass().getName(), eee);
        }
    }

    public static String getProperty(String ... entityProperty) {
        List<String> list = Arrays.asList(entityProperty);
        String result = StringUtil.join(list, (String)".", (boolean)false);
        return result;
    }

    public String getPropertyId(String alias) {
        return TopiaQuery.getProperty(alias, "topiaId");
    }

    public String getPropertyCreateDate(String alias) {
        return TopiaQuery.getProperty(alias, "topiaCreateDate");
    }

    public String getPropertyVersion(String alias) {
        return TopiaQuery.getProperty(alias, "topiaVersion");
    }

    protected void finalize() throws Throwable {
        this.select = null;
        this.from = null;
        this.where = null;
        this.orderBy = null;
        this.groupBy = null;
        super.finalize();
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.fullQuery()).append("; (PARAMS : ").append(this.getParams()).append("); (LIMIT : ").append(this.startIndex).append(", ").append(this.endIndex).append(')');
        return result.toString();
    }

    public static enum Op {
        EQ("="),
        GT(">"),
        GE(">="),
        LIKE("LIKE"),
        LT("<"),
        LE("<="),
        NOT_NULL("IS NOT NULL"),
        NULL("IS NULL"),
        NEQ("!=");

        protected String value;

        private Op(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

