/*
 * #%L
 * ToPIA :: Persistence
 * 
 * $Id: EntityVisitorExportXmlTest.java 1894 2010-04-15 15:44:51Z tchemit $
 * $HeadURL: http://svn.nuiton.org/svn/topia/tags/topia-2.4.2/topia-persistence/src/test/java/org/nuiton/topia/persistence/EntityVisitorExportXmlTest.java $
 * %%
 * Copyright (C) 2004 - 2010 CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.topia.persistence;

import java.io.File;
import java.io.IOException;
import java.util.Properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaContextFactory;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.TopiaTestDAOHelper;
import org.nuiton.topiatest.Address;
import org.nuiton.topiatest.AddressDAO;
import org.nuiton.topiatest.Company;
import org.nuiton.topiatest.CompanyDAO;
import org.nuiton.topiatest.Department;
import org.nuiton.topiatest.DepartmentDAO;
import org.nuiton.topiatest.Employe;
import org.nuiton.topiatest.EmployeDAO;
import org.nuiton.util.FileUtil;
import org.hibernate.cfg.Environment;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

/**
 * Test de visitor.
 *
 * @author chatellier
 * @version $Revision: 1894 $
 * 
 * Last update : $Date: 2010-04-15 17:44:51 +0200 (jeu., 15 avril 2010) $
 * By : $Author: tchemit $
 */
public class EntityVisitorExportXmlTest {

    private static Log log = LogFactory.getLog(EntityVisitorExportXmlTest.class);
    
    protected static File tempDir;
    
    protected static Properties config;
    
    /**
     * Init les données de tous les tests.
     * @throws IOException 
     */
    @BeforeClass
    public static void init() throws IOException {
        
        File tmpDirectory = new File("target");
        tempDir = FileUtil.createTempDirectory("h2", "-exportxml", tmpDirectory);
        
        // init dburl
        String dburl = "file:" + tempDir.getAbsolutePath() + File.separator + "data";
        
        // init config
        
        config = new Properties();
        config.setProperty("topia.persistence.classes",TopiaTestDAOHelper.getImplementationClassesAsString());

        config.setProperty(Environment.USER, "sa");
        config.setProperty(Environment.PASS, "");
        config.setProperty(Environment.CURRENT_SESSION_CONTEXT_CLASS, "thread");
        config.setProperty(Environment.DIALECT,"org.hibernate.dialect.H2Dialect");
        config.setProperty(Environment.DRIVER,"org.h2.Driver");
        config.setProperty(Environment.URL,"jdbc:h2:" + dburl);
    }

    /**
     * Remove temp directory
     */
    @AfterClass
    public static void clear() {
        FileUtil.deleteRecursively(tempDir);
    }
    
    /**
     * Prepare test.
     * 
     * Add all tests commons data
     * @throws TopiaException 
     */
    @Before
    public void setUp() throws TopiaException {
        TopiaContext context = TopiaContextFactory.getContext(config);
        context.createSchema();
        
        addData(context);
    }
    
    /**
     * Add tests data.
     * @param context the context to add
     * @throws TopiaException
     */
    protected void addData(TopiaContext context) throws TopiaException {
        
        TopiaContext newContext = context.beginTransaction();

        // company
        CompanyDAO companyDAO = TopiaTestDAOHelper.getCompanyDAO(newContext);
        Company clCompany = companyDAO.create();
        clCompany.setName("CodeLutin");
        
        // employe
        EmployeDAO employeDAO = TopiaTestDAOHelper.getEmployeDAO(newContext);
        Employe empl1 = employeDAO.create();
        empl1.setName("boss");
        empl1.setSalary(30000);

        AddressDAO adressDAO = TopiaTestDAOHelper.getAddressDAO(newContext);
        Address addr1 = adressDAO.create();
        addr1.setCity("nantes");
        addr1.setAdress("bd des pas enchantés");
        empl1.setAddress(addr1);
        
        Employe empl2 = employeDAO.create();
        empl2.setName("boss2");
        empl2.setSalary(29000);
        Address addr2 = adressDAO.create();
        addr2.setCity("nantes");
        addr2.setAdress("bd des pas enchantés");
        empl2.setAddress(addr2);
        
        // departement
        DepartmentDAO departmentDAO = TopiaTestDAOHelper.getDepartmentDAO(newContext);
        Department depComm = departmentDAO.create();
        depComm.setName("Commercial");
        depComm.setLeader(empl1);
        
        Department depDev = departmentDAO.create();
        depDev.setName("Dev");
        depDev.setLeader(empl2);
        clCompany.addDepartment(depComm);
        clCompany.addDepartment(depDev);
        
        newContext.commitTransaction();
        newContext.closeContext();
    }

    /**
     * Clean tests.
     */
    @After
    public void tearDown() {
       if(tempDir.exists()) {
           tempDir.delete();
       }
    }
    
    /**
     * Test l'export XML via un visiteur.
     * 
     * Parcourt en profondeur.
     * 
     * @throws TopiaException 
     */
    @Test
    public void testExportXMLDepth() throws TopiaException {
        TopiaContext rootContext = TopiaContextFactory.getContext(config);
        
        TopiaContext context = rootContext.beginTransaction();
        
        CompanyDAO companyDAO = TopiaTestDAOHelper.getCompanyDAO(context);
        Company clCompany = companyDAO.findByName("CodeLutin");
        
        EntityVisitor delegateVisitor = new ExportXMLVisitor();
        EntityVisitor visitor = new DepthEntityVisitor(delegateVisitor);
        clCompany.accept(visitor);
        context.closeContext();
        
        if(log.isInfoEnabled()) {
            log.info("Export XML = \n" + delegateVisitor.toString());
        }
    }
}
