package org.nuiton.topiatest;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOLegacy;
import org.nuiton.topia.persistence.TopiaEntity;


public abstract class ExtraDAOEntityDAOAbstract<E extends ExtraDAOEntity> extends TopiaDAOLegacy<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)ExtraDAOEntity.class;
    }

    /**
     * extra :
     * @throws TopiaException
     */

    public abstract void extra() throws TopiaException;

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
        super.delete(entity);
    }

    /**
     * findByAttr1 :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut attr1 le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByAttr1(String v) throws TopiaException {
        E result = findByProperty(ExtraDAOEntity.ATTR1, v);
        return result;
    }

    /**
     * findAllByAttr1 :
     * Retourne les éléments ayant comme valeur pour l'attribut attr1 le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByAttr1(String v) throws TopiaException {
        List<E> result = findAllByProperty(ExtraDAOEntity.ATTR1, v);
        return result;
    }

    /**
     * findUsages :
     * @param type 
     * @param entity 
     * @return <U extends TopiaEntity> List<U> 
     * @throws TopiaException
     */

    @Override
    public <U extends TopiaEntity> List<U> findUsages(Class<U> type, E entity) throws TopiaException {
        return new ArrayList<U>();
    }

    /**
     * findAllUsages :
     * @param entity 
     * @return Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> 
     * @throws TopiaException
     */

    @Override
    public Map<Class<? extends TopiaEntity>, List<? extends TopiaEntity>> findAllUsages(E entity) throws TopiaException {
        return new HashMap<Class<? extends TopiaEntity>, List<? extends TopiaEntity>>();
    }


} //ExtraDAOEntityDAOAbstract<E extends ExtraDAOEntity>
