/* *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

/* *
 * TopiaEntity.java
 *
 * Created: 28 déc. 2005 22:48:10
 *
 * @author poussin
 * @version $Revision: 1815 $
 *
 * Last update: $Date: 2010-02-26 19:48:25 +0100 (ven. 26 févr. 2010) $
 * by : $Author: tchemit $
 */

package org.nuiton.topia.persistence;

import java.beans.PropertyChangeListener;
import java.beans.VetoableChangeListener;
import java.util.Date;
import java.util.List;

import org.nuiton.topia.TopiaContext;
import org.nuiton.topia.TopiaException;

/**
 * TopiaEntity.
 * 
 * Toutes les methodes set ne doivent être utilisé que par le framework. Elle
 * sont publique car on ne peut pas faire autrement sur une interface.
 * 
 * @author poussin
 */
@SearchFields
public interface TopiaEntity {

    String TOPIA_ID = "topiaId";
    String TOPIA_CREATE_DATE = "topiaCreateDate";
    String TOPIA_VERSION = "topiaVersion";

    String getTopiaId();

    void setTopiaId(String v);

    long getTopiaVersion();

    void setTopiaVersion(long v);

    /**
     * @return Returns the topiaCreateTime.
     */
    Date getTopiaCreateDate();

    /**
     * @param topiaCreatedate the topiaCreateTime to set.
     */
    void setTopiaCreateDate(Date topiaCreatedate);

    TopiaContext getTopiaContext();

    /**
     * called just after object creation and initialisation
     * each entity impl can overide it to do something after creation
     * @throws TopiaException
     */
    void postCreate() throws TopiaException;

    void update() throws TopiaException;

    void delete() throws TopiaException;

    /**
     * @return all object that must be deleted if this object is deleted
     * @throws TopiaException
     */
    List<TopiaEntity> getComposite() throws TopiaException;

    /**
     * @return all object that are aggregate with this instance, aggreate object
     * are not removed automaticaly
     * @throws TopiaException
     */
    List<TopiaEntity> getAggregate() throws TopiaException;

    /**
     * Add listener for property writing.
     * 
     * @param propertyName
     * @param listener
     */
    void addPropertyChangeListener(String propertyName,
            PropertyChangeListener listener);

    /**
     * Add listener for property writing.
     * 
     * @param listener
     */
    void addPropertyChangeListener(PropertyChangeListener listener);

    void addVetoableChangeListener(String propertyName,
            VetoableChangeListener vetoable);

    void addVetoableChangeListener(VetoableChangeListener vetoable);

    void removePropertyChangeListener(String propertyName,
            PropertyChangeListener listener);

    void removePropertyChangeListener(PropertyChangeListener listener);

    void removeVetoableChangeListener(String propertyName,
            VetoableChangeListener vetoable);

    void removeVetoableChangeListener(VetoableChangeListener vetoable);

    /**
     * Add listener for property reading.
     * 
     * @param propertyName
     * @param listener
     */
    void addPropertyListener(String propertyName,
                             PropertyChangeListener listener);

    /**
     * Add listener for property reading.
     * 
     * @param listener
     */
    void addPropertyListener(PropertyChangeListener listener);

    void addVetoableListener(String propertyName,
            VetoableChangeListener vetoable);

    void addVetoableListener(VetoableChangeListener vetoable);

    void removePropertyListener(String propertyName,
            PropertyChangeListener listener);

    void removePropertyListener(PropertyChangeListener listener);

    void removeVetoableListener(String propertyName,
            VetoableChangeListener vetoable);

    void removeVetoableListener(VetoableChangeListener vetoable);

    /**
     * Parcourt de l'entité via un visiteur.
     * 
     * @param visitor visitor le visiteur utilise
     * @throws TopiaException pour toute erreur pendant le parcours
     */
    void accept(EntityVisitor visitor) throws TopiaException;
    
} //TopiaEntity
