/* *##% 
 * ToPIA :: Persistence
 * Copyright (C) 2004 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * ##%*/

/*{generator option: parentheses = true}*/
/*{generator option: writeString = output.write}*/

/* *
* EntityAbstractGenerator.java
*
* Created: 12 déc. 2005
*
* @author Arnaud Thimel <thimel@codelutin.com>
* @version $Revision: 1732 $
*
* Mise a jour: $Date: 2009-12-20 17:29:38 +0100 (dim. 20 déc. 2009) $
* par : $Author: tchemit $
*/

package org.nuiton.topia.generator;

import org.nuiton.eugene.models.object.*;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.TAG_ANNOTATION;
import static org.nuiton.topia.generator.TopiaGeneratorUtil.hasUnidirectionalRelationOnAbstractType;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.eugene.models.object.ObjectModelGenerator;
import org.nuiton.eugene.GeneratorUtil;

// do not remove me
import org.apache.commons.lang.StringUtils;
/**
 * Generateur d'entites abstraites. Il s'agit de l'implatation par defaut d'une
 * entite. Les classes generees sont surchargees par un XXXImpl lorsque l'entite
 * n'est pas abstraite. La surcharge peut etre ecrite par l'utilisateur.
 *
 * @deprecated since 2.3.0, prefer use the corresponding {@link org.nuiton.eugene.Transformer} :
 * {@link EntityDTOTransformer}.
 * @plexus.component role="org.nuiton.eugene.Template" role-hint="org.nuiton.topia.generator.EntityDTOGenerator" 
 */
@Deprecated
public class EntityDTOGenerator extends ObjectModelGenerator {

    /**
     * Logger for this class
     */
    private static final Log log = LogFactory.getLog(EntityDTOGenerator.class);

    @Override
    public String getFilenameForClass(ObjectModelClass clazz) {
        return clazz.getQualifiedName().replace('.', File.separatorChar) + "DTO.java";
    }

    public boolean isEntity(String type) {
        ObjectModelClassifier clazz = model.getClassifier(type);
        return clazz != null && clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY);
    }

    @Override
    public void generateFromClass(Writer output, ObjectModelClass clazz) throws IOException {
        if (!clazz.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY)) {
            return;
        }
        String copyright = TopiaGeneratorUtil.getCopyright(model);
        if (TopiaGeneratorUtil.notEmpty(copyright)) {
/*{<%=copyright%>
}*/
        }
        String clazzName = clazz.getName();
/*{package <%=clazz.getPackageName()%>;

import org.apache.commons.lang.builder.ToStringBuilder;
import java.beans.PropertyChangeListener;

/**
 * Implantation DTO pour l'entité <%=StringUtils.capitalize(clazzName)%>.
 *)
}*/
        String extendClass = "";
        for (Iterator<ObjectModelClass> i=clazz.getSuperclasses().iterator(); i.hasNext();) {
            ObjectModelClass parent = i.next();
            extendClass += parent.getQualifiedName() + "DTO";
            if (i.hasNext()) {
                extendClass += ", ";
            }
        }
        if (extendClass.length() > 0) {
        	extendClass = "extends " + extendClass + " ";
        }

/*{public class <%=clazzName%>DTO <%=extendClass%>implements java.io.Serializable {

}*/

        String svUID = TopiaGeneratorUtil.findTagValue("dto-serialVersionUID", clazz, model);
        if (svUID != null) {
/*{    public static final long serialVersionUID = <%=svUID%>;

}*/
        }
        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            
            // pour les asso quoi qu'il arrive il faut les lier des 2 cotes
            // pour pouvoir supprimer en cascade l'asso lors de la suppression
            // d'un des cotes
            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model)
                    || attr.hasAssociationClass())) {
                continue;
            }
            if (TopiaGeneratorUtil.hasDocumentation(attr)) {
/*{    /**
     * <%=attr.getDocumentation()%>
     *)
}*/
            }
            if (attr.hasTagValue(TAG_ANNOTATION)) {
            	String annotation = attr.getTagValue(TAG_ANNOTATION);
/*{    <%=annotation%>
}*/
            }

            String attrVisibility = attr.getVisibility();
            if (!attr.hasAssociationClass()) {
            	String attrType = attr.getType();
            	String attrName = attr.getName();
            	if (isEntity(attrType)) {
            		attrType += "DTO";
            	}
                if (!GeneratorUtil.isNMultiplicity(attr)) {
/*{    <%=attrVisibility%> <%=attrType%> <%=attrName%>;

}*/
                } else {
/*{    <%=attrVisibility%> <%=attrType%>[] <%=attrName%>;

}*/
                }
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
            	String assocClassFQN = attr.getAssociationClass().getQualifiedName();
                if (!GeneratorUtil.isNMultiplicity(attr)) {
/*{    <%=attrVisibility%> <%=assocClassFQN%>DTO <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;

}*/
                } else {
/*{    <%=attrVisibility%> <%=assocClassFQN%>DTO[] <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;

}*/
                }
            }
        }

        //Déclaration des attributs d'une classe d'associations
        if (clazz instanceof ObjectModelAssociationClass) {
            ObjectModelAssociationClass assoc = (ObjectModelAssociationClass)clazz;
            for (ObjectModelAttribute attr : assoc.getParticipantsAttributes()) {
                if (attr != null) {
                    String attrVisibility = attr.getVisibility();
                    String attrType = attr.getType();
                    String attrName = attr.getName();
                	if (isEntity(attrType)) {
                		attrType += "DTO";
                	}
/*{    <%=attrVisibility%> <%=attrType%> <%=GeneratorUtil.toLowerCaseFirstLetter(attrName)%>;

}*/
                }
            }
        }

/*{
     protected java.beans.PropertyChangeSupport p;

}*/
        
/*{    /**
     * Constructeur de <%=clazzName%>DTO par défaut.
     *)
    public <%=clazzName%>DTO() { p = new java.beans.PropertyChangeSupport(this); }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        p.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        p.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        p.removePropertyChangeListener(propertyName, listener);
    }

}*/

        for (ObjectModelAttribute attr : clazz.getAttributes()) {
            ObjectModelAttribute reverse = attr.getReverseAttribute();

            if (!(attr.isNavigable()
                    || hasUnidirectionalRelationOnAbstractType(reverse, model))) {
                continue;
            }
            String attrName = attr.getName();

            if (!attr.hasAssociationClass()) {
                String attrType = attr.getType();
                if (isEntity(attrType)) {
                	attrType += "DTO";
                }
            	if (!GeneratorUtil.isNMultiplicity(attr)) {
/*{    public void set<%=StringUtils.capitalize(attrName)%>(<%=attrType%> value) {
        <%=attrType%> oldValue = this.<%=attrName%>;
        this.<%=attrName%> = value;
        p.firePropertyChange("<%=attrName%>", oldValue, value);
    }

    public <%=attrType%> get<%=StringUtils.capitalize(attrName)%>() {
        return <%=attrName%>;
    }

}*/
            	} else {
/*{    public void set<%=StringUtils.capitalize(attrName)%>(<%=attrType%>[] values) {
       <%=attrType%>[] oldValues = this.<%=attrName%>;
        this.<%=attrName%> = values;
        p.firePropertyChange("<%=attrName%>", oldValues, values);
    }

    public <%=attrType%>[] get<%=StringUtils.capitalize(attrName)%>() {
        return this.<%=attrName%>;
    }

}*/
            	}
            } else {
                String assocAttrName = TopiaGeneratorUtil.getAssocAttrName(attr);
                String assocClassFQN = attr.getAssociationClass().getQualifiedName();
            	if (!GeneratorUtil.isNMultiplicity(attr)) {
/*{    public void set<%=StringUtils.capitalize(assocAttrName)%>(<%=assocClassFQN%>DTO association) {
        <%=assocClassFQN%>DTO oldAssocation= this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
        this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> = association;
        p.firePropertyChange("<%=attrName%>", oldAssocation, assocation);
    }

    public <%=assocClassFQN%>DTO get<%=StringUtils.capitalize(assocAttrName)%>() {
        return <%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
    }

}*/
            	} else {
/*{    public void set<%=StringUtils.capitalize(assocAttrName)%>(<%=assocClassFQN%>DTO[] values) {
        <%=assocClassFQN%>DTO[] oldValues = this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
        this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%> = values;
        p.firePropertyChange("<%=attrName%>", oldValues, values);
    }

    public <%=assocClassFQN%>DTO[] get<%=StringUtils.capitalize(assocAttrName)%>() {
        return this.<%=GeneratorUtil.toLowerCaseFirstLetter(assocAttrName)%>;
    }

}*/
            	}
            }

        }

/*{    
    @Override
    public String toString() {
        String result = new ToStringBuilder(this).
}*/
        for (Object o : clazz.getAttributes()) {
            ObjectModelAttribute attr = (ObjectModelAttribute) o;
            //FIXME possibilité de boucles (non directes)
            ObjectModelClass attrEntity = null;
            if (model.hasClass(attr.getType())) {
                attrEntity = model.getClass(attr.getType());
            }
            boolean isEntity = (attrEntity != null && attrEntity.hasStereotype(TopiaGeneratorUtil.STEREOTYPE_ENTITY));
            ObjectModelAttribute reverse = attr.getReverseAttribute();
            if ((isEntity && (reverse == null || !reverse.isNavigable()) && !attr.hasAssociationClass()) || (!isEntity)) {
            	String attrName = attr.getName();
/*{            append("<%=attrName%>", this.<%=attrName%>).
}*/
            }
        }
/*{         toString();   
        return result;
    }

} //<%=clazzName%>DTO
}*/
    }

    //TODO Check wether this method could be used to generate getter and setters
    protected void generateNormalGetterAndSetterWithPropertyChangeSupport(Writer output, String attrType, String attrName) throws IOException {
/*{    public void set<%=StringUtils.capitalize(attrName)%>(<%=attrType%> value) {
        <%=attrType%> _oldValue = this.<%=attrName%>;
        this.<%=attrName%> = value;
        p.firePropertyChange("<%=attrName%>", _oldValue, value);
    }

    public <%=attrType%> get<%=StringUtils.capitalize(attrName)%>() {
        return this.<%=attrName%>;
    }

}*/
    }

} //EntityDTOGenerator
