package org.nuiton.topiatest;

import java.util.Arrays;
import java.util.List;
import org.nuiton.topia.TopiaException;
import org.nuiton.topia.framework.TopiaContextImplementor;
import org.nuiton.topia.persistence.TopiaDAO;
import org.nuiton.topia.persistence.TopiaDAOImpl;


public abstract class AddressDAOAbstract<E extends Address> extends TopiaDAOImpl<E> implements TopiaDAO<E> {

    /**
     * getEntityClass :
     * @return Class<E> 
     */

    public Class<E> getEntityClass() {
        return (Class<E>)Address.class;
    }

    /**
     * delete :
     * @param entity 
     * @throws TopiaException
     */

    public void delete(E entity) throws TopiaException {
                {
                List<org.nuiton.topiatest.Personne> list = getContext()
                            .getDAO(org.nuiton.topiatest.Personne.class)
                            .findAllByProperties("address", entity);
                    for (org.nuiton.topiatest.Personne item : list) {
                        item.setAddress(null);

                    }
                }

        super.delete(entity);
    }

    /**
     * findByCity :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut city le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByCity(String v) throws TopiaException {
        E result = findByProperty(Address.CITY, v);
        return result;
    }

    /**
     * findAllByCity :
     * Retourne les éléments ayant comme valeur pour l'attribut city le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByCity(String v) throws TopiaException {
        List<E> result = findAllByProperty(Address.CITY, v);
        return result;
    }

    /**
     * findByAdress :
     * Retourne le premier élément trouvé ayant comme valeur pour l'attribut adress le paramètre.
     * @param v 
     * @return E 
     * @throws TopiaException
     */

    public E findByAdress(String v) throws TopiaException {
        E result = findByProperty(Address.ADRESS, v);
        return result;
    }

    /**
     * findAllByAdress :
     * Retourne les éléments ayant comme valeur pour l'attribut adress le paramètre.
     * @param v 
     * @return List<E> 
     * @throws TopiaException
     */

    public List<E> findAllByAdress(String v) throws TopiaException {
        List<E> result = findAllByProperty(Address.ADRESS, v);
        return result;
    }


} //AddressDAOAbstract<E extends Address>
