/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.spgeed.query;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.spgeed.query.PipeFunction;
import org.nuiton.spgeed.query.Query;
import org.postgresql.util.PGobject;

public class PipeFunctions {
    protected Map<String, PipeFunction> exposedFunction;

    public Map<String, PipeFunction> getExposedFunction() {
        if (this.exposedFunction == null) {
            HashMap<String, PipeFunction> result = new HashMap<String, PipeFunction>();
            result.put("toString", this::toString);
            result.put("toParam", this::toParam);
            result.put("json", this::json);
            result.put("array", this::array);
            result.put("values", this::values);
            result.put("map", this::map);
            result.put("row", this::row);
            result.put("collection", this::collection);
            result.put("cast", this::cast);
            result.put("raw", this::raw);
            this.exposedFunction = result;
        }
        return this.exposedFunction;
    }

    protected Object map(boolean forceCollection, Object value, MapFunction f) throws Exception {
        List<Object> result;
        if (value == null) {
            result = forceCollection ? Collections.EMPTY_LIST : null;
        } else if (value.getClass().isArray()) {
            ArrayList<Object> list = new ArrayList<Object>();
            result = list;
            for (Object o : (Object[])value) {
                list.add(f.map(o));
            }
        } else if (value instanceof Collection) {
            ArrayList<Object> list;
            result = list = new ArrayList<Object>();
            for (Object o : (Collection)value) {
                list.add(f.map(o));
            }
        } else {
            result = f.map(value);
            if (forceCollection) {
                result = Arrays.asList(result);
            }
        }
        return result;
    }

    protected boolean isRow(String fields) {
        String fieldPath = "\\p{Alpha}\\p{Alnum}*(?:\\[\\p{Digit}+\\])?(?:\\.\\p{Alpha}\\p{Alnum}*(?:\\[\\p{Digit}+\\])?)*(?:::\\p{Alpha}\\p{Alnum}*)?";
        boolean result = fields != null && fields.matches("^\\s*(" + fieldPath + ")\\s*(?:,\\s*(" + fieldPath + ")\\s*)+$");
        return result;
    }

    protected String[] getFieldType(String field, boolean appendDelim) {
        String[] result = new String[]{"", ""};
        if (StringUtils.isNotBlank((CharSequence)field)) {
            String[] split = field.split("::", 2);
            result[0] = split[0];
            if (split.length > 1) {
                if (appendDelim) {
                    result[1] = result[1] + "::";
                }
                result[1] = result[1] + split[1];
            }
        }
        return result;
    }

    public Object toParam(Query query, Object in, Object ... args) throws Exception {
        Object result;
        String fieldName = null;
        if (args != null) {
            if (args.length > 1) {
                throw new IllegalArgumentException("Only zero or one argument is allowed for toParam function. Invalide argument is: " + Arrays.toString(args));
            }
            if (args.length > 0) {
                fieldName = (String)args[0];
            }
        }
        if (this.isRow(fieldName)) {
            result = this.row(query, in, fieldName.split(","));
        } else {
            String[] fieldType = this.getFieldType(fieldName, true);
            Object value = query.evalField(in, fieldType[0]);
            result = value == null || value instanceof String || value instanceof Integer || value instanceof Float || value instanceof BigDecimal || value instanceof Boolean || value instanceof UUID || value instanceof Date || value instanceof Timestamp || value instanceof LocalDate || value instanceof LocalDateTime || value instanceof OffsetDateTime || value instanceof Double || value.getClass().getSimpleName().equals("byte[]") ? query.addSqlParameter(value) : (value.getClass().isEnum() ? query.addSqlParameter(value) : (value instanceof Collection || value.getClass().isArray() ? this.array(query, value, new Object[0]) : this.json(query, value, new Object[0])));
            result = result + fieldType[1];
        }
        return result;
    }

    public Object toString(Query query, Object in, Object ... args) {
        return String.valueOf(in);
    }

    public Object json(Query query, Object in, Object ... args) throws JsonProcessingException, SQLException {
        PGobject pg = new PGobject();
        pg.setType("JSON");
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new JavaTimeModule());
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CASE);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        String value = mapper.writeValueAsString(in);
        pg.setValue(value);
        String result = query.addSqlParameter(pg);
        return result;
    }

    public Object array(Query query, Object in, Object ... args) throws Exception {
        Collection c;
        if (in == null) {
            in = Collections.emptyList();
        }
        StringJoiner joiner = new StringJoiner(", ", "ARRAY[", "]");
        if (args != null && args.length > 0) {
            joiner.setEmptyValue("ARRAY[]::" + args[0] + "[]");
            c = (Collection)this.map(true, in, (Object o) -> this.cast(query, o, args));
        } else {
            c = (Collection)this.map(true, in, (Object o) -> this.toParam(query, o, new Object[0]));
        }
        c.forEach(v -> joiner.add((String)v));
        String result = joiner.toString();
        return result;
    }

    public Object collection(Query query, Object in, Object ... args) throws Exception {
        String result = "(";
        if (in != null) {
            Collection c = (Collection)this.map(true, in, (Object o) -> this.toParam(query, o, new Object[0]));
            result = result + String.join((CharSequence)", ", c);
        }
        result = result + ")";
        return result;
    }

    public Object row(Query query, Object in, Object ... args) throws Exception {
        String result = "ROW" + this.values(query, in, args);
        return result;
    }

    public Object values(Query query, Object in, Object ... args) throws Exception {
        MapFunction fn = o -> {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Object a : args) {
                String name;
                Object parameter = a instanceof String ? ((name = (String)a).isEmpty() ? this.toParam(query, o, new Object[0]) : this.toParam(query, o, name)) : this.toParam(query, a, new Object[0]);
                values.add(parameter);
            }
            return "(" + String.join((CharSequence)", ", values) + ")";
        };
        Object result = this.map(false, in, fn);
        if (result instanceof Collection) {
            result = String.join((CharSequence)", ", (Collection)result);
        }
        return result;
    }

    public Object map(Query query, Object in, Object ... args) throws Exception {
        if (args == null || args.length == 0) {
            return in;
        }
        Collection result = (Collection)this.map(true, in, (Object o) -> {
            if (args.length == 1) {
                return query.evalField(o, String.valueOf(args[0]));
            }
            HashMap<String, Object> values = new HashMap<String, Object>();
            for (Object a : args) {
                String name = String.valueOf(a);
                Object value = query.evalField(o, name);
                values.put(name, value);
            }
            return values;
        });
        return result;
    }

    public Object cast(Query query, Object in, Object ... args) throws Exception {
        Object tmp = this.map(false, in, (Object o) -> this.toParam(query, o, new Object[0]));
        Object result = tmp instanceof Collection ? ((Collection)Collection.class.cast(tmp)).stream().map(o -> o + "::" + args[0]).collect(Collectors.toList()) : tmp + "::" + args[0];
        return result;
    }

    public Object raw(Query query, Object in, Object ... args) throws Exception {
        return String.valueOf(in);
    }

    static interface MapFunction {
        public Object map(Object var1) throws Exception;
    }
}

