/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import javax.swing.ImageIcon;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ClassLoaderUtil;
import org.nuiton.util.HashList;
import org.nuiton.util.ResourceException;
import org.nuiton.util.ResourceNotFoundException;
import org.nuiton.util.StringUtil;

public class Resource {
    private static final Log log = LogFactory.getLog(Resource.class);

    protected Resource() {
    }

    public static void addDefaultClassLoader(URL url) {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        Resource.addClassLoader(classLoader, url);
    }

    public static void addClassLoader(ClassLoader classLoader, URL url) {
        try {
            Method method = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
            method.setAccessible(true);
            method.invoke((Object)classLoader, url);
        }
        catch (Exception eee) {
            throw new RuntimeException(I18n.t("nuitonutil.error.add.url.in.classloader", classLoader, eee));
        }
    }

    public static URL getURL(String name) {
        URL url = Resource.getURLOrNull(name);
        if (url != null) {
            return url;
        }
        throw new ResourceNotFoundException(I18n.t("nuitonutil.error.resource.not.found", name));
    }

    public static URL getURLOrNull(String name) {
        URL url;
        File file = new File(name);
        if (file.exists()) {
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException eee) {
                log.warn(I18n.t("nuitonutil.error.convert.file.to.url", file, eee.getMessage()));
            }
        }
        if (name.length() > 1 && name.startsWith("/")) {
            name = name.substring(1);
        }
        if ((url = ClassLoader.getSystemClassLoader().getResource(name)) != null) {
            return url;
        }
        ClassLoader cl = Resource.class.getClassLoader();
        url = cl.getResource(name);
        return url;
    }

    public static ImageIcon getIcon(String name) {
        try {
            return new ImageIcon(Resource.getURL(name));
        }
        catch (Exception eee) {
            log.warn("Can't find icon: " + name, eee);
            return null;
        }
    }

    public static List<URL> getURLs(String pattern) {
        return Resource.getURLs(pattern, (URLClassLoader)null);
    }

    public static List<URL> getURLs(String pattern, URLClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        }
        URL[] arrayURL = ClassLoaderUtil.getURLs(classLoader);
        return Resource.getURLs(pattern, arrayURL);
    }

    public static List<URL> getURLs(String pattern, URL ... arrayURL) {
        URL jarURL;
        long t0 = System.nanoTime();
        HashList<URL> urlList = new HashList<URL>();
        if (arrayURL.length == 1 && Resource.isJar((jarURL = arrayURL[0]).toString())) {
            try {
                arrayURL = Resource.getClassPathURLsFromJarManifest(jarURL);
            }
            catch (Exception e) {
                log.warn(e);
                arrayURL = new URL[]{jarURL};
            }
        }
        if (log.isDebugEnabled()) {
            for (URL url : arrayURL) {
                log.debug("found url " + url);
            }
        }
        for (URL urlFile : arrayURL) {
            File file = FileUtils.toFile(urlFile);
            String fileName = file.getAbsolutePath();
            if (!file.exists()) {
                if (!log.isDebugEnabled()) continue;
                log.debug("Can't find file " + file + " (" + fileName + ")");
                continue;
            }
            if (Resource.isJar(fileName)) {
                if (log.isDebugEnabled()) {
                    log.debug("jar to search " + file);
                }
                urlList.addAll(Resource.getURLsFromJar(file, pattern));
                continue;
            }
            if (file.isDirectory()) {
                if (log.isDebugEnabled()) {
                    log.debug("directory to search " + file);
                }
                urlList.addAll(Resource.getURLsFromDirectory(file, pattern));
                continue;
            }
            if (!Resource.isZip(fileName)) continue;
            if (log.isDebugEnabled()) {
                log.debug("zip to search " + file);
            }
            urlList.addAll(Resource.getURLsFromZip(file, pattern));
        }
        if (log.isInfoEnabled()) {
            log.info("search URLs pattern: " + pattern + " in " + arrayURL.length + " urls in " + StringUtil.convertTime(System.nanoTime() - t0));
        }
        return urlList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URL[] getClassPathURLsFromJarManifest(URL jarURL) throws IOException {
        URL[] result;
        File jarFile = FileUtils.toFile(jarURL);
        if (log.isDebugEnabled()) {
            log.debug("class-path jar to scan " + jarFile);
        }
        JarFile jar = new JarFile(jarFile);
        try {
            File container = jarFile.getParentFile();
            Manifest mf = jar.getManifest();
            String classPath = null;
            if (mf != null && mf.getMainAttributes() != null) {
                classPath = mf.getMainAttributes().getValue(Attributes.Name.CLASS_PATH);
            }
            String[] paths = classPath != null ? classPath.split(" ") : StringUtil.EMPTY_STRING_ARRAY;
            result = new URL[paths.length + 1];
            result[0] = jarURL;
            for (int i = 0; i < paths.length; ++i) {
                String s = paths[i];
                if (s.indexOf(58) != -1) {
                    result[i + 1] = new URL(s);
                    continue;
                }
                File path = s.startsWith(".") || !s.startsWith("/") ? new File(container, s) : new File(s);
                if (log.isDebugEnabled()) {
                    log.debug(path);
                }
                result[i + 1] = path.toURI().toURL();
            }
        }
        finally {
            if (jar != null) {
                jar.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URL> getURLsFromZip(File zipFile, String pattern) {
        try {
            if (log.isTraceEnabled()) {
                log.trace("search '" + pattern + "' in " + zipFile);
            }
            ArrayList<URL> result = new ArrayList<URL>();
            ZipInputStream zis = new ZipInputStream(new FileInputStream(zipFile));
            try {
                while (zis.available() != 0) {
                    ZipEntry entry = zis.getNextEntry();
                    if (entry == null) {
                        break;
                    }
                    String name = entry.getName();
                    if (log.isTraceEnabled()) {
                        log.trace("zipFile: " + zipFile + " name: " + name);
                    }
                    if (pattern != null && !name.matches(pattern)) continue;
                    URL url = Resource.getURL(name);
                    if (log.isTraceEnabled()) {
                        log.trace("zipFile: " + zipFile + " url: " + url);
                    }
                    result.add(url);
                }
            }
            finally {
                zis.close();
            }
            if (log.isTraceEnabled()) {
                log.trace("found with pattern '" + pattern + "' : " + result);
            }
            return result;
        }
        catch (IOException eee) {
            throw new ResourceException(I18n.t("nuitonutil.error.get.url.from.zip", zipFile.getAbsolutePath(), eee.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<URL> getURLsFromJar(File jarfile, String pattern) {
        try {
            if (log.isTraceEnabled()) {
                log.trace("search '" + pattern + "' in " + jarfile);
            }
            ArrayList<URL> result = new ArrayList<URL>();
            ZipInputStream zis = new ZipInputStream(new FileInputStream(jarfile));
            try {
                while (zis.available() != 0) {
                    ZipEntry entry = zis.getNextEntry();
                    if (entry == null) {
                        break;
                    }
                    String name = entry.getName();
                    if (log.isTraceEnabled()) {
                        log.trace("jarfile: " + jarfile + " name: " + name);
                    }
                    if (pattern != null && !name.matches(pattern)) continue;
                    URL url = Resource.getURL(name);
                    if (log.isTraceEnabled()) {
                        log.trace("jarfile: " + jarfile + " url: " + url);
                    }
                    result.add(url);
                }
            }
            finally {
                zis.close();
            }
            if (log.isTraceEnabled()) {
                log.trace("found with pattern '" + pattern + "' : " + result);
            }
            return result;
        }
        catch (IOException eee) {
            throw new ResourceException(I18n.t("nuitonutil.error.get.url.from.zip", jarfile.getAbsolutePath(), eee.getMessage()));
        }
    }

    public static List<URL> getURLsFromDirectory(File repository, String pattern) {
        try {
            if (log.isTraceEnabled()) {
                log.trace("search '" + pattern + "' in " + repository);
            }
            HashList<URL> urlList = new HashList<URL>();
            File[] filesList = repository.listFiles();
            if (filesList != null) {
                for (File file : filesList) {
                    String name = file.getAbsolutePath();
                    if (log.isTraceEnabled()) {
                        log.trace("directory: " + repository + " name: " + name);
                    }
                    if (file.exists() && file.isDirectory()) {
                        urlList.addAll(Resource.getURLsFromDirectory(file, pattern));
                        continue;
                    }
                    if (pattern != null && !name.matches(pattern)) continue;
                    URL url = file.toURI().toURL();
                    if (log.isTraceEnabled()) {
                        log.trace("directory: " + repository + " url: " + url);
                    }
                    urlList.add(url);
                }
            }
            if (log.isTraceEnabled()) {
                log.trace("found with pattern '" + pattern + "' : " + urlList);
            }
            return urlList;
        }
        catch (MalformedURLException eee) {
            throw new ResourceException(I18n.t("nuitonutil.error.convert.file.to.url", repository + " (pattern " + pattern + ") ", eee.getMessage()));
        }
    }

    public static boolean isJar(String name) {
        if (name != null && name.length() > 4) {
            String ext = name.substring(name.length() - 4, name.length());
            return ".jar".equalsIgnoreCase(ext);
        }
        return false;
    }

    public static boolean isZip(String name) {
        if (name != null && name.length() > 4) {
            String ext = name.substring(name.length() - 4, name.length());
            return ".zip".equalsIgnoreCase(ext);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containsDirectDirectory(URL url, String directory) throws IOException {
        File file = FileUtils.toFile(url);
        String fileName = file.getAbsolutePath();
        if (!file.exists()) {
            return false;
        }
        if (Resource.isJar(fileName) || Resource.isZip(fileName)) {
            if (log.isTraceEnabled()) {
                log.trace("zip to search " + file);
            }
            ZipFile zipFile = new ZipFile(file);
            try {
                boolean bl = zipFile.getEntry(directory + '/') != null;
                return bl;
            }
            finally {
                zipFile.close();
            }
        }
        if (file.isDirectory()) {
            if (log.isTraceEnabled()) {
                log.trace("directory to search " + file);
            }
            return new File(file, directory).exists();
        }
        if (log.isWarnEnabled()) {
            log.warn(I18n.t("nuitonutil.error.unknown.url.type", url));
        }
        return false;
    }

    protected static boolean isPattern(String str) {
        return str.indexOf(42) != -1 || str.indexOf(63) != -1;
    }

    public static List<URL> getResources(String pattern) throws IOException {
        return Resource.getResources(pattern, null);
    }

    public static List<URL> getResources(String pattern, ClassLoader classLoader) throws IOException {
        List<URL> urlList;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if (Resource.isPattern(pattern)) {
            urlList = Resource.getPatternRessources(pattern, classLoader);
        } else {
            urlList = new HashList<URL>();
            Enumeration<URL> resourceUrls = classLoader.getResources(pattern);
            while (resourceUrls.hasMoreElements()) {
                URL url = resourceUrls.nextElement();
                urlList.add(url);
            }
        }
        return urlList;
    }

    protected static List<URL> getPatternRessources(String pattern, ClassLoader classLoader) throws IOException {
        HashList<URL> urlList = new HashList<URL>();
        int prefixEnd = pattern.indexOf(":") + 1;
        int rootDirEnd = pattern.length();
        while (rootDirEnd > prefixEnd && Resource.isPattern(pattern.substring(prefixEnd, rootDirEnd))) {
            rootDirEnd = pattern.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        if (rootDirEnd == 0) {
            rootDirEnd = prefixEnd;
        }
        String rootDirPath = pattern.substring(0, rootDirEnd);
        String subPattern = pattern.substring(rootDirPath.length());
        Enumeration<URL> rootDirResources = classLoader.getResources(rootDirPath);
        while (rootDirResources.hasMoreElements()) {
            URL rootDirResource = rootDirResources.nextElement();
            if (Resource.isJarUrl(rootDirResource)) {
                if (log.isDebugEnabled()) {
                    log.debug("jar to search " + rootDirResource);
                }
                urlList.addAll(Resource.doFindPathMatchingJarResources(rootDirResource, subPattern));
                continue;
            }
            urlList.addAll(Resource.doFindMatchingFileSystemResources(rootDirResource, subPattern));
        }
        return urlList;
    }

    public static boolean isJarUrl(URL url) {
        String protocol = url.getProtocol();
        return "jar".equals(protocol) || "zip".equals(protocol) || "wsjar".equals(protocol);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<URL> doFindPathMatchingJarResources(URL rootDirResource, String subPattern) throws IOException {
        String rootEntryPath;
        String jarFileUrl;
        JarFile jarFile;
        URLConnection con = rootDirResource.openConnection();
        boolean newJarFile = false;
        if (con instanceof JarURLConnection) {
            JarURLConnection jarCon = (JarURLConnection)con;
            jarCon.setUseCaches(false);
            jarFile = jarCon.getJarFile();
            jarFileUrl = jarCon.getJarFileURL().toExternalForm();
            JarEntry jarEntry = jarCon.getJarEntry();
            rootEntryPath = jarEntry != null ? jarEntry.getName() : "";
        } else {
            String urlFile = rootDirResource.getFile();
            int separatorIndex = urlFile.indexOf("!/");
            if (separatorIndex != -1) {
                jarFileUrl = urlFile.substring(0, separatorIndex);
                rootEntryPath = urlFile.substring(separatorIndex + "!/".length());
                jarFile = jarFileUrl.startsWith("file:") ? new JarFile(jarFileUrl.substring("file:".length())) : new JarFile(jarFileUrl);
            } else {
                jarFile = new JarFile(urlFile);
                jarFileUrl = urlFile;
                rootEntryPath = "";
            }
            newJarFile = true;
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Looking for matching resources in jar file [" + jarFileUrl + "]");
            }
            if (!"".equals(rootEntryPath) && !rootEntryPath.endsWith("/")) {
                rootEntryPath = rootEntryPath + "/";
            }
            HashList<URL> result = new HashList<URL>(8);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String relativePath;
                JarEntry entry = entries.nextElement();
                String entryPath = entry.getName();
                if (!entryPath.startsWith(rootEntryPath) || !(relativePath = entryPath.substring(rootEntryPath.length())).matches(subPattern)) continue;
                URL entryURL = new URL(rootDirResource, relativePath);
                result.add(entryURL);
            }
            HashList<URL> hashList = result;
            return hashList;
        }
        finally {
            if (newJarFile) {
                jarFile.close();
            }
        }
    }

    protected static List<URL> doFindMatchingFileSystemResources(URL rootDirResource, String subPattern) throws IOException {
        File rootDir;
        try {
            rootDir = new File(rootDirResource.toURI().getSchemeSpecificPart());
            rootDir = rootDir.getAbsoluteFile();
        }
        catch (URISyntaxException ex) {
            return Collections.emptyList();
        }
        return Resource.retrieveMatchingFiles(rootDir, subPattern);
    }

    protected static List<URL> retrieveMatchingFiles(File rootDir, String pattern) throws IOException {
        if (!rootDir.exists()) {
            return Collections.emptyList();
        }
        if (!rootDir.isDirectory()) {
            return Collections.emptyList();
        }
        if (!rootDir.canRead()) {
            return Collections.emptyList();
        }
        String fullPattern = rootDir.getAbsolutePath().replace(File.separator, "/");
        if (!pattern.startsWith("/")) {
            fullPattern = fullPattern + "/";
        }
        fullPattern = fullPattern + pattern.replace(File.separator, "/");
        HashList<URL> result = new HashList<URL>(8);
        Resource.doRetrieveMatchingFiles(fullPattern, rootDir, result);
        return result;
    }

    protected static void doRetrieveMatchingFiles(String fullPattern, File dir, List<URL> result) throws IOException {
        File[] dirContents;
        if (log.isDebugEnabled()) {
            log.debug("Searching directory [" + dir.getAbsolutePath() + "] for files matching pattern [" + fullPattern + "]");
        }
        if ((dirContents = dir.listFiles()) == null) {
            if (log.isWarnEnabled()) {
                log.warn("Could not retrieve contents of directory [" + dir.getAbsolutePath() + "]");
            }
            return;
        }
        for (File content : dirContents) {
            String currPath = content.getAbsolutePath().replace(File.separator, "/");
            if (content.isDirectory() && (currPath + "/").matches(fullPattern + ".*")) {
                if (!content.canRead()) {
                    if (log.isDebugEnabled()) {
                        log.debug("Skipping subdirectory [" + dir.getAbsolutePath() + "] because the application is not allowed to read the directory");
                    }
                } else {
                    Resource.doRetrieveMatchingFiles(fullPattern, content, result);
                }
            }
            if (!currPath.matches(fullPattern)) continue;
            result.add(content.toURI().toURL());
        }
    }
}

