/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.primitives;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.collections.primitives.RandomAccessShortList;
import org.apache.commons.collections.primitives.ShortCollection;
import org.apache.commons.collections.primitives.ShortList;

public class ArrayUnsignedByteList
extends RandomAccessShortList
implements ShortList,
Serializable {
    private transient byte[] _data = null;
    private int _size = 0;
    public static final short MAX_VALUE = 255;
    public static final short MIN_VALUE = 0;

    public ArrayUnsignedByteList() {
        this(8);
    }

    public ArrayUnsignedByteList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("capacity " + initialCapacity);
        }
        this._data = new byte[initialCapacity];
        this._size = 0;
    }

    public ArrayUnsignedByteList(ShortCollection that) {
        this(that.size());
        this.addAll(that);
    }

    public short get(int index) {
        this.checkRange(index);
        return this.toShort(this._data[index]);
    }

    public int size() {
        return this._size;
    }

    public short removeElementAt(int index) {
        this.checkRange(index);
        this.incrModCount();
        short oldval = this.toShort(this._data[index]);
        int numtomove = this._size - index - 1;
        if (numtomove > 0) {
            System.arraycopy(this._data, index + 1, this._data, index, numtomove);
        }
        --this._size;
        return oldval;
    }

    public short set(int index, short element) {
        this.assertValidUnsignedByte(element);
        this.checkRange(index);
        this.incrModCount();
        short oldval = this.toShort(this._data[index]);
        this._data[index] = this.fromShort(element);
        return oldval;
    }

    public void add(int index, short element) {
        this.assertValidUnsignedByte(element);
        this.checkRangeIncludingEndpoint(index);
        this.incrModCount();
        this.ensureCapacity(this._size + 1);
        int numtomove = this._size - index;
        System.arraycopy(this._data, index, this._data, index + 1, numtomove);
        this._data[index] = this.fromShort(element);
        ++this._size;
    }

    public void ensureCapacity(int mincap) {
        this.incrModCount();
        if (mincap > this._data.length) {
            int newcap = this._data.length * 3 / 2 + 1;
            byte[] olddata = this._data;
            this._data = new byte[newcap < mincap ? mincap : newcap];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    public void trimToSize() {
        this.incrModCount();
        if (this._size < this._data.length) {
            byte[] olddata = this._data;
            this._data = new byte[this._size];
            System.arraycopy(olddata, 0, this._data, 0, this._size);
        }
    }

    private final short toShort(byte value) {
        return (short)((short)value & 0xFF);
    }

    private final byte fromShort(short value) {
        return (byte)(value & 0xFF);
    }

    private final void assertValidUnsignedByte(short value) throws IllegalArgumentException {
        if (value > 255) {
            throw new IllegalArgumentException(value + " > " + 255);
        }
        if (value < 0) {
            throw new IllegalArgumentException(value + " < " + 0);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this._data.length);
        for (int i = 0; i < this._size; ++i) {
            out.writeByte(this._data[i]);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this._data = new byte[in.readInt()];
        for (int i = 0; i < this._size; ++i) {
            this._data[i] = in.readByte();
        }
    }

    private final void checkRange(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and less than " + this._size + ", found " + index);
        }
    }

    private final void checkRangeIncludingEndpoint(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Should be at least 0 and at most " + this._size + ", found " + index);
        }
    }
}

