/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class MD5InputStream
extends DigestInputStream {
    private static final Log log = LogFactory.getLog(MD5InputStream.class);
    protected long streamLength;

    protected static MessageDigest getMD5Digest() throws IllegalStateException {
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)I18n.t((String)"nuitonutil.error.could.not.find.MD5", (Object[])new Object[0]), (Throwable)e);
            }
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hash(InputStream input) throws IOException {
        MD5InputStream in = new MD5InputStream(input);
        try {
            byte[] result;
            while (in.read() != -1) {
            }
            byte[] byArray = result = in.hash();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static byte[] hash(File input) throws IOException {
        byte[] result;
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(input));
        try {
            result = MD5InputStream.hash(inputStream);
        }
        finally {
            ((InputStream)inputStream).close();
        }
        return result;
    }

    public static byte[] hash(String input) throws IOException {
        byte[] result = MD5InputStream.hash(new ByteArrayInputStream(input.getBytes()));
        return result;
    }

    public MD5InputStream(InputStream in) {
        super(in, MD5InputStream.getMD5Digest());
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c == -1) {
            return -1;
        }
        ++this.streamLength;
        return c;
    }

    @Override
    public int read(byte[] bytes, int offset, int length) throws IOException {
        int r = super.read(bytes, offset, length);
        if (r == -1) {
            return r;
        }
        this.streamLength += (long)r;
        return r;
    }

    public byte[] hash() {
        return this.getMessageDigest().digest();
    }

    public long getStreamLength() {
        return this.streamLength;
    }
}

