/*
 * #%L
 * 
 * 
 * $Id: MatrixRenderer.java 346 2011-04-07 12:26:45Z echatellier $
 * $HeadURL: https://svn.nuiton.org/nuiton-matrix/tags/nuiton-matrix-2.5/nuiton-matrix-gui/src/main/java/org/nuiton/math/matrix/viewer/MatrixRenderer.java $
 * %%
 * Copyright (C) 2010 - 2011 Codelutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */

package org.nuiton.math.matrix.viewer;

import java.awt.Component;

import javax.swing.Icon;

import org.nuiton.math.matrix.MatrixND;

/**
 * Matrix renderer plugin interface.
 * 
 * @author chatellier
 * @version $Revision: 346 $
 * 
 * Last update : $Date: 2011-04-07 14:26:45 +0200 (Thu, 07 Apr 2011) $
 * By : $Author: echatellier $
 */
public interface MatrixRenderer {

    /**
     * Renderer component for matrix.
     * 
     * @param matrix matrix to display (can be null with default rendering support)
     * @return component
     * @see MatrixViewerPanel#addMatrixRenderer(MatrixRenderer, boolean)
     */
    Component getComponent(MatrixND matrix);

    /**
     * Renderer icon (used in {@link MatrixRendererSolution#ICON} rendering).
     * 
     * @return plugin icon
     */
    Icon getIcon();

    /**
     * Renderer name (used in {@link MatrixRendererSolution#RADIO_BUTTON} rendering).
     * 
     * @return plugin name
     */
    String getName();
}
