/*
 * #%L
 * 
 * 
 * $Id: MatrixInfoTableModel.java 297 2010-12-08 14:10:03Z echatellier $
 * $HeadURL: http://svn.nuiton.org/svn/nuiton-matrix/tags/matrix-2.1/nuiton-matrix-gui/src/main/java/org/nuiton/math/matrix/viewer/renderer/MatrixInfoTableModel.java $
 * %%
 * Copyright (C) 2002 - 2010 CodeLutin, Chatellier Eric
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.math.matrix.viewer.renderer;

import org.nuiton.math.matrix.MatrixND;
import org.nuiton.math.matrix.MatrixException;
import javax.swing.table.AbstractTableModel;

/**
 * Matrix info table model.
 * 
 * @author chatellier
 * @version $Revision: 297 $
 * 
 * Last update : $Date: 2010-12-08 15:10:03 +0100 (mer., 08 déc. 2010) $
 * By : $Author: echatellier $
 */
public class MatrixInfoTableModel extends AbstractTableModel {

    /** serialVersionUID. */
    private static final long serialVersionUID = 2632133167225155487L;

    protected MatrixND matrix;

    public MatrixInfoTableModel(MatrixND mat) {
        if (mat.getDimCount() > 2) {
            throw new MatrixException(
                    "matrice with more than 2 dimension not supported.");
        }
        this.matrix = mat;
    }

    /**
     * @return Le nombre de lignes de la table.
     */
    public int getRowCount() {
        if (matrix == null || matrix.getDimCount() < 1) {
            return 0;
        } else {
            return matrix.getDim(0);
        }
    }

    /**
     * @return Le nombre de colonnes de la table.
     */
    public int getColumnCount() {
        if (matrix == null || matrix.getDimCount() < 1) {
            return 0;
        } else {
            return matrix.getDim(1) + 1;
        }
    }

    /**
     * @param row La ligne
     * @param column La colonnes
     * @return L'Object correspondant dans la matrice.
     */
    public Object getValueAt(int row, int column) {
        if (column == 0) {
            Object obj = matrix.getSemantic(0).get(row);
            return obj;
        } else {
            if (matrix.getDimCount() == 1) {
                return String.valueOf(matrix.getValue(column - 1));
            } else {
                return String.valueOf(matrix.getValue(row, column - 1));
            }
        }
    }

    public String getColumnName(int column) {
        if (column == 0) {
            return matrix.getDimensionName(0) + "\\"
                    + matrix.getDimensionName(1);
        } else {
            return "" + matrix.getSemantic(1).get(column - 1);
        }
    }

}// MatrixInfoTableModel
