/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.js.wro;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.nuiton.js.wro.ProtectedXmlModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import ro.isdc.wro.model.group.RecursiveGroupDefinitionException;
import ro.isdc.wro.model.resource.locator.ClasspathUriLocator;
import ro.isdc.wro.model.resource.locator.UriLocator;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardExpanderHandlerAware;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardStreamLocator;
import ro.isdc.wro.model.resource.locator.wildcard.WildcardUriLocatorSupport;
import ro.isdc.wro.model.transformer.WildcardExpanderModelTransformer;
import ro.isdc.wro.util.Function;

public class ImportWildcardXmlModelFactory
extends ProtectedXmlModelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ImportWildcardXmlModelFactory.class);

    @Override
    protected void processImports(Document document) {
        NodeList importsList = document.getElementsByTagName("import");
        LOG.debug("number of imports: {}", (Object)importsList.getLength());
        for (int i = 0; i < importsList.getLength(); ++i) {
            Element element = (Element)importsList.item(i);
            String name = element.getTextContent();
            LOG.debug("processing import: {}", (Object)name);
            Validate.notNull((Object)this.locatorFactory, (String)"The Locator cannot be null!", (Object[])new Object[0]);
            List<String> imports = this.findAll(name);
            for (String importName : imports) {
                if (this.processedImports.contains(importName)) {
                    String message = "Recursive import detected: " + importName;
                    LOG.error(message);
                    throw new RecursiveGroupDefinitionException(message);
                }
                this.processedImports.add(importName);
                this.model.merge(this.createImportedModel(importName));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> findAll(String uri) {
        List<String> result = new ArrayList<String>();
        UriLocator uriLocator = this.locatorFactory.getInstance(uri);
        if (uriLocator instanceof WildcardUriLocatorSupport) {
            WildcardStreamLocator wildcardStreamLocator = ((WildcardUriLocatorSupport)uriLocator).getWildcardStreamLocator();
            if (wildcardStreamLocator.hasWildcard(uri) && wildcardStreamLocator instanceof WildcardExpanderHandlerAware) {
                LOG.debug("Expanding import: {}", (Object)uri);
                if (StringUtils.startsWith((CharSequence)uri, (CharSequence)ClasspathUriLocator.PREFIX)) {
                    String fullPath = StringUtils.substringAfter((String)uri, (String)ClasspathUriLocator.PREFIX);
                    String beginPath = FilenameUtils.getFullPathNoEndSeparator((String)fullPath);
                    try {
                        Enumeration<URL> jars = Thread.currentThread().getContextClassLoader().getResources(beginPath);
                        while (jars.hasMoreElements()) {
                            URL url = jars.nextElement();
                            List<String> files = this.listAcceptableFile(fullPath, url);
                            result.addAll(files);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        LOG.warn("[FAIL] problem while trying to expand wildcard for the following resource uri: {}", (Object)uri);
                    }
                } else {
                    WildcardExpanderHandlerAware expandedHandler = (WildcardExpanderHandlerAware)wildcardStreamLocator;
                    String baseNameFolder = this.computeBaseNameFolder(uri, uriLocator, expandedHandler);
                    LOG.debug("baseNameFolder: {}", (Object)baseNameFolder);
                    ThreadLocal<List<String>> resultLocal = new ThreadLocal<List<String>>();
                    expandedHandler.setWildcardExpanderHandler(this.createExpanderHandler(uri, baseNameFolder, resultLocal));
                    try {
                        uriLocator.locate(uri);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        LOG.warn("[FAIL] problem while trying to expand wildcard for the following resource uri: {}", (Object)uri);
                    }
                    finally {
                        expandedHandler.setWildcardExpanderHandler(null);
                    }
                    result = resultLocal.get();
                }
            } else {
                result.add(uri);
            }
        } else {
            result.add(uri);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<String> listAcceptableFile(String pattern, URL url) throws IOException {
        String classPath = FilenameUtils.getPath((String)pattern);
        String jarPath = StringUtils.substringBefore((String)url.getPath(), (String)"!");
        if (jarPath.startsWith("file:")) {
            jarPath = StringUtils.substringAfter((String)jarPath, (String)"file:");
        }
        File jarFile = new File(jarPath);
        ArrayList<String> allFiles = new ArrayList<String>();
        if (jarFile.isDirectory()) {
            String filePattern = FilenameUtils.getName((String)pattern);
            Collection files = FileUtils.listFiles((File)jarFile, (IOFileFilter)new WildcardFileFilter(filePattern), (IOFileFilter)TrueFileFilter.INSTANCE);
            for (File f : files) {
                allFiles.add(f.toURI().toURL().toString());
            }
        } else if (FilenameUtils.isExtension((String)jarPath, (String[])new String[]{"jar", "zip", "war"})) {
            String prefix = "jar:" + StringUtils.substringBefore((String)url.getPath(), (String)"!") + "!/";
            JarFile file = null;
            try {
                file = new JarFile(jarPath);
                ArrayList<JarEntry> jarEntryList = Collections.list(file.entries());
                for (JarEntry entry : jarEntryList) {
                    String entryName = entry.getName();
                    boolean isSupportedEntry = entryName.startsWith(classPath) && !entryName.equals(classPath) && FilenameUtils.wildcardMatch((String)entryName, (String)pattern);
                    if (!isSupportedEntry) continue;
                    String u = prefix + entryName;
                    allFiles.add(u);
                    LOG.debug("\tfound jar entry: {}", (Object)entryName);
                }
            }
            finally {
                if (file != null) {
                    file.close();
                }
            }
        } else {
            LOG.warn("Not supported import type {}", (Object)jarPath);
        }
        return allFiles;
    }

    private String computeBaseNameFolder(String uri, UriLocator uriLocator, WildcardExpanderHandlerAware expandedHandler) {
        LOG.debug("computeBaseNameFolder for import {}", (Object)uri);
        String resourcePath = FilenameUtils.getFullPath((String)uri) + "**";
        LOG.debug("resourcePath: {}", (Object)resourcePath);
        ThreadLocal<String> baseNameFolderHolder = new ThreadLocal<String>();
        expandedHandler.setWildcardExpanderHandler(this.createBaseNameComputerFunction(baseNameFolderHolder));
        try {
            uriLocator.locate(resourcePath);
        }
        catch (Exception e) {
            LOG.debug("[FAIL] Exception caught during wildcard expanding for resource: {}\n with exception message {}", (Object)resourcePath, (Object)e.getMessage());
        }
        if (baseNameFolderHolder.get() == null) {
            LOG.debug("[FAIL] Cannot compute baseName folder for resource: {}", (Object)uri);
        }
        return baseNameFolderHolder.get();
    }

    private Function<Collection<File>, Void> createBaseNameComputerFunction(final ThreadLocal<String> baseNameFolderHolder) {
        return new Function<Collection<File>, Void>(){

            public Void apply(Collection<File> input) throws Exception {
                LOG.debug("\texpanded Files: {}", input);
                Iterator<File> i$ = input.iterator();
                if (i$.hasNext()) {
                    File file = i$.next();
                    LOG.debug("\tsetting baseNameFolder: {}", (Object)file.getParent());
                    baseNameFolderHolder.set(file.getParent());
                }
                throw new WildcardExpanderModelTransformer.NoMoreAttemptsIOException("BaseNameFolder computed successfully, skip further wildcard processing..");
            }
        };
    }

    public Function<Collection<File>, Void> createExpanderHandler(final String uri, final String baseNameFolder, final ThreadLocal<List<String>> resultLocal) {
        LOG.debug("createExpanderHandler using baseNameFolder: {}\n for import {}", (Object)baseNameFolder, (Object)uri);
        Function<Collection<File>, Void> handler = new Function<Collection<File>, Void>(){

            public Void apply(Collection<File> files) {
                if (baseNameFolder == null) {
                    LOG.warn("The import {} is probably invalid, removing it from the import.", (Object)uri);
                    resultLocal.set(new ArrayList());
                } else {
                    ArrayList<String> expandedImports = new ArrayList<String>();
                    LOG.debug("baseNameFolder: {}", (Object)baseNameFolder);
                    for (File file : files) {
                        String importPath = this.getFullPathNoEndSeparator(uri);
                        LOG.debug("\tresourcePath: {}", (Object)importPath);
                        LOG.debug("\tfile path: {}", (Object)file.getPath());
                        String computedImportUri = importPath + StringUtils.removeStart((String)file.getPath(), (String)baseNameFolder).replace('\\', '/');
                        LOG.debug("\texpanded resource: {}", (Object)computedImportUri);
                        expandedImports.add(computedImportUri);
                    }
                    LOG.debug("\treplace resource {}", (Object)uri);
                    resultLocal.set(expandedImports);
                }
                return null;
            }

            private String getFullPathNoEndSeparator(String uri2) {
                String result = FilenameUtils.getFullPathNoEndSeparator((String)uri2);
                if (result != null && 1 == result.length() && 0 == FilenameUtils.indexOfLastSeparator((String)result)) {
                    return "";
                }
                return result;
            }
        };
        return handler;
    }
}

