/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.js.wro;

import java.util.List;
import org.apache.commons.lang3.Validate;
import org.nuiton.js.wro.ImportWildcardXmlModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import ro.isdc.wro.WroRuntimeException;
import ro.isdc.wro.model.WroModel;
import ro.isdc.wro.model.WroModelInspector;
import ro.isdc.wro.model.group.Group;

public class NuitonJsXmlModelFactory
extends ImportWildcardXmlModelFactory {
    private static final Logger LOG = LoggerFactory.getLogger(NuitonJsXmlModelFactory.class);

    protected String getNuitonJsPatternXmlFile() {
        return "classpath:META-INF/nuiton-js/wro-*.xml";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized WroModel create() {
        this.model = new WroModel();
        String pattern = this.getNuitonJsPatternXmlFile();
        List<String> imports = this.findAll(pattern);
        for (String importName : imports) {
            if (this.processedImports.contains(importName)) {
                String message = "Import already done: " + importName;
                LOG.warn(message);
                continue;
            }
            this.processedImports.add(importName);
            this.merge(this.model, this.createImportedModel(importName));
        }
        try {
            try {
                Document document = this.createDocument();
                this.processGroups(document);
                this.processImports(document);
                this.parseGroups();
            }
            finally {
                this.processedImports.clear();
            }
        }
        catch (WroRuntimeException eee) {
            LOG.warn("No user wro.xml file found, use only nuiton-js declaration");
        }
        return this.model;
    }

    protected void merge(WroModel master, WroModel importedModel) {
        Validate.notNull((Object)importedModel, (String)"imported model cannot be null!", (Object[])new Object[0]);
        LOG.debug("merging importedModel: {}", (Object)importedModel);
        for (String groupName : new WroModelInspector(importedModel).getGroupNames()) {
            if (new WroModelInspector(master).getGroupNames().contains(groupName)) continue;
            Group importedGroup = new WroModelInspector(importedModel).getGroupByName(groupName);
            master.addGroup(importedGroup);
        }
    }
}

