/*
 * #%L
 * JRedmine :: Client
 * 
 * $Id$
 * $HeadURL$
 * %%
 * Copyright (C) 2009 - 2012 Tony Chemit, CodeLutin
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as 
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 * 
 * You should have received a copy of the GNU General Lesser Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>.
 * #L%
 */
package org.nuiton.jredmine.model.io.xpp3;

import org.nuiton.jredmine.model.Issue;
import org.nuiton.jredmine.model.IssueStatus;
import org.nuiton.jredmine.model.io.xpp3.api.AbstractXpp3Reader;

import java.beans.IntrospectionException;

/**
 * {@link Issue} reader.
 *
 * @author tchemit <chemit@codelutin.com>
 * @since 1.0.0
 */
public class IssueStatusXpp3Reader extends AbstractXpp3Reader<IssueStatus> {

    public IssueStatusXpp3Reader() {
        super(IssueStatus.class, "issue-statuses", "issue-status");
    }

    @Override
    protected void initMappers() throws IntrospectionException {

        addTagTextContentMappers(RedmineDataConverter.Integer, true,
                                 "id",
                                 "position",
                                 "default-done-ratio");

        addTagTextContentMappers(RedmineDataConverter.Boolean, true,
                                 "is-closed",
                                 "is-default");

        addTagTextContentMappers(RedmineDataConverter.Text, true,
                                 "name");
    }
}
