/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.jpa.junit;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.nuiton.jpa.hibernate.HibernateUtil;

public class JpaEntityManagerRule
implements TestRule {
    private static final Log log = LogFactory.getLog(JpaEntityManagerRule.class);
    protected String persistenceUnitName;
    protected static String timestamp = String.valueOf(new Date().getTime());
    protected boolean open = false;
    protected Map<String, String> jpaParameters;
    protected EntityManagerFactory entityManagerFactory;
    protected List<EntityManager> openedEntityManagers = new LinkedList<EntityManager>();

    public JpaEntityManagerRule(String persistenceUnitName, Map<String, String> jpaParameters) {
        this.persistenceUnitName = persistenceUnitName;
        this.jpaParameters = jpaParameters;
    }

    public Statement apply(final Statement base, Description description) {
        final String testClassName = description.getClassName();
        final String testMethodName = description.getMethodName();
        if (log.isDebugEnabled()) {
            log.debug((Object)("will create entityManager for test class " + testClassName + " and method " + testMethodName));
        }
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                JpaEntityManagerRule.this.createEntityManagerFactory(testClassName, testMethodName);
                try {
                    base.evaluate();
                }
                finally {
                    JpaEntityManagerRule.this.closeEntityManager();
                }
            }
        };
    }

    protected void createEntityManagerFactory(String testClassName, String testMethodName) {
        String context = testClassName + '_' + testMethodName + '_' + timestamp;
        this.entityManagerFactory = HibernateUtil.createTempEntityManagerFactory((String)this.persistenceUnitName, (String)context, this.jpaParameters);
        if (log.isDebugEnabled()) {
            log.debug((Object)("created entityManagerFactory " + this.entityManagerFactory));
        }
        this.open = true;
    }

    public EntityManager getEntityManager() {
        if (this.openedEntityManagers.isEmpty()) {
            this.openedEntityManagers.add(this.newEntityManager());
        }
        return this.openedEntityManagers.get(0);
    }

    public EntityManager newEntityManager() {
        if (!this.open) {
            throw new IllegalStateException("entity manager is not yet opened");
        }
        EntityManager entityManager = this.entityManagerFactory.createEntityManager();
        this.openedEntityManagers.add(entityManager);
        return entityManager;
    }

    protected void closeEntityManager() {
        this.open = false;
        for (EntityManager openedEntityManager : this.openedEntityManagers) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("close entityManager " + openedEntityManager));
            }
            openedEntityManager.close();
        }
    }
}

