/*
 * Decompiled with CFR 0.152.
 */
package jaxx.runtime.swing.navigation;

import java.util.Collection;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import jaxx.runtime.JAXXAction;
import jaxx.runtime.JAXXObject;
import jaxx.runtime.context.JAXXContextEntryDef;
import jaxx.runtime.decorator.Decorator;
import jaxx.runtime.swing.navigation.NavigationModelBuilder;
import jaxx.runtime.swing.navigation.NavigationTreeModelBuilder;
import jaxx.runtime.swing.navigation.NavigationTreeNode;
import jaxx.runtime.swing.navigation.NavigationTreeNodeRendererDecoratorImpl;
import jaxx.runtime.swing.navigation.NavigationTreeNodeRendererI18nImpl;
import jaxx.runtime.swing.navigation.NavigationTreeTableModel;
import jaxx.runtime.swing.navigation.NavigationTreeTableNode;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class NavigationTreeTableModelBuilder
implements NavigationModelBuilder {
    private static final Log log = LogFactory.getLog(NavigationTreeModelBuilder.class);
    protected NavigationTreeTableModel model;
    protected Class<? extends JAXXObject> defaultUIClass;
    protected Class<? extends JAXXAction> defaultUIHandlerClass;

    public NavigationTreeTableModelBuilder(Class<? extends JAXXObject> defaultUIClass, Class<? extends JAXXAction> defaultUIHandlerClass, NavigationTreeTableModel model) {
        this.defaultUIClass = defaultUIClass;
        this.defaultUIHandlerClass = defaultUIHandlerClass;
        this.model = model;
    }

    @Override
    public NavigationTreeTableModel getModel() {
        return this.model;
    }

    @Override
    public NavigationTreeNode buildEmptyRoot(JAXXContextEntryDef<?> entryDef, String contextName) {
        NavigationTreeTableNode node = this.createNavigationTreeTableNode(this.model.pathSeparator, contextName, entryDef, null);
        this.addI18nNodeRenderer(node, "");
        return this.addChildNode(null, node);
    }

    @Override
    public NavigationTreeNode build(NavigationTreeNode parentNode, String libelle, JAXXContextEntryDef<?> entryDef, String entryPath, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass) {
        NavigationTreeTableNode node = this.createNavigationTreeTableNode(this.model.pathSeparator, contextName, entryDef, entryPath);
        this.addI18nNodeRenderer(node, libelle);
        this.addNodeJaxxClasses(node, uiClass, actionClass);
        return this.addChildNode(parentNode, node);
    }

    @Override
    public NavigationTreeNode build(NavigationTreeNode parentNode, String libelle, JAXXContextEntryDef<?> entryDef, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass) {
        NavigationTreeTableNode node = this.createNavigationTreeTableNode(this.model.pathSeparator, contextName, entryDef, null);
        this.addI18nNodeRenderer(node, libelle);
        this.addNodeJaxxClasses(node, uiClass, actionClass);
        return this.addChildNode(parentNode, node);
    }

    @Override
    public NavigationTreeNode build(NavigationTreeNode parentNode, String libelle, String entryPath, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass) {
        NavigationTreeTableNode node = this.createNavigationTreeTableNode(this.model.pathSeparator, contextName, null, entryPath);
        this.addI18nNodeRenderer(node, libelle);
        this.addNodeJaxxClasses(node, uiClass, actionClass);
        return this.addChildNode(parentNode, node);
    }

    @Override
    public NavigationTreeNode build(NavigationTreeNode parentNode, Decorator<?> decorator, JAXXContextEntryDef<?> entryDef, String entryPath, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass) {
        NavigationTreeTableNode node = this.createNavigationTreeTableNode(this.model.pathSeparator, contextName, entryDef, entryPath);
        this.addDecoratorNodeRenderer(node, decorator);
        this.addNodeJaxxClasses(node, uiClass, actionClass);
        return this.addChildNode(parentNode, node);
    }

    @Override
    public NavigationTreeNode build(NavigationTreeNode parentNode, Decorator<?> decorator, JAXXContextEntryDef<?> entryDef, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass) {
        NavigationTreeTableNode node = this.createNavigationTreeTableNode(this.model.pathSeparator, contextName, entryDef, null);
        this.addDecoratorNodeRenderer(node, decorator);
        this.addNodeJaxxClasses(node, uiClass, actionClass);
        return this.addChildNode(parentNode, node);
    }

    @Override
    public NavigationTreeNode build(NavigationTreeNode parentNode, Decorator<?> decorator, String entryPath, String contextName, Class<? extends JAXXObject> uiClass, Class<? extends JAXXAction> actionClass) {
        NavigationTreeTableNode node = this.createNavigationTreeTableNode(this.model.pathSeparator, contextName, null, entryPath);
        this.addDecoratorNodeRenderer(node, decorator);
        this.addNodeJaxxClasses(node, uiClass, actionClass);
        return this.addChildNode(parentNode, node);
    }

    protected NavigationTreeNode addChildNode(NavigationTreeNode parentNode, NavigationTreeTableNode node) {
        if (node.getUIClass() == null) {
            node.setUIClass(this.defaultUIClass);
        }
        if (node.getUIHandlerClass() == null) {
            node.setUIHandlerClass(this.defaultUIHandlerClass);
        }
        if (parentNode == null) {
            this.model.setRoot(node);
        } else {
            parentNode.add(node);
        }
        this.model.nodeStructureChanged(node);
        return node;
    }

    @Override
    public NavigationTreeNode removeChildNode(NavigationTreeNode node) {
        NavigationTreeNode parentNode = node.getParent();
        this.model.removeNodeFromParent(node);
        return parentNode;
    }

    @Override
    public void addI18nNodeRenderer(NavigationTreeNode node, String libelle) {
        node.setRenderer(new NavigationTreeNodeRendererI18nImpl(libelle));
    }

    @Override
    public void addDecoratorNodeRenderer(NavigationTreeNode node, Decorator<?> decorator) {
        node.setRenderer(new NavigationTreeNodeRendererDecoratorImpl(decorator));
    }

    @Override
    public void addNodeJaxxClasses(NavigationTreeNode node, Class<? extends JAXXObject> uIClass, Class<? extends JAXXAction> uIHandlerClass) {
        node.setUIClass(uIClass);
        node.setUIHandlerClass(uIHandlerClass);
    }

    @Override
    public void printModel(NavigationTreeNode node) {
        if (node == null) {
            return;
        }
        log.info((Object)("node " + node.getFullPath() + ", jxpath: " + node.getJaxxContextEntryPath() + ", entryContextDef: " + node.getJaxxContextEntryDef()));
        if (log.isDebugEnabled()) {
            log.debug((Object)("node userObject" + node.getUserObject()));
            log.debug((Object)("value from node " + node.getBean(this.getModel().getContext())));
            log.debug((Object)("value from model " + this.getModel().getBean(node)));
        }
        Enumeration<TreeNode> children = node.children();
        while (children.hasMoreElements()) {
            this.printModel((NavigationTreeNode)children.nextElement());
        }
    }

    public abstract NavigationTreeTableNode createNavigationTreeTableNode(String var1, String var2, JAXXContextEntryDef<?> var3, String var4);

    public static abstract class ChildBuilder<O> {
        protected NavigationTreeModelBuilder builder;

        protected ChildBuilder(NavigationTreeModelBuilder builder) {
            this.builder = builder;
        }

        protected abstract void init(Class<? extends O> var1);

        protected abstract Decorator<? extends O> getDecorator(O var1);

        protected abstract String getJXPath(O var1);

        protected abstract String getNavigationPath(O var1);

        public void build(NavigationTreeNode parent, boolean cacheValues, Class<? extends O> klass, Collection<? extends O> beans, Class<? extends JAXXObject> ui, Class<? extends JAXXAction> actionClass) {
            if (beans == null || beans.isEmpty()) {
                return;
            }
            this.init(klass);
            for (O o : beans) {
                NavigationTreeNode node = this.builder.build(parent, this.getDecorator(o), this.getJXPath(o), this.getNavigationPath(o), ui, actionClass);
                if (!cacheValues) continue;
                node.setBean(o);
            }
        }

        public void build(NavigationTreeNode parent, boolean cacheValues, Class<? extends O> klass, O[] beans, Class<? extends JAXXObject> ui, Class<? extends JAXXAction> actionClass) {
            if (beans == null || beans.length == 0) {
                return;
            }
            this.init(klass);
            for (O o : beans) {
                NavigationTreeNode node = this.builder.build(parent, this.getDecorator(o), this.getJXPath(o), this.getNavigationPath(o), ui, actionClass);
                if (!cacheValues) continue;
                node.setBean(o);
            }
        }
    }
}

