/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.nuiton.i18n.plugin.AbstractI18nMojo;
import org.nuiton.i18n.plugin.parser.FileParser;
import org.nuiton.i18n.plugin.parser.I18nParserConfiguration;
import org.nuiton.i18n.plugin.parser.I18nSourceEntry;
import org.nuiton.i18n.plugin.parser.ParserThread;
import org.nuiton.i18n.plugin.parser.SourceEntry;
import org.nuiton.io.FileUpdater;
import org.nuiton.io.SortedProperties;
import org.nuiton.plugin.PluginHelper;

public abstract class AbstractI18nParserMojo
extends AbstractI18nMojo
implements I18nParserConfiguration {
    @Deprecated
    protected boolean keysModifier;
    protected boolean treateDefaultEntry;
    protected I18nSourceEntry[] entries;
    protected boolean showTouchedFiles;
    @Deprecated
    protected boolean safeMode;
    protected boolean backupGetter;
    protected boolean force;
    private SortedProperties result;
    protected SortedProperties oldParser;
    protected SortedProperties oldLanguage;
    protected long t0;
    ParserThread thread;

    protected abstract String getOutGetter();

    @Deprecated
    protected abstract String getKeyModifierStart();

    @Deprecated
    protected abstract String getKeyModifierEnd();

    protected abstract String[] getDefaultIncludes();

    protected abstract String[] getDefaultExcludes();

    protected abstract File getDefaultBasedir();

    public abstract FileParser newFileParser();

    public abstract FileUpdater newFileUpdater(SourceEntry var1);

    @Override
    public boolean isStrictMode() {
        return this.strictMode;
    }

    public boolean isForce() {
        return this.force;
    }

    @Override
    public void init() throws Exception {
        super.init();
        this.t0 = System.nanoTime();
        this.result = new SortedProperties(this.encoding);
        this.oldParser = new SortedProperties(this.encoding);
        this.oldLanguage = new SortedProperties(this.encoding);
        this.createDirectoryIfNecessary(this.out);
        if (!(this.entries != null && this.entries.length != 0 || this.treateDefaultEntry)) {
            throw new IllegalStateException("No entry defined and treateDefaultEntry is false, will skip the goal.");
        }
        if (this.verbose && this.entries != null && this.entries.length > 0 && this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)("detected entries : " + this.entries.length));
            for (I18nSourceEntry e : this.entries) {
                this.getLog().info((CharSequence)(e.toString() + ", specific goal ? " + e.getSpecificGoal()));
            }
        }
        this.thread = new ParserThread(this);
    }

    protected void doAction() throws Exception {
        if (this.safeMode) {
            this.getLog().warn((CharSequence)"\n\nWarning : safeMode is deprecated and has no more effect.\n");
        }
        if (this.keysModifier) {
            this.getLog().warn((CharSequence)"\n\nWarning : keysModifier is deprecated and has no more effect.\n");
        }
        if (!this.silent && this.strictMode) {
            this.getLog().info((CharSequence)"config - strictMode is on (all files will be parsed).");
        }
        if (!this.silent && this.force) {
            this.getLog().info((CharSequence)"config - force is on (all files will be parsed).");
        }
        File oldParserFile = this.getGetterFile(this.out, this.getOutGetter(), true);
        File saveFile = this.getBackupFile(oldParserFile);
        this.oldParser.load(oldParserFile);
        if (this.backupGetter) {
            this.backupFile(oldParserFile);
        }
        File oldLanguageFile = this.getI18nFile(this.src, this.artifactId, this.locales[0], true);
        this.oldLanguage.load(oldLanguageFile);
        this.thread.start();
        if (this.treateDefaultEntry) {
            this.addDefaultEntry();
        }
        for (I18nSourceEntry entry : this.entries) {
            boolean skip = entry.init(this);
            if (skip) {
                if (this.silent || !this.verbose) continue;
                this.getLog().info((CharSequence)("skip - " + entry.getSkipMessage()));
                continue;
            }
            String[] files = entry.getFiles();
            if (!this.silent) {
                this.getLog().info((CharSequence)("start entry " + entry.toString()));
                this.getLog().info((CharSequence)(files.length + " file(s) to treate (amoung " + entry.getFoudFiles() + " files)"));
            }
            for (String file1 : files) {
                String fileName = entry.getBasedir().getAbsolutePath() + File.separator + file1;
                File file = new File(fileName);
                this.thread.addFile(this.newFileParser(), file);
            }
        }
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug((CharSequence)("ask to terminate " + this.thread));
        }
        this.thread.terminatesAndWaits();
        List<File> treadedFiles = this.thread.getTreatedFiles();
        List<File> touchedFiles = this.thread.getTouchedFiles();
        if (!this.backupGetter) {
            this.deleteFile(saveFile);
        }
        if (treadedFiles.isEmpty()) {
            if (!this.silent) {
                this.getLog().info((CharSequence)"Nothing was parsed - all files are up to date.");
            }
        } else {
            if (this.showTouchedFiles) {
                for (File f : touchedFiles) {
                    this.getLog().info((CharSequence)("touch " + f));
                }
            }
            if (!this.silent) {
                int i = touchedFiles.size();
                int max = treadedFiles.size();
                this.getLog().info((CharSequence)AbstractI18nParserMojo.getLogEntry("Parsing is done. [treated file(s) : " + i + '/' + max + "]", max, 0L, this.t0));
            }
            this.saveGetterFile();
            this.addGetter();
        }
        this.thread.clear();
    }

    @Override
    public boolean isShowTouchedFiles() {
        return this.showTouchedFiles;
    }

    @Override
    public SortedProperties getResult() {
        return this.result;
    }

    protected void addDefaultEntry() {
        if (this.verbose) {
            this.getLog().info((CharSequence)"add default entry");
        }
        boolean hasEntries = this.entries != null && this.entries.length > 0;
        I18nSourceEntry[] tmp = new I18nSourceEntry[hasEntries ? this.entries.length + 1 : 1];
        if (hasEntries) {
            System.arraycopy(this.entries, 0, tmp, 0, this.entries.length);
        }
        tmp[tmp.length - 1] = new I18nSourceEntry();
        this.entries = tmp;
    }

    protected void saveGetterFile() throws IOException {
        File getterFile = this.getGetterFile(this.out, this.getOutGetter(), false);
        this.result.store(getterFile);
    }

    public static String getLogEntry(String msg, int nbFiles, long time, long all) {
        long now = System.nanoTime();
        long delta = now - time;
        String s = msg;
        if (time > 0L && all == 0L) {
            s = s + " (" + PluginHelper.convertTime((long)delta) + ")";
        }
        if (all > 0L) {
            s = s + "(total time:" + PluginHelper.convertTime((long)(now - all)) + ")";
        }
        if (nbFiles > 0) {
            s = s + " ( ~ " + PluginHelper.convertTime((long)((now - all) / (long)nbFiles)) + " / file)";
        }
        return s;
    }
}

