/*
 * *##% Plugin maven pour i18n
 * Copyright (C) 2007 - 2009 CodeLutin
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation, either version 3 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Lesser Public License for more details.
 *
 * You should have received a copy of the GNU General Lesser Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0.html>. ##%* */

package org.nuiton.i18n.plugin.parser;

import java.io.File;
import java.io.IOException;

/**
 * Interface type pour la définition d'un nouveau parser.
 * <p/>
 * Une implantation abstraite est proposée : {@link AbstractI18nParser}.
 *
 * @author julien
 */
public interface Parser {

    /**
     * Lancement du parser
     *
     * @throws java.io.IOException if any io pb
     */
    public void parse() throws IOException;

    /**
     * Parse sur un fichier
     *
     * @param file le fichier à parser
     */
    public void parseFile(File file);

    /**
     * Parse une partie du fichier
     *
     * @param file le fichier à parser
     * @param args ? TODO
     */
    public void parseLine(File file, String args);

}
