/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin.writer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;
import org.nuiton.eugene.ModelReader;
import org.nuiton.eugene.Template;
import org.nuiton.eugene.models.Model;
import org.nuiton.eugene.plugin.writer.BaseChainedFileWriter;
import org.nuiton.eugene.writer.ChainedFileWriterConfiguration;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginIOContext;

public class ModelChainedFileWriter
extends BaseChainedFileWriter {
    public static final String PROP_GENERATED_PACKAGES = "generatedPackages";
    public static final String PROP_EXCLUDE_TEMPLATES = "excludetemplates";
    public static final String PROP_TEMPLATES = "templates";
    public static final String PROP_TEMPLATES_LIST = "templatesList";
    public static final String PROP_DEFAULT_PACKAGE = "defaultPackage";
    public static final String PROP_MODEL_READER = "modelReader";
    public static final String PROP_READER = "reader";

    public ModelChainedFileWriter() {
        super(PROP_TEMPLATES, PROP_TEMPLATES, PROP_TEMPLATES_LIST, PROP_TEMPLATES_LIST, PROP_EXCLUDE_TEMPLATES, PROP_EXCLUDE_TEMPLATES, PROP_READER, PROP_READER, PROP_MODEL_READER, PROP_MODEL_READER, PROP_GENERATED_PACKAGES, PROP_GENERATED_PACKAGES, PROP_DEFAULT_PACKAGE, PROP_DEFAULT_PACKAGE);
    }

    public String getInputProtocol() {
        return "model";
    }

    public String getOutputProtocol(String modelType) {
        return null;
    }

    public boolean acceptModel(String modelType) {
        return this.acceptObjectModelOrStateModel(modelType);
    }

    public boolean acceptInclude(String include) {
        return include.startsWith("model:") || include.endsWith(".objectmodel") || include.endsWith(".statemodel");
    }

    public String getDefaultIncludes() {
        return "**/*.*model";
    }

    public String getDefaultInputDirectory() {
        return "src/main/models";
    }

    public String getDefaultOutputDirectory() {
        return "java";
    }

    public String getDefaultTestInputDirectory() {
        return "src/test/models";
    }

    public String getDefaultTestOutputDirectory() {
        return "test-java";
    }

    public String getDefaultPackage() {
        return (String)this.getProperty(PROP_DEFAULT_PACKAGE, String.class);
    }

    public String[] getExcludeTemplates() {
        return (String[])this.getProperty(PROP_EXCLUDE_TEMPLATES, String[].class);
    }

    public String getGeneratedPackages() {
        return (String)this.getProperty(PROP_GENERATED_PACKAGES, String.class);
    }

    public List<Template<Model>> getTemplatesList() {
        return (List)this.getProperty(PROP_TEMPLATES_LIST, List.class);
    }

    public String getTemplates() {
        return (String)this.getProperty(PROP_TEMPLATES, String.class);
    }

    protected ModelReader<?> getModelReader() {
        return (ModelReader)this.getProperty(PROP_MODEL_READER, ModelReader.class);
    }

    protected String getReader() {
        return (String)this.getProperty(PROP_READER, String.class);
    }

    @Override
    protected void initWriter(ChainedFileWriterConfiguration configuration) {
        String[] templatesNames;
        super.initWriter(configuration);
        ClassLoader loader = configuration.getClassLoader();
        if (this.getModelReader() == null) {
            if (this.getReader() != null) {
                String reader = this.getReader();
                try {
                    ClassLoader fixedClassLoader = loader;
                    ModelReader modelReader = (ModelReader)Class.forName(reader, true, fixedClassLoader).newInstance();
                    this.properties.put(PROP_MODEL_READER, modelReader);
                }
                catch (Exception eee) {
                    throw new IllegalStateException("could not obtain reader " + reader, eee);
                }
            } else {
                String modelType = configuration.getModelType();
                ModelReader modelReader = (ModelReader)configuration.getModelReaders().get(modelType);
                if (modelReader == null) {
                    throw new IllegalStateException("could not find a model reader for modelType : " + modelType + ", availables readers : " + configuration.getModelReaders().values());
                }
                this.properties.put(PROP_MODEL_READER, modelReader);
            }
        }
        Properties templateProperties = new Properties();
        templateProperties.setProperty(PROP_DEFAULT_PACKAGE, this.getDefaultPackage());
        templateProperties.setProperty("overwrite", String.valueOf(configuration.isOverwrite()));
        templateProperties.setProperty("encoding", configuration.getEncoding());
        templateProperties.setProperty("lastModifiedSource", String.valueOf(this.getModelReader().getLastModifiedSource()));
        String generatedPackages = this.getGeneratedPackages();
        if (StringUtils.isEmpty((String)generatedPackages)) {
            this.getLog().info((CharSequence)" generating all packages");
        } else {
            templateProperties.put(PROP_GENERATED_PACKAGES, generatedPackages);
            this.getLog().info((CharSequence)(" generating only for packages " + generatedPackages));
        }
        ArrayList<Template> templatesList = new ArrayList<Template>();
        for (String templateName : templatesNames = this.getTemplates().split(",")) {
            templateName = templateName.trim();
            Template template = (Template)configuration.getModelTemplates().get(templateName);
            if (template == null) {
                this.getLog().warn((CharSequence)("template [" + templateName + "] is not registred via plexus, try to load it directly"));
                try {
                    template = (Template)Class.forName(templateName, true, loader).newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException("Can't obtain template [" + templateName + "] for reason " + e.getMessage(), e);
                }
            } else {
                this.getLog().info((CharSequence)("will use the template [" + templateName + "]"));
            }
            templatesList.add(template);
            template.setProperties(templateProperties);
        }
        this.properties.put(PROP_TEMPLATES_LIST, templatesList);
    }

    public void generate(ChainedFileWriterConfiguration configuration, File outputDir, File inputDirectory, String includePattern) throws IOException {
        PluginIOContext ioContext = new PluginIOContext();
        ioContext.setInput(inputDirectory);
        ioContext.setOutput(outputDir);
        ArrayList modelFiles = new ArrayList();
        Object[] includePatterns = includePattern.split(",");
        this.getLog().info((CharSequence)("Generating from " + inputDirectory + " : " + includePattern));
        for (File srcDirGen : ioContext.getInputs()) {
            if (configuration.isVerbose()) {
                this.getLog().info((CharSequence)("Search for " + Arrays.toString(includePatterns) + " in " + srcDirGen.getAbsolutePath()));
            }
            List currentFiles = PluginHelper.getIncludedFiles((File)srcDirGen, (String[])includePatterns, null);
            modelFiles.addAll(currentFiles);
        }
        Model model = this.getModelReader().read(modelFiles.toArray(new File[modelFiles.size()]));
        for (Template<Model> template : this.getTemplatesList()) {
            this.getLog().info((CharSequence)("Apply " + template.getClass().getSimpleName() + " generator"));
            template.applyTemplate(model, ioContext.getOutput());
        }
    }
}

