/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.eugene.plugin;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.nuiton.eugene.plugin.EugeneAbstractMojo;
import org.nuiton.plugin.PluginHelper;
import org.nuiton.plugin.PluginIOContext;

public class CopyVersionFiles
extends EugeneAbstractMojo
implements FileFilter {
    protected PluginIOContext copyVersionResources;
    protected String includes;
    protected String copyVersionDir;
    protected String copyVersionFiles;
    protected String versionFound = null;
    protected String modelNameFound = null;
    protected File fVersionDir;

    public void doAction() throws MojoExecutionException, MojoFailureException {
        this.findVersionAndModelName();
        if (this.versionFound == null || !this.versionFound.matches("[0-9]+(\\.[0-9]+)*")) {
            this.versionFound = "0";
            this.getLog().info((CharSequence)("No version found in model files, setting version to '" + this.versionFound + "'"));
        } else {
            this.getLog().info((CharSequence)("Version '" + this.versionFound + "' found in model description"));
        }
        String destDir = this.copyVersionDir.replace("%MODELNAME%", this.modelNameFound) + File.separator + this.versionFound;
        this.fVersionDir = new File(destDir);
        if (this.overwrite || !this.checkExistence()) {
            try {
                PluginHelper.copyFiles((File)this.copyVersionResources.getOutput(), (File)this.fVersionDir, (String[])new String[]{this.copyVersionFiles}, null, (boolean)true);
            }
            catch (IOException ex) {
                throw new MojoExecutionException("could not copy some files for reason " + ex.getMessage(), (Exception)ex);
            }
        }
    }

    @Override
    protected PluginIOContext getResources() {
        return this.copyVersionResources;
    }

    @Override
    protected PluginIOContext initResources() {
        File defaultIn = this.getFileFromBasedir(new String[]{"target", "generated-sources", "models"});
        File defaultOut = this.getFileFromBasedir(new String[]{"target", "generated-sources", "java"});
        File defaultTestIn = this.getFileFromBasedir(new String[]{"target", "generated-sources", "test-models"});
        File defaultTestOut = this.getFileFromBasedir(new String[]{"target", "generated-sources", "test-java"});
        this.copyVersionResources = this.initResources(defaultIn, defaultOut, defaultTestIn, defaultTestOut);
        return this.copyVersionResources;
    }

    protected boolean checkExistence() {
        boolean exist = false;
        if (this.fVersionDir.exists() && this.fVersionDir.listFiles().length > 0) {
            this.getLog().warn((CharSequence)("[COPY] Warning saved files for version '" + this.versionFound + "' and name '" + this.modelNameFound + "' already exists"));
            this.getLog().warn((CharSequence)"[COPY] Copy won't be done unless copyOverwrite parameter is set to 'true' or version is updated");
            exist = true;
        }
        return exist;
    }

    protected void findVersionAndModelName() {
        File[] modelFiles;
        File srcModelDir = this.copyVersionResources.getInputs()[0];
        for (File modelFile : modelFiles = srcModelDir.listFiles(this)) {
            SAXReader saxR = new SAXReader();
            try {
                Document document = saxR.read(modelFile);
                Node node = document.selectSingleNode("/objectModel/@version");
                if (node != null) {
                    this.versionFound = node.getStringValue();
                }
                if ((node = document.selectSingleNode("/objectModel/@name")) == null) continue;
                this.modelNameFound = node.getStringValue();
            }
            catch (DocumentException e) {
                this.getLog().error((CharSequence)"Can't read document", (Throwable)e);
            }
        }
    }

    @Override
    public boolean accept(File arg0) {
        String fullPath = arg0.getAbsolutePath();
        String regexInclude = this.includes.replaceAll("\\.", "\\.").replaceAll("([^\\*])\\*([^\\*])", "$1[^/]*$2").replaceAll("\\*\\*", ".*") + "$";
        return fullPath.matches(regexInclude);
    }
}

