/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.weightinit.impl;

import org.apache.commons.math3.util.FastMath;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.weightinit.BaseWeightInitScheme;
import org.nd4j.weightinit.WeightInit;

public class XavierFanInInitScheme
extends BaseWeightInitScheme {
    private double fanIn;

    public XavierFanInInitScheme(char order, double fanIn) {
        super(order);
        this.fanIn = fanIn;
    }

    @Override
    public INDArray doCreate(DataType dataType, long[] shape, INDArray paramsView) {
        return Nd4j.randn(dataType, this.order(), shape).divi(FastMath.sqrt((double)this.fanIn));
    }

    @Override
    public WeightInit type() {
        return WeightInit.XAVIER_FAN_IN;
    }

    public static XavierFanInInitSchemeBuilder builder() {
        return new XavierFanInInitSchemeBuilder();
    }

    public static class XavierFanInInitSchemeBuilder {
        private char order;
        private double fanIn;

        XavierFanInInitSchemeBuilder() {
        }

        public XavierFanInInitSchemeBuilder order(char order) {
            this.order = order;
            return this;
        }

        public XavierFanInInitSchemeBuilder fanIn(double fanIn) {
            this.fanIn = fanIn;
            return this;
        }

        public XavierFanInInitScheme build() {
            return new XavierFanInInitScheme(this.order, this.fanIn);
        }

        public String toString() {
            return "XavierFanInInitScheme.XavierFanInInitSchemeBuilder(order=" + this.order + ", fanIn=" + this.fanIn + ")";
        }
    }
}

