/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.schedule;

import org.nd4j.linalg.schedule.ISchedule;
import org.nd4j.linalg.schedule.ScheduleType;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class CycleSchedule
implements ISchedule {
    private final ScheduleType scheduleType;
    private final double initialLearningRate;
    private final double maxLearningRate;
    private final int cycleLength;
    private final int annealingLength;
    private final int stepSize;
    private final double increment;
    private double annealingDecay;

    public CycleSchedule(@JsonProperty(value="scheduleType") ScheduleType scheduleType, @JsonProperty(value="initialLearningRate") double initialLearningRate, @JsonProperty(value="maxLearningRate") double maxLearningRate, @JsonProperty(value="cycleLength") int cycleLength, @JsonProperty(value="annealingLength") int annealingLength, @JsonProperty(value="annealingDecay") double annealingDecay) {
        this.scheduleType = scheduleType;
        this.initialLearningRate = initialLearningRate;
        this.maxLearningRate = maxLearningRate;
        this.cycleLength = cycleLength;
        this.annealingDecay = annealingDecay;
        this.annealingLength = annealingLength;
        this.stepSize = (cycleLength - annealingLength) / 2;
        this.increment = (maxLearningRate - initialLearningRate) / (double)this.stepSize;
    }

    public CycleSchedule(ScheduleType scheduleType, double maxLearningRate, int cycleLength) {
        this(scheduleType, maxLearningRate * 0.1, maxLearningRate, cycleLength, (int)Math.round((double)cycleLength * 0.1), 0.1);
    }

    @Override
    public double valueAt(int iteration, int epoch) {
        int positionInCycle = (this.scheduleType == ScheduleType.EPOCH ? epoch : iteration) % this.cycleLength;
        double learningRate = positionInCycle < this.stepSize ? this.initialLearningRate + this.increment * (double)positionInCycle : (positionInCycle < 2 * this.stepSize ? this.maxLearningRate - this.increment * (double)(positionInCycle - this.stepSize) : this.initialLearningRate * Math.pow(this.annealingDecay, this.annealingLength - (this.cycleLength - positionInCycle)));
        return learningRate;
    }

    @Override
    public ISchedule clone() {
        return new CycleSchedule(this.scheduleType, this.initialLearningRate, this.maxLearningRate, this.cycleLength, this.annealingLength, this.annealingDecay);
    }

    public ScheduleType getScheduleType() {
        return this.scheduleType;
    }

    public double getInitialLearningRate() {
        return this.initialLearningRate;
    }

    public double getMaxLearningRate() {
        return this.maxLearningRate;
    }

    public int getCycleLength() {
        return this.cycleLength;
    }

    public int getAnnealingLength() {
        return this.annealingLength;
    }

    public int getStepSize() {
        return this.stepSize;
    }

    public double getIncrement() {
        return this.increment;
    }

    public double getAnnealingDecay() {
        return this.annealingDecay;
    }

    public void setAnnealingDecay(double annealingDecay) {
        this.annealingDecay = annealingDecay;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CycleSchedule)) {
            return false;
        }
        CycleSchedule other = (CycleSchedule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScheduleType this$scheduleType = this.getScheduleType();
        ScheduleType other$scheduleType = other.getScheduleType();
        if (this$scheduleType == null ? other$scheduleType != null : !((Object)((Object)this$scheduleType)).equals((Object)other$scheduleType)) {
            return false;
        }
        if (Double.compare(this.getInitialLearningRate(), other.getInitialLearningRate()) != 0) {
            return false;
        }
        if (Double.compare(this.getMaxLearningRate(), other.getMaxLearningRate()) != 0) {
            return false;
        }
        if (this.getCycleLength() != other.getCycleLength()) {
            return false;
        }
        if (this.getAnnealingLength() != other.getAnnealingLength()) {
            return false;
        }
        if (this.getStepSize() != other.getStepSize()) {
            return false;
        }
        if (Double.compare(this.getIncrement(), other.getIncrement()) != 0) {
            return false;
        }
        return Double.compare(this.getAnnealingDecay(), other.getAnnealingDecay()) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof CycleSchedule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScheduleType $scheduleType = this.getScheduleType();
        result = result * 59 + ($scheduleType == null ? 43 : ((Object)((Object)$scheduleType)).hashCode());
        long $initialLearningRate = Double.doubleToLongBits(this.getInitialLearningRate());
        result = result * 59 + (int)($initialLearningRate >>> 32 ^ $initialLearningRate);
        long $maxLearningRate = Double.doubleToLongBits(this.getMaxLearningRate());
        result = result * 59 + (int)($maxLearningRate >>> 32 ^ $maxLearningRate);
        result = result * 59 + this.getCycleLength();
        result = result * 59 + this.getAnnealingLength();
        result = result * 59 + this.getStepSize();
        long $increment = Double.doubleToLongBits(this.getIncrement());
        result = result * 59 + (int)($increment >>> 32 ^ $increment);
        long $annealingDecay = Double.doubleToLongBits(this.getAnnealingDecay());
        result = result * 59 + (int)($annealingDecay >>> 32 ^ $annealingDecay);
        return result;
    }

    public String toString() {
        return "CycleSchedule(scheduleType=" + (Object)((Object)this.getScheduleType()) + ", initialLearningRate=" + this.getInitialLearningRate() + ", maxLearningRate=" + this.getMaxLearningRate() + ", cycleLength=" + this.getCycleLength() + ", annealingLength=" + this.getAnnealingLength() + ", stepSize=" + this.getStepSize() + ", increment=" + this.getIncrement() + ", annealingDecay=" + this.getAnnealingDecay() + ")";
    }
}

