/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.lossfunctions;

import org.nd4j.linalg.lossfunctions.ILossFunction;
import org.nd4j.linalg.lossfunctions.impl.LossBinaryXENT;
import org.nd4j.linalg.lossfunctions.impl.LossCosineProximity;
import org.nd4j.linalg.lossfunctions.impl.LossHinge;
import org.nd4j.linalg.lossfunctions.impl.LossKLD;
import org.nd4j.linalg.lossfunctions.impl.LossL1;
import org.nd4j.linalg.lossfunctions.impl.LossL2;
import org.nd4j.linalg.lossfunctions.impl.LossMAE;
import org.nd4j.linalg.lossfunctions.impl.LossMAPE;
import org.nd4j.linalg.lossfunctions.impl.LossMCXENT;
import org.nd4j.linalg.lossfunctions.impl.LossMSE;
import org.nd4j.linalg.lossfunctions.impl.LossMSLE;
import org.nd4j.linalg.lossfunctions.impl.LossNegativeLogLikelihood;
import org.nd4j.linalg.lossfunctions.impl.LossPoisson;
import org.nd4j.linalg.lossfunctions.impl.LossSparseMCXENT;
import org.nd4j.linalg.lossfunctions.impl.LossSquaredHinge;
import org.nd4j.linalg.lossfunctions.impl.LossWasserstein;

public class LossFunctions {

    public static enum LossFunction {
        MSE,
        L1,
        XENT,
        MCXENT,
        SPARSE_MCXENT,
        SQUARED_LOSS,
        RECONSTRUCTION_CROSSENTROPY,
        NEGATIVELOGLIKELIHOOD,
        COSINE_PROXIMITY,
        HINGE,
        SQUARED_HINGE,
        KL_DIVERGENCE,
        MEAN_ABSOLUTE_ERROR,
        L2,
        MEAN_ABSOLUTE_PERCENTAGE_ERROR,
        MEAN_SQUARED_LOGARITHMIC_ERROR,
        POISSON,
        WASSERSTEIN;


        public ILossFunction getILossFunction() {
            switch (this) {
                case MSE: 
                case SQUARED_LOSS: {
                    return new LossMSE();
                }
                case L1: {
                    return new LossL1();
                }
                case XENT: {
                    return new LossBinaryXENT();
                }
                case MCXENT: {
                    return new LossMCXENT();
                }
                case SPARSE_MCXENT: {
                    return new LossSparseMCXENT();
                }
                case KL_DIVERGENCE: 
                case RECONSTRUCTION_CROSSENTROPY: {
                    return new LossKLD();
                }
                case NEGATIVELOGLIKELIHOOD: {
                    return new LossNegativeLogLikelihood();
                }
                case COSINE_PROXIMITY: {
                    return new LossCosineProximity();
                }
                case HINGE: {
                    return new LossHinge();
                }
                case SQUARED_HINGE: {
                    return new LossSquaredHinge();
                }
                case MEAN_ABSOLUTE_ERROR: {
                    return new LossMAE();
                }
                case L2: {
                    return new LossL2();
                }
                case MEAN_ABSOLUTE_PERCENTAGE_ERROR: {
                    return new LossMAPE();
                }
                case MEAN_SQUARED_LOGARITHMIC_ERROR: {
                    return new LossMSLE();
                }
                case POISSON: {
                    return new LossPoisson();
                }
                case WASSERSTEIN: {
                    return new LossWasserstein();
                }
            }
            throw new UnsupportedOperationException("Unknown or not supported loss function: " + (Object)((Object)this));
        }
    }
}

