/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.factory;

import java.util.Arrays;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ndarray.INDArray;

public class NDValidation {
    private NDValidation() {
    }

    public static void validateNumerical(String opName, INDArray v) {
        if (v == null) {
            return;
        }
        if (v.dataType() == DataType.BOOL || v.dataType() == DataType.UTF8) {
            throw new IllegalStateException("Cannot apply operation \"" + opName + "\" to array with non-numerical data type " + (Object)((Object)v.dataType()));
        }
    }

    public static void validateNumerical(String opName, INDArray[] v) {
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.length; ++i) {
            if (v[i].dataType() != DataType.BOOL && v[i].dataType() != DataType.UTF8) continue;
            throw new IllegalStateException("Cannot apply operation \"" + opName + "\" to input array " + i + " with non-numerical data type " + (Object)((Object)v[i].dataType()));
        }
    }

    public static void validateNumerical(String opName, String inputName, INDArray v) {
        if (v == null) {
            return;
        }
        if (v.dataType() == DataType.BOOL || v.dataType() == DataType.UTF8) {
            throw new IllegalStateException("Input \"" + inputName + "\" for operation \"" + opName + "\" must be an numerical type type; got array with non-integer data type " + (Object)((Object)v.dataType()));
        }
    }

    public static void validateNumerical(String opName, String inputName, INDArray[] v) {
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.length; ++i) {
            if (v[i].dataType() != DataType.BOOL && v[i].dataType() != DataType.UTF8) continue;
            throw new IllegalStateException("Cannot apply operation \"" + opName + "\" to input \"" + inputName + "\" array " + i + " with non-numerical data type " + (Object)((Object)v[i].dataType()));
        }
    }

    public static void validateNumerical(String opName, INDArray v1, INDArray v2) {
        if (v1.dataType() == DataType.BOOL || v1.dataType() == DataType.UTF8 || v2.dataType() == DataType.BOOL || v2.dataType() == DataType.UTF8) {
            throw new IllegalStateException("Cannot perform operation \"" + opName + "\" on arrays if one or both variables are non-numerical: got " + (Object)((Object)v1.dataType()) + " and " + (Object)((Object)v2.dataType()));
        }
    }

    public static void validateInteger(String opName, INDArray v) {
        if (v == null) {
            return;
        }
        if (!v.dataType().isIntType()) {
            throw new IllegalStateException("Cannot apply operation \"" + opName + "\" to array with non-integer data type " + (Object)((Object)v.dataType()));
        }
    }

    public static void validateInteger(String opName, String inputName, INDArray v) {
        if (v == null) {
            return;
        }
        if (!v.dataType().isIntType()) {
            throw new IllegalStateException("Input \"" + inputName + "\" for operation \"" + opName + "\" must be an integer type; got array with non-integer data type " + (Object)((Object)v.dataType()));
        }
    }

    public static void validateInteger(String opName, String inputName, INDArray[] v) {
        if (v == null) {
            return;
        }
        for (int i = 0; i < v.length; ++i) {
            if (v[i].dataType().isIntType()) continue;
            throw new IllegalStateException("Input \"" + inputName + "\" for operation \"" + opName + "\" must be an integer type; got array with non-integer data type member" + (Object)((Object)v[i].dataType()));
        }
    }

    public static void validateFloatingPoint(String opName, INDArray v) {
        if (v == null) {
            return;
        }
        if (!v.dataType().isFPType()) {
            throw new IllegalStateException("Cannot apply operation \"" + opName + "\" to array with non-floating point data type " + (Object)((Object)v.dataType()));
        }
    }

    public static void validateFloatingPoint(String opName, String inputName, INDArray v) {
        if (v == null) {
            return;
        }
        if (!v.dataType().isFPType()) {
            throw new IllegalStateException("Input \"" + inputName + "\" for operation \"" + opName + "\" must be an floating point type; got array with non-floating point data type " + (Object)((Object)v.dataType()));
        }
    }

    public static void validateBool(String opName, INDArray v) {
        if (v == null) {
            return;
        }
        if (v.dataType() != DataType.BOOL) {
            throw new IllegalStateException("Cannot apply operation \"" + opName + "\" to array with non-boolean point data type " + (Object)((Object)v.dataType()));
        }
    }

    public static void validateBool(String opName, String inputName, INDArray v) {
        if (v == null) {
            return;
        }
        if (v.dataType() != DataType.BOOL) {
            throw new IllegalStateException("Input \"" + inputName + "\" for operation \"" + opName + "\" must be an boolean variable; got array with non-boolean data type " + (Object)((Object)v.dataType()));
        }
    }

    public static void validateBool(String opName, INDArray v1, INDArray v2) {
        if (v1.dataType() != DataType.BOOL || v2.dataType() != DataType.BOOL) {
            throw new IllegalStateException("Cannot perform operation \"" + opName + "\" on array if one or both variables are non-boolean: " + (Object)((Object)v1.dataType()) + " and " + (Object)((Object)v2.dataType()));
        }
    }

    public static void validateSameType(String opName, boolean numericalOnly, INDArray ... vars) {
        if (vars.length == 0) {
            return;
        }
        if (vars.length == 1) {
            if (numericalOnly) {
                NDValidation.validateNumerical(opName, vars[0]);
            }
        } else {
            DataType first = vars[0].dataType();
            if (numericalOnly) {
                NDValidation.validateNumerical(opName, vars[0]);
            }
            for (int i = 1; i < vars.length; ++i) {
                if (first == vars[i].dataType()) continue;
                DataType[] dtypes = new DataType[vars.length];
                for (int j = 0; j < vars.length; ++j) {
                    dtypes[j] = vars[j].dataType();
                }
                throw new IllegalStateException("Cannot perform operation \"" + opName + "\" to arrays with different datatypes: Got arrays with datatypes " + Arrays.toString((Object[])dtypes));
            }
        }
    }

    public static boolean isSameType(INDArray x, INDArray y) {
        return x.dataType() == y.dataType();
    }

    public static boolean isSameType(INDArray[] x) {
        if (x.length == 0) {
            return true;
        }
        DataType first = x[0].dataType();
        for (int i = 1; i < x.length; ++i) {
            if (first == x[i].dataType()) continue;
            return false;
        }
        return true;
    }
}

