/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.autodiff.samediff.ops;

import org.nd4j.autodiff.samediff.SDVariable;
import org.nd4j.autodiff.samediff.SameDiff;
import org.nd4j.autodiff.samediff.ops.SDOps;
import org.nd4j.autodiff.samediff.ops.SDValidation;
import org.nd4j.linalg.api.buffer.DataType;
import org.nd4j.linalg.api.ops.custom.LinearSolve;
import org.nd4j.linalg.api.ops.custom.Logdet;
import org.nd4j.linalg.api.ops.custom.Lstsq;
import org.nd4j.linalg.api.ops.custom.Lu;
import org.nd4j.linalg.api.ops.custom.MatrixBandPart;
import org.nd4j.linalg.api.ops.custom.Tri;
import org.nd4j.linalg.api.ops.custom.TriangularSolve;
import org.nd4j.linalg.api.ops.custom.Triu;
import org.nd4j.linalg.api.ops.impl.reduce.Mmul;
import org.nd4j.linalg.api.ops.impl.shape.Cross;
import org.nd4j.linalg.api.ops.impl.shape.Diag;
import org.nd4j.linalg.api.ops.impl.shape.DiagPart;
import org.nd4j.linalg.api.ops.impl.transforms.Cholesky;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Qr;
import org.nd4j.linalg.api.ops.impl.transforms.custom.Svd;

public class SDLinalg
extends SDOps {
    public SDLinalg(SameDiff sameDiff) {
        super(sameDiff);
    }

    public SDVariable cholesky(SDVariable input) {
        SDValidation.validateNumerical("Cholesky", "input", input);
        return new Cholesky(this.sd, input).outputVariable();
    }

    public SDVariable cholesky(String name, SDVariable input) {
        SDValidation.validateNumerical("Cholesky", "input", input);
        SDVariable out = new Cholesky(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable lstsq(SDVariable matrix, SDVariable rhs, double l2_reguralizer, boolean fast) {
        SDValidation.validateNumerical("Lstsq", "matrix", matrix);
        SDValidation.validateNumerical("Lstsq", "rhs", rhs);
        return new Lstsq(this.sd, matrix, rhs, l2_reguralizer, fast).outputVariable();
    }

    public SDVariable lstsq(String name, SDVariable matrix, SDVariable rhs, double l2_reguralizer, boolean fast) {
        SDValidation.validateNumerical("Lstsq", "matrix", matrix);
        SDValidation.validateNumerical("Lstsq", "rhs", rhs);
        SDVariable out = new Lstsq(this.sd, matrix, rhs, l2_reguralizer, fast).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable lstsq(SDVariable matrix, SDVariable rhs, double l2_reguralizer) {
        SDValidation.validateNumerical("Lstsq", "matrix", matrix);
        SDValidation.validateNumerical("Lstsq", "rhs", rhs);
        return new Lstsq(this.sd, matrix, rhs, l2_reguralizer, true).outputVariable();
    }

    public SDVariable lstsq(String name, SDVariable matrix, SDVariable rhs, double l2_reguralizer) {
        SDValidation.validateNumerical("Lstsq", "matrix", matrix);
        SDValidation.validateNumerical("Lstsq", "rhs", rhs);
        SDVariable out = new Lstsq(this.sd, matrix, rhs, l2_reguralizer, true).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable lu(SDVariable input) {
        SDValidation.validateNumerical("Lu", "input", input);
        return new Lu(this.sd, input).outputVariable();
    }

    public SDVariable lu(String name, SDVariable input) {
        SDValidation.validateNumerical("Lu", "input", input);
        SDVariable out = new Lu(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable matmul(SDVariable a, SDVariable b) {
        SDValidation.validateNumerical("Matmul", "a", a);
        SDValidation.validateNumerical("Matmul", "b", b);
        return new Mmul(this.sd, a, b).outputVariable();
    }

    public SDVariable matmul(String name, SDVariable a, SDVariable b) {
        SDValidation.validateNumerical("Matmul", "a", a);
        SDValidation.validateNumerical("Matmul", "b", b);
        SDVariable out = new Mmul(this.sd, a, b).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable[] matrixBandPart(SDVariable input, int minLower, int maxUpper) {
        SDValidation.validateNumerical("MatrixBandPart", "input", input);
        return new MatrixBandPart(this.sd, input, minLower, maxUpper).outputVariables();
    }

    public SDVariable[] matrixBandPart(String[] names, SDVariable input, int minLower, int maxUpper) {
        SDValidation.validateNumerical("MatrixBandPart", "input", input);
        SDVariable[] out = new MatrixBandPart(this.sd, input, minLower, maxUpper).outputVariables();
        return this.sd.updateVariableNamesAndReferences(out, names);
    }

    public SDVariable[] qr(SDVariable input, boolean full) {
        SDValidation.validateNumerical("Qr", "input", input);
        return new Qr(this.sd, input, full).outputVariables();
    }

    public SDVariable[] qr(String[] names, SDVariable input, boolean full) {
        SDValidation.validateNumerical("Qr", "input", input);
        SDVariable[] out = new Qr(this.sd, input, full).outputVariables();
        return this.sd.updateVariableNamesAndReferences(out, names);
    }

    public SDVariable[] qr(SDVariable input) {
        SDValidation.validateNumerical("Qr", "input", input);
        return new Qr(this.sd, input, false).outputVariables();
    }

    public SDVariable[] qr(String[] names, SDVariable input) {
        SDValidation.validateNumerical("Qr", "input", input);
        SDVariable[] out = new Qr(this.sd, input, false).outputVariables();
        return this.sd.updateVariableNamesAndReferences(out, names);
    }

    public SDVariable solve(SDVariable matrix, SDVariable rhs, boolean adjoint) {
        SDValidation.validateNumerical("Solve", "matrix", matrix);
        SDValidation.validateNumerical("Solve", "rhs", rhs);
        return new LinearSolve(this.sd, matrix, rhs, adjoint).outputVariable();
    }

    public SDVariable solve(String name, SDVariable matrix, SDVariable rhs, boolean adjoint) {
        SDValidation.validateNumerical("Solve", "matrix", matrix);
        SDValidation.validateNumerical("Solve", "rhs", rhs);
        SDVariable out = new LinearSolve(this.sd, matrix, rhs, adjoint).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable solve(SDVariable matrix, SDVariable rhs) {
        SDValidation.validateNumerical("Solve", "matrix", matrix);
        SDValidation.validateNumerical("Solve", "rhs", rhs);
        return new LinearSolve(this.sd, matrix, rhs, false).outputVariable();
    }

    public SDVariable solve(String name, SDVariable matrix, SDVariable rhs) {
        SDValidation.validateNumerical("Solve", "matrix", matrix);
        SDValidation.validateNumerical("Solve", "rhs", rhs);
        SDVariable out = new LinearSolve(this.sd, matrix, rhs, false).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable triangularSolve(SDVariable matrix, SDVariable rhs, boolean lower, boolean adjoint) {
        SDValidation.validateNumerical("TriangularSolve", "matrix", matrix);
        SDValidation.validateNumerical("TriangularSolve", "rhs", rhs);
        return new TriangularSolve(this.sd, matrix, rhs, lower, adjoint).outputVariable();
    }

    public SDVariable triangularSolve(String name, SDVariable matrix, SDVariable rhs, boolean lower, boolean adjoint) {
        SDValidation.validateNumerical("TriangularSolve", "matrix", matrix);
        SDValidation.validateNumerical("TriangularSolve", "rhs", rhs);
        SDVariable out = new TriangularSolve(this.sd, matrix, rhs, lower, adjoint).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable cross(SDVariable a, SDVariable b) {
        SDValidation.validateNumerical("cross", "a", a);
        SDValidation.validateNumerical("cross", "b", b);
        return new Cross(this.sd, a, b).outputVariable();
    }

    public SDVariable cross(String name, SDVariable a, SDVariable b) {
        SDValidation.validateNumerical("cross", "a", a);
        SDValidation.validateNumerical("cross", "b", b);
        SDVariable out = new Cross(this.sd, a, b).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable diag(SDVariable input) {
        SDValidation.validateNumerical("diag", "input", input);
        return new Diag(this.sd, input).outputVariable();
    }

    public SDVariable diag(String name, SDVariable input) {
        SDValidation.validateNumerical("diag", "input", input);
        SDVariable out = new Diag(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable diag_part(SDVariable input) {
        SDValidation.validateNumerical("diag_part", "input", input);
        return new DiagPart(this.sd, input).outputVariable();
    }

    public SDVariable diag_part(String name, SDVariable input) {
        SDValidation.validateNumerical("diag_part", "input", input);
        SDVariable out = new DiagPart(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable logdet(SDVariable input) {
        SDValidation.validateNumerical("logdet", "input", input);
        return new Logdet(this.sd, input).outputVariable();
    }

    public SDVariable logdet(String name, SDVariable input) {
        SDValidation.validateNumerical("logdet", "input", input);
        SDVariable out = new Logdet(this.sd, input).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable mmul(SDVariable x, SDVariable y, boolean transposeX, boolean transposeY, boolean transposeZ) {
        SDValidation.validateNumerical("mmul", "x", x);
        SDValidation.validateNumerical("mmul", "y", y);
        return new Mmul(this.sd, x, y, transposeX, transposeY, transposeZ).outputVariable();
    }

    public SDVariable mmul(String name, SDVariable x, SDVariable y, boolean transposeX, boolean transposeY, boolean transposeZ) {
        SDValidation.validateNumerical("mmul", "x", x);
        SDValidation.validateNumerical("mmul", "y", y);
        SDVariable out = new Mmul(this.sd, x, y, transposeX, transposeY, transposeZ).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable mmul(SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("mmul", "x", x);
        SDValidation.validateNumerical("mmul", "y", y);
        return new Mmul(this.sd, x, y, false, false, false).outputVariable();
    }

    public SDVariable mmul(String name, SDVariable x, SDVariable y) {
        SDValidation.validateNumerical("mmul", "x", x);
        SDValidation.validateNumerical("mmul", "y", y);
        SDVariable out = new Mmul(this.sd, x, y, false, false, false).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable svd(SDVariable input, boolean fullUV, boolean computeUV, int switchNum) {
        SDValidation.validateNumerical("svd", "input", input);
        return new Svd(this.sd, input, fullUV, computeUV, switchNum).outputVariable();
    }

    public SDVariable svd(String name, SDVariable input, boolean fullUV, boolean computeUV, int switchNum) {
        SDValidation.validateNumerical("svd", "input", input);
        SDVariable out = new Svd(this.sd, input, fullUV, computeUV, switchNum).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable svd(SDVariable input, boolean fullUV, boolean computeUV) {
        SDValidation.validateNumerical("svd", "input", input);
        return new Svd(this.sd, input, fullUV, computeUV, 16).outputVariable();
    }

    public SDVariable svd(String name, SDVariable input, boolean fullUV, boolean computeUV) {
        SDValidation.validateNumerical("svd", "input", input);
        SDVariable out = new Svd(this.sd, input, fullUV, computeUV, 16).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable tri(DataType dataType, int row, int column, int diagonal) {
        return new Tri(this.sd, dataType, row, column, diagonal).outputVariable();
    }

    public SDVariable tri(String name, DataType dataType, int row, int column, int diagonal) {
        SDVariable out = new Tri(this.sd, dataType, row, column, diagonal).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable tri(int row, int column) {
        return new Tri(this.sd, DataType.FLOAT, row, column, 0).outputVariable();
    }

    public SDVariable tri(String name, int row, int column) {
        SDVariable out = new Tri(this.sd, DataType.FLOAT, row, column, 0).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable triu(SDVariable input, int diag) {
        SDValidation.validateNumerical("triu", "input", input);
        return new Triu(this.sd, input, diag).outputVariable();
    }

    public SDVariable triu(String name, SDVariable input, int diag) {
        SDValidation.validateNumerical("triu", "input", input);
        SDVariable out = new Triu(this.sd, input, diag).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }

    public SDVariable triu(SDVariable input) {
        SDValidation.validateNumerical("triu", "input", input);
        return new Triu(this.sd, input, 0).outputVariable();
    }

    public SDVariable triu(String name, SDVariable input) {
        SDValidation.validateNumerical("triu", "input", input);
        SDVariable out = new Triu(this.sd, input, 0).outputVariable();
        return this.sd.updateVariableNameAndReference(out, name);
    }
}

