/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.jboss.logging.Logger;
import org.keycloak.common.VerificationException;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.SignatureProvider;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.jose.jws.JWSInputException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.protocol.oid4vc.issuance.VCIssuanceContext;
import org.keycloak.protocol.oid4vc.issuance.VCIssuerException;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.CredentialBody;
import org.keycloak.protocol.oid4vc.issuance.credentialbuilder.SdJwtCredentialBody;
import org.keycloak.protocol.oid4vc.issuance.signing.JwtProofBasedSigningService;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningServiceException;
import org.keycloak.protocol.oid4vc.issuance.signing.VerifiableCredentialsSigningService;
import org.keycloak.protocol.oid4vc.model.CredentialConfigId;
import org.keycloak.protocol.oid4vc.model.VerifiableCredentialType;

public class SdJwtSigningService
extends JwtProofBasedSigningService<String> {
    private static final Logger LOGGER = Logger.getLogger(SdJwtSigningService.class);
    private static final String JWK_CLAIM = "jwk";
    private final SignatureSignerContext signatureSignerContext;
    private final CredentialConfigId vcConfigId;
    private final VerifiableCredentialType vct;

    public SdJwtSigningService(KeycloakSession keycloakSession, String keyId, String algorithmType, Optional<String> kid, VerifiableCredentialType credentialType, CredentialConfigId vcConfigId) {
        super(keycloakSession, keyId, "vc+sd-jwt", algorithmType);
        this.vcConfigId = vcConfigId;
        this.vct = credentialType;
        if (this.vcConfigId != null && this.vct == null) {
            throw new SigningServiceException(String.format("Missing vct for credential config id %s.", vcConfigId));
        }
        KeyWrapper signingKey = this.getKey(keyId, algorithmType);
        if (signingKey == null) {
            throw new SigningServiceException(String.format("No key for id %s and algorithm %s available.", keyId, algorithmType));
        }
        if (kid.isPresent()) {
            signingKey = signingKey.cloneKey();
            signingKey.setKid(keyId);
        }
        SignatureProvider signatureProvider = (SignatureProvider)keycloakSession.getProvider(SignatureProvider.class, algorithmType);
        this.signatureSignerContext = signatureProvider.signer(signingKey);
        LOGGER.debugf("Successfully initiated the SD-JWT Signing Service with algorithm %s.", (Object)algorithmType);
    }

    @Override
    public String signCredential(VCIssuanceContext vcIssuanceContext) throws VCIssuerException {
        JWK jwk;
        CredentialBody credentialBody = vcIssuanceContext.getCredentialBody();
        if (!(credentialBody instanceof SdJwtCredentialBody)) {
            throw new VCIssuerException("Credential body unexpectedly not of type SdJwtCredentialBody");
        }
        SdJwtCredentialBody sdJwtCredentialBody = (SdJwtCredentialBody)credentialBody;
        try {
            jwk = this.validateProof(vcIssuanceContext);
        }
        catch (IOException | VerificationException | JWSInputException e) {
            throw new VCIssuerException("Can not verify proof", e);
        }
        if (jwk != null) {
            sdJwtCredentialBody.addCnfClaim(Map.of(JWK_CLAIM, jwk));
        }
        return sdJwtCredentialBody.sign(this.signatureSignerContext);
    }

    @Override
    public String locator() {
        return VerifiableCredentialsSigningService.locator(this.format, this.vct, this.vcConfigId);
    }
}

