/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleMapperModel;
import org.keycloak.provider.ProviderEvent;

public interface GroupModel
extends RoleMapperModel {
    public static final Comparator<GroupModel> COMPARE_BY_NAME = Comparator.comparing(GroupModel::getName);

    public String getId();

    public String getName();

    public void setName(String var1);

    public void setSingleAttribute(String var1, String var2);

    public void setAttribute(String var1, List<String> var2);

    public void removeAttribute(String var1);

    public String getFirstAttribute(String var1);

    public Stream<String> getAttributeStream(String var1);

    public Map<String, List<String>> getAttributes();

    public GroupModel getParent();

    public String getParentId();

    public Stream<GroupModel> getSubGroupsStream();

    default public Stream<GroupModel> getSubGroupsStream(String search, Integer firstResult, Integer maxResults) {
        return this.getSubGroupsStream(search, false, firstResult, maxResults);
    }

    default public Stream<GroupModel> getSubGroupsStream(Integer firstResult, Integer maxResults) {
        return this.getSubGroupsStream(null, firstResult, maxResults);
    }

    default public Stream<GroupModel> getSubGroupsStream(String search, Boolean exact, Integer firstResult, Integer maxResults) {
        Stream<GroupModel> allSubgroupsGroups = this.getSubGroupsStream().filter(group -> {
            if (search == null || search.isEmpty()) {
                return true;
            }
            if (Boolean.TRUE.equals(exact)) {
                return group.getName().equals(search);
            }
            return group.getName().toLowerCase().contains(search.toLowerCase());
        });
        if (firstResult != null && firstResult > 0) {
            allSubgroupsGroups = allSubgroupsGroups.skip(firstResult.intValue());
        }
        if (maxResults != null && maxResults >= 0) {
            allSubgroupsGroups = allSubgroupsGroups.limit(maxResults.intValue());
        }
        return allSubgroupsGroups;
    }

    default public Long getSubGroupsCount() {
        return this.getSubGroupsStream().count();
    }

    public void setParent(GroupModel var1);

    public void addChild(GroupModel var1);

    public void removeChild(GroupModel var1);

    default public boolean escapeSlashesInGroupPath() {
        return false;
    }

    default public Type getType() {
        return Type.REALM;
    }

    public static enum Type {
        REALM(0),
        ORGANIZATION(1);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type valueOf(int value) {
            Type[] values = Type.values();
            for (int i = 0; i < values.length; ++i) {
                if (values[i].value != value) continue;
                return values[i];
            }
            throw new IllegalArgumentException("No type found with value " + value);
        }

        public int intValue() {
            return this.value;
        }
    }

    public static interface GroupPathChangeEvent
    extends GroupEvent {
        public String getNewPath();

        public String getPreviousPath();

        public static void fire(final GroupModel group, final String newPath, final String previousPath, final KeycloakSession session) {
            session.getKeycloakSessionFactory().publish(new GroupPathChangeEvent(){

                @Override
                public RealmModel getRealm() {
                    return session.getContext().getRealm();
                }

                @Override
                public GroupModel getGroup() {
                    return group;
                }

                @Override
                public KeycloakSession getKeycloakSession() {
                    return session;
                }

                @Override
                public String getNewPath() {
                    return newPath;
                }

                @Override
                public String getPreviousPath() {
                    return previousPath;
                }
            });
        }
    }

    public static interface GroupMemberLeaveEvent
    extends GroupEvent {
        public static void fire(final GroupModel group, final KeycloakSession session) {
            session.getKeycloakSessionFactory().publish(new GroupMemberLeaveEvent(){

                @Override
                public RealmModel getRealm() {
                    return session.getContext().getRealm();
                }

                @Override
                public GroupModel getGroup() {
                    return group;
                }

                @Override
                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            });
        }
    }

    public static interface GroupMemberJoinEvent
    extends GroupEvent {
        public static void fire(final GroupModel group, final KeycloakSession session) {
            session.getKeycloakSessionFactory().publish(new GroupMemberJoinEvent(){

                @Override
                public RealmModel getRealm() {
                    return session.getContext().getRealm();
                }

                @Override
                public GroupModel getGroup() {
                    return group;
                }

                @Override
                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            });
        }
    }

    public static interface GroupUpdatedEvent
    extends GroupEvent {
        public static void fire(final GroupModel group, final KeycloakSession session) {
            session.getKeycloakSessionFactory().publish(new GroupUpdatedEvent(){

                @Override
                public RealmModel getRealm() {
                    return session.getContext().getRealm();
                }

                @Override
                public GroupModel getGroup() {
                    return group;
                }

                @Override
                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            });
        }
    }

    public static interface GroupRemovedEvent
    extends GroupEvent {
    }

    public static interface GroupCreatedEvent
    extends GroupEvent {
        public static void fire(final GroupModel group, final KeycloakSession session) {
            session.getKeycloakSessionFactory().publish(new GroupCreatedEvent(){

                @Override
                public RealmModel getRealm() {
                    return session.getContext().getRealm();
                }

                @Override
                public GroupModel getGroup() {
                    return group;
                }

                @Override
                public KeycloakSession getKeycloakSession() {
                    return session;
                }
            });
        }
    }

    public static interface GroupEvent
    extends ProviderEvent {
        public RealmModel getRealm();

        public GroupModel getGroup();

        public KeycloakSession getKeycloakSession();
    }
}

