/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.sessions;

import org.infinispan.Cache;
import org.keycloak.cluster.ClusterListener;
import org.keycloak.cluster.ClusterProvider;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.sessions.AbstractLastSessionRefreshStoreFactory;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshListener;
import org.keycloak.models.sessions.infinispan.changes.sessions.CrossDCLastSessionRefreshStore;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;

public class CrossDCLastSessionRefreshStoreFactory
extends AbstractLastSessionRefreshStoreFactory {
    public static final String LSR_PERIODIC_TASK_NAME = "lastSessionRefreshes";
    public static final String LSR_OFFLINE_PERIODIC_TASK_NAME = "lastSessionRefreshes-offline";

    public CrossDCLastSessionRefreshStore createAndInit(KeycloakSession kcSession, Cache<String, SessionEntityWrapper<UserSessionEntity>> cache, boolean offline) {
        return this.createAndInit(kcSession, cache, 5000L, 60, 100, offline);
    }

    public CrossDCLastSessionRefreshStore createAndInit(KeycloakSession kcSession, Cache<String, SessionEntityWrapper<UserSessionEntity>> cache, long timerIntervalMs, int maxIntervalBetweenMessagesSeconds, int maxCount, boolean offline) {
        String eventKey = offline ? LSR_OFFLINE_PERIODIC_TASK_NAME : LSR_PERIODIC_TASK_NAME;
        CrossDCLastSessionRefreshStore store = this.createStoreInstance(maxIntervalBetweenMessagesSeconds, maxCount, eventKey);
        ClusterProvider cluster = (ClusterProvider)kcSession.getProvider(ClusterProvider.class);
        cluster.registerListener(eventKey, (ClusterListener)new CrossDCLastSessionRefreshListener(kcSession, cache, offline));
        this.setupPeriodicTimer(kcSession, store, timerIntervalMs, eventKey);
        return store;
    }

    protected CrossDCLastSessionRefreshStore createStoreInstance(int maxIntervalBetweenMessagesSeconds, int maxCount, String eventKey) {
        return new CrossDCLastSessionRefreshStore(maxIntervalBetweenMessagesSeconds, maxCount, eventKey);
    }
}

