/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.client.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.List;
import java.util.Set;
import org.keycloak.representations.idm.GroupRepresentation;
import org.keycloak.representations.idm.ManagementPermissionReference;
import org.keycloak.representations.idm.ManagementPermissionRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.representations.idm.UserRepresentation;

public interface RoleResource {
    @PUT
    @Path(value="/management/permissions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public ManagementPermissionReference setPermissions(ManagementPermissionRepresentation var1);

    @GET
    @Path(value="/management/permissions")
    @Produces(value={"application/json"})
    public ManagementPermissionReference getPermissions();

    @GET
    @Produces(value={"application/json"})
    public RoleRepresentation toRepresentation();

    @PUT
    @Consumes(value={"application/json"})
    public void update(RoleRepresentation var1);

    @DELETE
    public void remove();

    @GET
    @Path(value="composites")
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRoleComposites();

    @GET
    @Path(value="composites/realm")
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getRealmRoleComposites();

    @GET
    @Path(value="composites/clients/{clientUuid}")
    @Produces(value={"application/json"})
    public Set<RoleRepresentation> getClientRoleComposites(@PathParam(value="clientUuid") String var1);

    @POST
    @Path(value="composites")
    @Consumes(value={"application/json"})
    public void addComposites(List<RoleRepresentation> var1);

    @DELETE
    @Path(value="composites")
    @Consumes(value={"application/json"})
    public void deleteComposites(List<RoleRepresentation> var1);

    @GET
    @Path(value="users")
    @Produces(value={"application/json"})
    public List<UserRepresentation> getUserMembers();

    @GET
    @Path(value="users")
    @Produces(value={"application/json"})
    public List<UserRepresentation> getUserMembers(@QueryParam(value="first") Integer var1, @QueryParam(value="max") Integer var2);

    @GET
    @Path(value="users")
    @Produces(value={"application/json"})
    public List<UserRepresentation> getUserMembers(@QueryParam(value="briefRepresentation") Boolean var1, @QueryParam(value="first") Integer var2, @QueryParam(value="max") Integer var3);

    @GET
    @Path(value="groups")
    @Produces(value={"application/json"})
    public Set<GroupRepresentation> getRoleGroupMembers();

    @GET
    @Path(value="groups")
    @Produces(value={"application/json"})
    public Set<GroupRepresentation> getRoleGroupMembers(@QueryParam(value="first") Integer var1, @QueryParam(value="max") Integer var2);

    @GET
    @Path(value="users")
    @Produces(value={"application/json"})
    @Deprecated
    public Set<UserRepresentation> getRoleUserMembers();

    @GET
    @Path(value="users")
    @Produces(value={"application/json"})
    @Deprecated
    public Set<UserRepresentation> getRoleUserMembers(@QueryParam(value="first") Integer var1, @QueryParam(value="max") Integer var2);
}

