/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.tree.AbstractInsnNode;
import org.jruby.org.objectweb.asm.tree.LabelNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameNode
extends AbstractInsnNode {
    public int type;
    public List<Object> local;
    public List<Object> stack;

    private FrameNode() {
        super(-1);
    }

    public FrameNode(int type2, int nLocal, Object[] local2, int nStack, Object[] stack) {
        super(-1);
        this.type = type2;
        switch (type2) {
            case -1: 
            case 0: {
                this.local = FrameNode.asList(nLocal, local2);
                this.stack = FrameNode.asList(nStack, stack);
                break;
            }
            case 1: {
                this.local = FrameNode.asList(nLocal, local2);
                break;
            }
            case 2: {
                this.local = Arrays.asList(new Object[nLocal]);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.stack = FrameNode.asList(1, stack);
            }
        }
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public void accept(MethodVisitor mv) {
        switch (this.type) {
            case -1: 
            case 0: {
                mv.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), this.stack.size(), FrameNode.asArray(this.stack));
                break;
            }
            case 1: {
                mv.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), 0, null);
                break;
            }
            case 2: {
                mv.visitFrame(this.type, this.local.size(), null, 0, null);
                break;
            }
            case 3: {
                mv.visitFrame(this.type, 0, null, 0, null);
                break;
            }
            case 4: {
                mv.visitFrame(this.type, 0, null, 1, FrameNode.asArray(this.stack));
            }
        }
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> labels) {
        int i2;
        FrameNode clone2 = new FrameNode();
        clone2.type = this.type;
        if (this.local != null) {
            clone2.local = new ArrayList<Object>();
            for (i2 = 0; i2 < this.local.size(); ++i2) {
                Object l = this.local.get(i2);
                if (l instanceof LabelNode) {
                    l = labels.get(l);
                }
                clone2.local.add(l);
            }
        }
        if (this.stack != null) {
            clone2.stack = new ArrayList<Object>();
            for (i2 = 0; i2 < this.stack.size(); ++i2) {
                Object s2 = this.stack.get(i2);
                if (s2 instanceof LabelNode) {
                    s2 = labels.get(s2);
                }
                clone2.stack.add(s2);
            }
        }
        return clone2;
    }

    private static List<Object> asList(int n, Object[] o) {
        return Arrays.asList(o).subList(0, n);
    }

    private static Object[] asArray(List<Object> l) {
        Object[] objs = new Object[l.size()];
        for (int i2 = 0; i2 < objs.length; ++i2) {
            Object o = l.get(i2);
            if (o instanceof LabelNode) {
                o = ((LabelNode)o).getLabel();
            }
            objs[i2] = o;
        }
        return objs;
    }
}

