/*
 * Decompiled with CFR 0.152.
 */
package org.jooq.codegen.maven;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jooq.codegen.GenerationTool;
import org.jooq.meta.jaxb.Configuration;
import org.jooq.meta.jaxb.Generator;
import org.jooq.meta.jaxb.Jdbc;
import org.jooq.meta.jaxb.Logging;
import org.jooq.meta.jaxb.OnError;
import org.jooq.meta.jaxb.Target;
import org.jooq.util.jaxb.tools.MiniJAXB;

@Mojo(name="generate", defaultPhase=LifecyclePhase.GENERATE_SOURCES, requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true)
public class Plugin
extends AbstractMojo {
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject project;
    @Parameter(property="jooq.codegen.configurationFile")
    private String configurationFile;
    @Parameter(property="jooq.codegen.configurationFiles")
    private List<String> configurationFiles;
    @Parameter(property="jooq.codegen.basedir")
    private String basedir;
    @Parameter(property="jooq.codegen.skip")
    private boolean skip;
    @Parameter(property="jooq.codegen.logging")
    private Logging logging;
    @Parameter(property="jooq.codegen.onError")
    private OnError onError;
    @Parameter(property="jooq.codegen.onUnused")
    private OnError onUnused;
    @Parameter
    private Jdbc jdbc;
    @Parameter
    private Generator generator;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping jOOQ code generation");
            return;
        }
        if (this.configurationFiles != null && !this.configurationFiles.isEmpty()) {
            for (String file : this.configurationFiles) {
                this.read(file);
            }
        } else if (this.configurationFile != null) {
            this.read(this.configurationFile);
        }
        if (this.generator == null) {
            this.getLog().error((CharSequence)"Incorrect configuration of jOOQ code generation tool");
            this.getLog().error((CharSequence)"\nThe jOOQ-codegen-maven module's generator configuration is not set up correctly.\nThis can have a variety of reasons, among which:\n- Your pom.xml's <configuration> contains invalid XML according to jooq-codegen-3.18.0.xsd\n- There is a version or artifact mismatch between your pom.xml and your commandline");
            throw new MojoExecutionException("Incorrect configuration of jOOQ code generation tool. See error above for details.");
        }
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        URLClassLoader pluginClassLoader = this.getClassLoader();
        try {
            String actualBasedir;
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            String string = actualBasedir = this.basedir == null ? this.project.getBasedir().getAbsolutePath() : this.basedir;
            if (this.generator.getTarget() == null) {
                this.generator.setTarget(new Target());
            }
            if (this.generator.getTarget().getDirectory() == null) {
                this.generator.getTarget().setDirectory("target/generated-sources/jooq");
            }
            Configuration configuration = new Configuration();
            configuration.setLogging(this.logging);
            configuration.setOnError(this.onError);
            configuration.setOnUnused(this.onUnused);
            configuration.setJdbc(this.jdbc);
            configuration.setGenerator(this.generator);
            configuration.setBasedir(actualBasedir);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("Using this configuration:\n" + String.valueOf(configuration)));
            }
            GenerationTool.generate((Configuration)configuration);
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Error running jOOQ code generation tool", ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCL);
            try {
                pluginClassLoader.close();
            }
            catch (Throwable e) {
                this.getLog().error((CharSequence)"Couldn't close the classloader.", e);
            }
        }
        this.project.addCompileSourceRoot(this.generator.getTarget().getDirectory());
    }

    private void read(String file) {
        this.getLog().info((CharSequence)("Reading external configuration: " + file));
        File f = new File(file);
        if (!f.isAbsolute()) {
            f = new File(this.project.getBasedir(), file);
        }
        try (FileInputStream in = new FileInputStream(f);){
            Configuration configuration = GenerationTool.load((InputStream)in);
            this.logging = (Logging)MiniJAXB.append((Object)this.logging, (Object)configuration.getLogging());
            this.onError = (OnError)MiniJAXB.append((Object)this.onError, (Object)configuration.getOnError());
            this.onUnused = (OnError)MiniJAXB.append((Object)this.onUnused, (Object)configuration.getOnUnused());
            this.jdbc = (Jdbc)MiniJAXB.append((Object)this.jdbc, (Object)configuration.getJdbc());
            this.generator = (Generator)MiniJAXB.append((Object)this.generator, (Object)configuration.getGenerator());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private URLClassLoader getClassLoader() throws MojoExecutionException {
        try {
            List classpathElements = this.project.getRuntimeClasspathElements();
            URL[] urls = new URL[classpathElements.size()];
            for (int i = 0; i < urls.length; ++i) {
                urls[i] = new File((String)classpathElements.get(i)).toURI().toURL();
            }
            return new URLClassLoader(urls, ((Object)((Object)this)).getClass().getClassLoader());
        }
        catch (Exception e) {
            throw new MojoExecutionException("Couldn't create a classloader.", e);
        }
    }
}

