/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.util.Consumer;
import com.intellij.util.EmptyConsumer;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CompoundRuntimeException
extends RuntimeException {
    private final List<? extends Throwable> myExceptions;

    public CompoundRuntimeException(@NotNull List<? extends Throwable> throwables) {
        if (throwables == null) {
            CompoundRuntimeException.$$$reportNull$$$0(0);
        }
        this.myExceptions = throwables;
    }

    @Override
    public synchronized Throwable getCause() {
        return ContainerUtil.getFirstItem(this.myExceptions);
    }

    @Override
    public String getMessage() {
        return this.processAll(Throwable::getMessage, EmptyConsumer.getInstance());
    }

    @Override
    public String getLocalizedMessage() {
        return this.processAll(Throwable::getLocalizedMessage, EmptyConsumer.getInstance());
    }

    @Override
    public String toString() {
        return this.processAll(Throwable::toString, EmptyConsumer.getInstance());
    }

    @Override
    public void printStackTrace(PrintStream s) {
        this.processAll(throwable -> {
            throwable.printStackTrace(s);
            return "";
        }, s::print);
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        this.processAll(throwable -> {
            throwable.printStackTrace(s);
            return "";
        }, s::print);
    }

    private String processAll(@NotNull Function<? super Throwable, String> exceptionProcessor, @NotNull Consumer<? super String> stringProcessor) {
        if (exceptionProcessor == null) {
            CompoundRuntimeException.$$$reportNull$$$0(1);
        }
        if (stringProcessor == null) {
            CompoundRuntimeException.$$$reportNull$$$0(2);
        }
        if (this.myExceptions.size() == 1) {
            Throwable throwable = this.myExceptions.get(0);
            String s = exceptionProcessor.fun(throwable);
            stringProcessor.consume(s);
            return s;
        }
        StringBuilder sb = new StringBuilder();
        String line = "CompositeException (" + this.myExceptions.size() + " nested):\n------------------------------\n";
        stringProcessor.consume(line);
        sb.append(line);
        for (int i = 0; i < this.myExceptions.size(); ++i) {
            Throwable exception = this.myExceptions.get(i);
            line = "[" + i + "]: ";
            stringProcessor.consume(line);
            sb.append(line);
            line = exceptionProcessor.fun(exception);
            if (line == null) {
                line = "null\n";
            } else if (!line.endsWith("\n")) {
                line = line + '\n';
            }
            stringProcessor.consume(line);
            sb.append(line);
        }
        line = "------------------------------\n";
        stringProcessor.consume(line);
        sb.append(line);
        return sb.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "throwables";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringProcessor";
                break;
            }
        }
        objectArray2[1] = "com/intellij/util/lang/CompoundRuntimeException";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processAll";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

