/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.builder;

import com.google.common.collect.ImmutableBiMap;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.Visibility;
import org.jetbrains.kotlin.fir.FirAbstractElement;
import org.jetbrains.kotlin.fir.FirFunctionTarget;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirTargetElement;
import org.jetbrains.kotlin.fir.FirWhenSubject;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.impl.FirModifiableAccessorsOwner;
import org.jetbrains.kotlin.fir.declarations.impl.FirPropertyAccessorImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirValueParameterImpl;
import org.jetbrains.kotlin.fir.declarations.impl.FirVariableImpl;
import org.jetbrains.kotlin.fir.expressions.FirBinaryLogicExpression;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVariable;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirAbstractAnnotatedElement;
import org.jetbrains.kotlin.fir.expressions.impl.FirBinaryLogicExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirBlockImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirCallWithArgumentList;
import org.jetbrains.kotlin.fir.expressions.impl.FirCallableReferenceAccessImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirComponentCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirConstExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirElseIfTrueCondition;
import org.jetbrains.kotlin.fir.expressions.impl.FirErrorExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirExpressionStub;
import org.jetbrains.kotlin.fir.expressions.impl.FirFunctionCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirOperatorCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirQualifiedAccessExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirReturnExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirSingleExpressionBlock;
import org.jetbrains.kotlin.fir.expressions.impl.FirTypeOperatorCallImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirUnknownTypeExpression;
import org.jetbrains.kotlin.fir.expressions.impl.FirWhenBranchImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirWhenExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirWhenSubjectExpressionImpl;
import org.jetbrains.kotlin.fir.expressions.impl.FirWrappedDelegateExpressionImpl;
import org.jetbrains.kotlin.fir.references.FirDelegateFieldReferenceImpl;
import org.jetbrains.kotlin.fir.references.FirExplicitThisReference;
import org.jetbrains.kotlin.fir.references.FirResolvedCallableReferenceImpl;
import org.jetbrains.kotlin.fir.references.FirSimpleNamedReference;
import org.jetbrains.kotlin.fir.symbols.AbstractFirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirDelegateFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertyAccessorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitKPropertyTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitTypeRefImpl;
import org.jetbrains.kotlin.ir.expressions.IrConstKind;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDestructuringDeclarationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtWhenCondition;
import org.jetbrains.kotlin.psi.KtWhenConditionInRange;
import org.jetbrains.kotlin.psi.KtWhenConditionIsPattern;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.types.expressions.OperatorConventions;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000\u00ba\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u0015\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\u0018\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u0001\u001af\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u001d\u0010\u0019\u001a\u0019\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u001d0\u001a\u00a2\u0006\u0002\b\u001e2\u0019\u0010\u001f\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0004\u0012\u00020\"0 \u00a2\u0006\u0002\b\u001eH\u0000\u001a\u001c\u0010#\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\u0016\u001a,\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010&\u001a\u00020\b2\u0006\u0010'\u001a\u00020\u0010\u001a,\u0010%\u001a\u0006\u0012\u0002\b\u00030\u00162\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00012\u0006\u0010'\u001a\u00020\u0010\u001a\u0017\u0010(\u001a\u0004\u0018\u00010\u00062\u0006\u0010)\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\u0010*\u001a\"\u0010+\u001a\u00020\u001d*\u00020,2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u00182\u0006\u0010.\u001a\u00020\u0018\u001a.\u0010/\u001a\u000200*\u00020\u00102\u0006\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020\u00182\b\u00103\u001a\u0004\u0018\u0001042\b\u00105\u001a\u0004\u0018\u000106\u001a$\u00107\u001a\u000208*\u00020\u00102\u0006\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\u00182\b\u0010;\u001a\u0004\u0018\u00010<\u001a,\u0010=\u001a\u00020>*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u00109\u001a\u00020\u00102\u0006\u0010?\u001a\u00020\b2\b\u0010;\u001a\u0004\u0018\u00010<\u001a\u0011\u0010@\u001a\u0004\u0018\u00010\u0006*\u00020\b\u00a2\u0006\u0002\u0010\t\u001a\f\u0010A\u001a\u0004\u0018\u00010\u0001*\u00020B\u001a\n\u0010C\u001a\u00020D*\u00020B\u001ac\u0010E\u001a\u00020\u0010*\b\u0012\u0004\u0012\u00020G0F2\u0006\u0010;\u001a\u00020<2\u0006\u0010H\u001a\u00020I2\u001f\u0010J\u001a\u001b\u0012\u0006\u0012\u0004\u0018\u000104\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u001a\u00a2\u0006\u0002\b\u001e2\u0019\u0010K\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0004\u0012\u00020\"0 \u00a2\u0006\u0002\b\u001eH\u0000\u00a2\u0006\u0002\u0010L\u001aP\u0010E\u001a\u00020\u0010*\u00020G2\u0006\u0010H\u001a\u00020I2\u001f\u0010J\u001a\u001b\u0012\u0006\u0012\u0004\u0018\u000104\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00100\u001a\u00a2\u0006\u0002\b\u001e2\u0019\u0010K\u001a\u0015\u0012\u0006\u0012\u0004\u0018\u00010!\u0012\u0004\u0012\u00020\"0 \u00a2\u0006\u0002\b\u001eH\u0000\u001a\f\u0010M\u001a\u0004\u0018\u00010\u0001*\u00020B\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006N"}, d2={"DELEGATED_SETTER_PARAM", "Lorg/jetbrains/kotlin/name/Name;", "GET_VALUE", "PROVIDE_DELEGATE", "SET_VALUE", "escapedStringToCharacter", "", "text", "", "(Ljava/lang/String;)Ljava/lang/Character;", "generateAccessExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "psi", "Lcom/intellij/psi/PsiElement;", "name", "generateDestructuringBlock", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "multiDeclaration", "Lorg/jetbrains/kotlin/psi/KtDestructuringDeclaration;", "container", "Lorg/jetbrains/kotlin/fir/expressions/FirVariable;", "tmpVariable", "", "extractAnnotationsTo", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/psi/KtAnnotated;", "Lorg/jetbrains/kotlin/fir/expressions/impl/FirAbstractAnnotatedElement;", "", "Lkotlin/ExtensionFunctionType;", "toFirOrImplicitTypeRef", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "generateResolvedAccessExpression", "variable", "generateTemporaryVariable", "specialName", "initializer", "translateEscape", "c", "(C)Ljava/lang/Character;", "generateAccessorsByDelegate", "Lorg/jetbrains/kotlin/fir/declarations/impl/FirModifiableAccessorsOwner;", "member", "stubMode", "generateContainsOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "argument", "inverted", "base", "Lorg/jetbrains/kotlin/psi/KtExpression;", "operationReference", "Lorg/jetbrains/kotlin/psi/KtOperationReferenceExpression;", "generateLazyLogicalOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirBinaryLogicExpression;", "other", "isAnd", "basePsi", "Lorg/jetbrains/kotlin/psi/KtElement;", "generateNotNullOrOther", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "caseId", "parseCharacter", "toBinaryName", "Lcom/intellij/psi/tree/IElementType;", "toFirOperation", "Lorg/jetbrains/kotlin/fir/expressions/FirOperation;", "toFirWhenCondition", "", "Lorg/jetbrains/kotlin/psi/KtWhenCondition;", "subject", "Lorg/jetbrains/kotlin/fir/FirWhenSubject;", "convert", "toFirOrErrorTypeRef", "([Lorg/jetbrains/kotlin/psi/KtWhenCondition;Lorg/jetbrains/kotlin/psi/KtElement;Lorg/jetbrains/kotlin/fir/FirWhenSubject;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "toUnaryName", "psi2fir"})
public final class ConversionUtilsKt {
    private static final Name GET_VALUE;
    private static final Name SET_VALUE;
    private static final Name PROVIDE_DELEGATE;
    private static final Name DELEGATED_SETTER_PARAM;

    @Nullable
    public static final Character parseCharacter(@NotNull String $this$parseCharacter) {
        Intrinsics.checkParameterIsNotNull((Object)$this$parseCharacter, (String)"$this$parseCharacter");
        if ($this$parseCharacter.length() < 2 || $this$parseCharacter.charAt(0) != '\'' || $this$parseCharacter.charAt($this$parseCharacter.length() - 1) != '\'') {
            return null;
        }
        CharSequence charSequence = $this$parseCharacter;
        int n = 1;
        int n2 = $this$parseCharacter.length() - 1;
        boolean bl = false;
        String string2 = ((String)charSequence).substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        String text2 = string2;
        charSequence = text2;
        n = 0;
        if (charSequence.length() == 0) {
            return null;
        }
        return text2.charAt(0) != '\\' ? (text2.length() == 1 ? Character.valueOf(text2.charAt(0)) : null) : ConversionUtilsKt.escapedStringToCharacter(text2);
    }

    @Nullable
    public static final Character escapedStringToCharacter(@NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        CharSequence charSequence = text2;
        boolean bl = false;
        boolean bl2 = charSequence.length() > 0 && text2.charAt(0) == '\\';
        bl = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean bl3 = false;
            String string2 = "Only escaped sequences must be passed to this routine: " + text2;
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        String string3 = text2;
        int n = 1;
        int n2 = 0;
        String string4 = string3.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        String escape = string4;
        switch (escape.length()) {
            case 0: {
                return null;
            }
            case 1: {
                Character c = ConversionUtilsKt.translateEscape(escape.charAt(0));
                if (c == null) {
                    return null;
                }
                return Character.valueOf(c.charValue());
            }
            case 5: {
                if (escape.charAt(0) != 'u') break;
                try {
                    String string5 = escape;
                    n2 = 1;
                    boolean bl4 = false;
                    String string6 = string5;
                    if (string6 == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string7 = string6.substring(n2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                    Integer intValue = Integer.valueOf(string7, 16);
                    return Character.valueOf((char)intValue.intValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Nullable
    public static final Character translateEscape(char c) {
        Character c2;
        switch (c) {
            case 't': {
                c2 = Character.valueOf('\t');
                break;
            }
            case 'b': {
                c2 = Character.valueOf('\b');
                break;
            }
            case 'n': {
                c2 = Character.valueOf('\n');
                break;
            }
            case 'r': {
                c2 = Character.valueOf('\r');
                break;
            }
            case '\'': {
                c2 = Character.valueOf('\'');
                break;
            }
            case '\"': {
                c2 = Character.valueOf('\"');
                break;
            }
            case '\\': {
                c2 = Character.valueOf('\\');
                break;
            }
            case '$': {
                c2 = Character.valueOf('$');
                break;
            }
            default: {
                c2 = null;
            }
        }
        return c2;
    }

    @Nullable
    public static final Name toBinaryName(@NotNull IElementType $this$toBinaryName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toBinaryName, (String)"$this$toBinaryName");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.BINARY_OPERATION_NAMES;
        Intrinsics.checkExpressionValueIsNotNull(immutableBiMap, (String)"OperatorConventions.BINARY_OPERATION_NAMES");
        Map map2 = immutableBiMap;
        boolean bl = false;
        return (Name)map2.get($this$toBinaryName);
    }

    @Nullable
    public static final Name toUnaryName(@NotNull IElementType $this$toUnaryName) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toUnaryName, (String)"$this$toUnaryName");
        ImmutableBiMap<KtSingleValueToken, Name> immutableBiMap = OperatorConventions.UNARY_OPERATION_NAMES;
        Intrinsics.checkExpressionValueIsNotNull(immutableBiMap, (String)"OperatorConventions.UNARY_OPERATION_NAMES");
        Map map2 = immutableBiMap;
        boolean bl = false;
        return (Name)map2.get($this$toUnaryName);
    }

    @NotNull
    public static final FirOperation toFirOperation(@NotNull IElementType $this$toFirOperation) {
        FirOperation firOperation;
        Intrinsics.checkParameterIsNotNull((Object)$this$toFirOperation, (String)"$this$toFirOperation");
        IElementType iElementType = $this$toFirOperation;
        if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT)) {
            firOperation = FirOperation.LT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT)) {
            firOperation = FirOperation.GT;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ)) {
            firOperation = FirOperation.LT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ)) {
            firOperation = FirOperation.GT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ)) {
            firOperation = FirOperation.EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ)) {
            firOperation = FirOperation.NOT_EQ;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ)) {
            firOperation = FirOperation.IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ)) {
            firOperation = FirOperation.NOT_IDENTITY;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQ)) {
            firOperation = FirOperation.ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ)) {
            firOperation = FirOperation.PLUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ)) {
            firOperation = FirOperation.MINUS_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ)) {
            firOperation = FirOperation.TIMES_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ)) {
            firOperation = FirOperation.DIV_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ)) {
            firOperation = FirOperation.REM_ASSIGN;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.AS_KEYWORD)) {
            firOperation = FirOperation.AS;
        } else if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.AS_SAFE)) {
            firOperation = FirOperation.SAFE_AS;
        } else {
            throw (Throwable)((Object)new AssertionError((Object)$this$toFirOperation.toString()));
        }
        return firOperation;
    }

    @NotNull
    public static final FirWhenExpression generateNotNullOrOther(@NotNull FirExpression $this$generateNotNullOrOther, @NotNull FirSession session, @NotNull FirExpression other, @NotNull String caseId, @Nullable KtElement basePsi) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateNotNullOrOther, (String)"$this$generateNotNullOrOther");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Intrinsics.checkParameterIsNotNull((Object)caseId, (String)"caseId");
        Name name = Name.special('<' + caseId + '>');
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.special(\"<$caseId>\")");
        Name subjectName = name;
        FirVariable<?> subjectVariable = ConversionUtilsKt.generateTemporaryVariable(session, (PsiElement)basePsi, subjectName, $this$generateNotNullOrOther);
        FirWhenSubject subject = new FirWhenSubject();
        FirWhenSubjectExpressionImpl subjectExpression = new FirWhenSubjectExpressionImpl(basePsi, subject);
        FirWhenExpressionImpl firWhenExpressionImpl = new FirWhenExpressionImpl(basePsi, $this$generateNotNullOrOther, subjectVariable, null, 8, null);
        boolean bl = false;
        boolean bl2 = false;
        FirWhenExpressionImpl $this$apply = firWhenExpressionImpl;
        boolean bl3 = false;
        subject.bind($this$apply);
        Collection collection = $this$apply.getBranches();
        FirAbstractElement firAbstractElement = new FirOperatorCallImpl(basePsi, FirOperation.EQ);
        PsiElement psiElement = basePsi;
        boolean bl4 = false;
        boolean bl5 = false;
        FirOperatorCallImpl $this$apply2 = firAbstractElement;
        boolean bl6 = false;
        Collection collection2 = $this$apply2.getArguments();
        FirUnknownTypeExpression firUnknownTypeExpression = subjectExpression;
        boolean bl7 = false;
        collection2.add(firUnknownTypeExpression);
        collection2 = $this$apply2.getArguments();
        firUnknownTypeExpression = new FirConstExpressionImpl<Object>(basePsi, IrConstKind.Null.INSTANCE, null);
        bl7 = false;
        collection2.add(firUnknownTypeExpression);
        FirOperatorCallImpl firOperatorCallImpl = firAbstractElement;
        FirBlock firBlock = new FirSingleExpressionBlock(other);
        FirExpression firExpression2 = firOperatorCallImpl;
        PsiElement psiElement2 = psiElement;
        firAbstractElement = new FirWhenBranchImpl(psiElement2, firExpression2, firBlock);
        bl4 = false;
        collection.add(firAbstractElement);
        collection = $this$apply.getBranches();
        firAbstractElement = new FirWhenBranchImpl(other.getPsi(), new FirElseIfTrueCondition(basePsi), new FirSingleExpressionBlock(ConversionUtilsKt.generateResolvedAccessExpression(basePsi, subjectVariable)));
        bl4 = false;
        collection.add(firAbstractElement);
        return firWhenExpressionImpl;
    }

    @NotNull
    public static final FirBinaryLogicExpression generateLazyLogicalOperation(@NotNull FirExpression $this$generateLazyLogicalOperation, @NotNull FirExpression other, boolean isAnd, @Nullable KtElement basePsi) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateLazyLogicalOperation, (String)"$this$generateLazyLogicalOperation");
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        FirBinaryLogicExpression.OperationKind kind = isAnd ? FirBinaryLogicExpression.OperationKind.AND : FirBinaryLogicExpression.OperationKind.OR;
        return new FirBinaryLogicExpressionImpl(basePsi, $this$generateLazyLogicalOperation, other, kind);
    }

    @NotNull
    public static final FirExpression toFirWhenCondition(@NotNull KtWhenCondition $this$toFirWhenCondition, @NotNull FirWhenSubject subject, @NotNull Function2<? super KtExpression, ? super String, ? extends FirExpression> convert, @NotNull Function1<? super KtTypeReference, ? extends FirTypeRef> toFirOrErrorTypeRef) {
        FirExpression firExpression2;
        Intrinsics.checkParameterIsNotNull((Object)$this$toFirWhenCondition, (String)"$this$toFirWhenCondition");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
        Intrinsics.checkParameterIsNotNull(toFirOrErrorTypeRef, (String)"toFirOrErrorTypeRef");
        FirWhenSubjectExpressionImpl firSubjectExpression = new FirWhenSubjectExpressionImpl($this$toFirWhenCondition, subject);
        KtWhenCondition ktWhenCondition = $this$toFirWhenCondition;
        if (ktWhenCondition instanceof KtWhenConditionWithExpression) {
            FirOperatorCallImpl firOperatorCallImpl = new FirOperatorCallImpl(((KtWhenConditionWithExpression)$this$toFirWhenCondition).getExpression(), FirOperation.EQ);
            boolean bl = false;
            boolean bl2 = false;
            FirOperatorCallImpl $this$apply = firOperatorCallImpl;
            boolean bl3 = false;
            Collection collection = $this$apply.getArguments();
            Object object = firSubjectExpression;
            boolean bl4 = false;
            collection.add(object);
            collection = $this$apply.getArguments();
            object = convert.invoke((Object)((KtWhenConditionWithExpression)$this$toFirWhenCondition).getExpression(), (Object)"No expression in condition with expression");
            bl4 = false;
            collection.add(object);
            firExpression2 = firOperatorCallImpl;
        } else if (ktWhenCondition instanceof KtWhenConditionInRange) {
            FirExpression firRange = (FirExpression)convert.invoke((Object)((KtWhenConditionInRange)$this$toFirWhenCondition).getRangeExpression(), (Object)"No range in condition with range");
            firExpression2 = ConversionUtilsKt.generateContainsOperation(firRange, firSubjectExpression, ((KtWhenConditionInRange)$this$toFirWhenCondition).isNegated(), ((KtWhenConditionInRange)$this$toFirWhenCondition).getRangeExpression(), ((KtWhenConditionInRange)$this$toFirWhenCondition).getOperationReference());
        } else if (ktWhenCondition instanceof KtWhenConditionIsPattern) {
            FirTypeOperatorCallImpl firTypeOperatorCallImpl = new FirTypeOperatorCallImpl(((KtWhenConditionIsPattern)$this$toFirWhenCondition).getTypeReference(), ((KtWhenConditionIsPattern)$this$toFirWhenCondition).isNegated() ? FirOperation.NOT_IS : FirOperation.IS, (FirTypeRef)toFirOrErrorTypeRef.invoke((Object)((KtWhenConditionIsPattern)$this$toFirWhenCondition).getTypeReference()));
            boolean bl = false;
            boolean bl5 = false;
            FirTypeOperatorCallImpl $this$apply = firTypeOperatorCallImpl;
            boolean bl6 = false;
            Collection collection = $this$apply.getArguments();
            FirWhenSubjectExpressionImpl firWhenSubjectExpressionImpl = firSubjectExpression;
            boolean bl7 = false;
            collection.add(firWhenSubjectExpressionImpl);
            firExpression2 = firTypeOperatorCallImpl;
        } else {
            firExpression2 = new FirErrorExpressionImpl($this$toFirWhenCondition, "Unsupported when condition: " + $this$toFirWhenCondition.getClass());
        }
        return firExpression2;
    }

    @NotNull
    public static final FirExpression toFirWhenCondition(@NotNull KtWhenCondition[] $this$toFirWhenCondition, @NotNull KtElement basePsi, @NotNull FirWhenSubject subject, @NotNull Function2<? super KtExpression, ? super String, ? extends FirExpression> convert, @NotNull Function1<? super KtTypeReference, ? extends FirTypeRef> toFirOrErrorTypeRef) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toFirWhenCondition, (String)"$this$toFirWhenCondition");
        Intrinsics.checkParameterIsNotNull((Object)basePsi, (String)"basePsi");
        Intrinsics.checkParameterIsNotNull((Object)subject, (String)"subject");
        Intrinsics.checkParameterIsNotNull(convert, (String)"convert");
        Intrinsics.checkParameterIsNotNull(toFirOrErrorTypeRef, (String)"toFirOrErrorTypeRef");
        FirExpression firCondition = null;
        for (KtWhenCondition condition : $this$toFirWhenCondition) {
            FirExpression firConditionElement = ConversionUtilsKt.toFirWhenCondition(condition, subject, convert, toFirOrErrorTypeRef);
            FirExpression firExpression2 = firCondition;
            firCondition = firExpression2 == null ? firConditionElement : (FirExpression)ConversionUtilsKt.generateLazyLogicalOperation(firCondition, firConditionElement, false, basePsi);
        }
        FirExpression firExpression3 = firCondition;
        if (firExpression3 == null) {
            Intrinsics.throwNpe();
        }
        return firExpression3;
    }

    @NotNull
    public static final FirFunctionCall generateContainsOperation(@NotNull FirExpression $this$generateContainsOperation, @NotNull FirExpression argument, boolean inverted, @Nullable KtExpression base, @Nullable KtOperationReferenceExpression operationReference) {
        Intrinsics.checkParameterIsNotNull((Object)$this$generateContainsOperation, (String)"$this$generateContainsOperation");
        Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
        FirFunctionCallImpl firFunctionCallImpl = new FirFunctionCallImpl(base, false, 2, null);
        boolean bl = false;
        boolean bl2 = false;
        FirFunctionCallImpl $this$apply = firFunctionCallImpl;
        boolean bl3 = false;
        $this$apply.setCalleeReference(new FirSimpleNamedReference(operationReference, OperatorNameConventions.CONTAINS));
        $this$apply.setExplicitReceiver($this$generateContainsOperation);
        Collection collection = $this$apply.getArguments();
        FirExpression firExpression2 = argument;
        boolean bl4 = false;
        collection.add(firExpression2);
        FirFunctionCallImpl containsCall = firFunctionCallImpl;
        if (!inverted) {
            return containsCall;
        }
        firFunctionCallImpl = new FirFunctionCallImpl(base, false, 2, null);
        bl = false;
        bl2 = false;
        $this$apply = firFunctionCallImpl;
        boolean bl5 = false;
        $this$apply.setCalleeReference(new FirSimpleNamedReference(operationReference, OperatorNameConventions.NOT));
        $this$apply.setExplicitReceiver(containsCall);
        return firFunctionCallImpl;
    }

    @NotNull
    public static final FirQualifiedAccessExpression generateAccessExpression(@Nullable PsiElement psi, @NotNull Name name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        FirQualifiedAccessExpressionImpl firQualifiedAccessExpressionImpl = new FirQualifiedAccessExpressionImpl(psi, false, 2, null);
        boolean bl = false;
        boolean bl2 = false;
        FirQualifiedAccessExpressionImpl $this$apply = firQualifiedAccessExpressionImpl;
        boolean bl3 = false;
        $this$apply.setCalleeReference(new FirSimpleNamedReference(psi, name));
        return firQualifiedAccessExpressionImpl;
    }

    @NotNull
    public static final FirQualifiedAccessExpression generateResolvedAccessExpression(@Nullable PsiElement psi, @NotNull FirVariable<?> variable2) {
        Intrinsics.checkParameterIsNotNull(variable2, (String)"variable");
        FirQualifiedAccessExpressionImpl firQualifiedAccessExpressionImpl = new FirQualifiedAccessExpressionImpl(psi, false, 2, null);
        boolean bl = false;
        boolean bl2 = false;
        FirQualifiedAccessExpressionImpl $this$apply = firQualifiedAccessExpressionImpl;
        boolean bl3 = false;
        $this$apply.setCalleeReference(new FirResolvedCallableReferenceImpl(psi, variable2.getName(), (AbstractFirBasedSymbol)variable2.getSymbol()));
        return firQualifiedAccessExpressionImpl;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final FirExpression generateDestructuringBlock(@NotNull FirSession session, @NotNull KtDestructuringDeclaration multiDeclaration, @NotNull FirVariable<?> container, boolean tmpVariable, @NotNull Function2<? super KtAnnotated, ? super FirAbstractAnnotatedElement, Unit> extractAnnotationsTo, @NotNull Function1<? super KtTypeReference, ? extends FirTypeRef> toFirOrImplicitTypeRef) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)multiDeclaration, (String)"multiDeclaration");
        Intrinsics.checkParameterIsNotNull(container, (String)"container");
        Intrinsics.checkParameterIsNotNull(extractAnnotationsTo, (String)"extractAnnotationsTo");
        Intrinsics.checkParameterIsNotNull(toFirOrImplicitTypeRef, (String)"toFirOrImplicitTypeRef");
        FirBlockImpl firBlockImpl = new FirBlockImpl(multiDeclaration);
        boolean bl = false;
        boolean bl2 = false;
        FirBlockImpl $this$apply = firBlockImpl;
        boolean bl3 = false;
        if (tmpVariable) {
            Collection collection = $this$apply.getStatements();
            FirVariable<?> firVariable = container;
            boolean bl4 = false;
            collection.add(firVariable);
        }
        boolean isVar = multiDeclaration.isVar();
        boolean bl5 = false;
        List<KtDestructuringDeclarationEntry> list2 = multiDeclaration.getEntries();
        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"multiDeclaration.entries");
        for (KtDestructuringDeclarationEntry entry : (Iterable)list2) {
            void index2;
            Collection collection = $this$apply.getStatements();
            PsiElement psiElement = entry;
            KtDestructuringDeclarationEntry ktDestructuringDeclarationEntry = entry;
            Intrinsics.checkExpressionValueIsNotNull((Object)ktDestructuringDeclarationEntry, (String)"entry");
            Name name = ktDestructuringDeclarationEntry.getNameAsSafeName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"entry.nameAsSafeName");
            FirTypeRef firTypeRef = (FirTypeRef)toFirOrImplicitTypeRef.invoke((Object)entry.getTypeReference());
            FirExpression firExpression2 = new FirComponentCallImpl(entry, (int)(index2 + true), ConversionUtilsKt.generateResolvedAccessExpression(entry, container));
            Name name2 = entry.getNameAsSafeName();
            Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"entry.nameAsSafeName");
            FirVariableImpl firVariableImpl = new FirVariableImpl(session, psiElement, name, firTypeRef, isVar, firExpression2, new FirVariableSymbol(name2), null, 128, null);
            boolean bl6 = false;
            boolean bl7 = false;
            FirVariableImpl $this$apply2 = firVariableImpl;
            boolean bl8 = false;
            extractAnnotationsTo.invoke((Object)entry, (Object)$this$apply2);
            $this$apply2.getSymbol().bind((FirDeclaration)$this$apply2);
            bl6 = false;
            collection.add(firVariableImpl);
            ++index2;
        }
        return firBlockImpl;
    }

    @NotNull
    public static final FirVariable<?> generateTemporaryVariable(@NotNull FirSession session, @Nullable PsiElement psi, @NotNull Name name, @NotNull FirExpression initializer2) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)initializer2, (String)"initializer");
        FirVariableImpl firVariableImpl = new FirVariableImpl(session, psi, name, new FirImplicitTypeRefImpl(psi), false, initializer2, new FirVariableSymbol(name), null, 128, null);
        boolean bl = false;
        boolean bl2 = false;
        FirVariableImpl $this$apply = firVariableImpl;
        boolean bl3 = false;
        $this$apply.getSymbol().bind((FirDeclaration)$this$apply);
        return firVariableImpl;
    }

    @NotNull
    public static final FirVariable<?> generateTemporaryVariable(@NotNull FirSession session, @Nullable PsiElement psi, @NotNull String specialName, @NotNull FirExpression initializer2) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)specialName, (String)"specialName");
        Intrinsics.checkParameterIsNotNull((Object)initializer2, (String)"initializer");
        Name name = Name.special('<' + specialName + '>');
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.special(\"<$specialName>\")");
        return ConversionUtilsKt.generateTemporaryVariable(session, psi, name, initializer2);
    }

    public static final void generateAccessorsByDelegate(@NotNull FirModifiableAccessorsOwner $this$generateAccessorsByDelegate, @NotNull FirSession session, boolean member, boolean stubMode) {
        FirPropertyAccessor firPropertyAccessor;
        FirPropertyAccessor firPropertyAccessor2;
        FirAbstractAnnotatedElement firAbstractAnnotatedElement;
        boolean bl;
        Object object;
        Object object2;
        FirFunctionCallImpl $this$apply;
        boolean bl2;
        boolean bl3;
        Object object3;
        FirAbstractAnnotatedElement firAbstractAnnotatedElement2;
        FirExpression firExpression2;
        Intrinsics.checkParameterIsNotNull((Object)$this$generateAccessorsByDelegate, (String)"$this$generateAccessorsByDelegate");
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        FirVariable variable2 = (FirVariable)((Object)$this$generateAccessorsByDelegate);
        FirDelegateFieldSymbol<?> firDelegateFieldSymbol = $this$generateAccessorsByDelegate.getDelegateFieldSymbol();
        if (firDelegateFieldSymbol == null) {
            return;
        }
        FirDelegateFieldSymbol<?> delegateFieldSymbol = firDelegateFieldSymbol;
        FirExpression firExpression3 = ((FirVariable)((Object)$this$generateAccessorsByDelegate)).getDelegate();
        if (!(firExpression3 instanceof FirWrappedDelegateExpressionImpl)) {
            firExpression3 = null;
        }
        FirWrappedDelegateExpressionImpl firWrappedDelegateExpressionImpl = (FirWrappedDelegateExpressionImpl)firExpression3;
        if (firWrappedDelegateExpressionImpl == null) {
            return;
        }
        FirWrappedDelegateExpressionImpl delegate = firWrappedDelegateExpressionImpl;
        Function0<FirQualifiedAccessExpressionImpl> $fun$delegateAccess$1 = new Function0<FirQualifiedAccessExpressionImpl>(delegateFieldSymbol){
            final /* synthetic */ FirDelegateFieldSymbol $delegateFieldSymbol;

            @NotNull
            public final FirQualifiedAccessExpressionImpl invoke() {
                FirQualifiedAccessExpressionImpl firQualifiedAccessExpressionImpl = new FirQualifiedAccessExpressionImpl(null, false, 2, null);
                boolean bl = false;
                boolean bl2 = false;
                FirQualifiedAccessExpressionImpl $this$apply = firQualifiedAccessExpressionImpl;
                boolean bl3 = false;
                $this$apply.setCalleeReference(new FirDelegateFieldReferenceImpl(null, this.$delegateFieldSymbol));
                return firQualifiedAccessExpressionImpl;
            }
            {
                this.$delegateFieldSymbol = firDelegateFieldSymbol;
                super(0);
            }
        };
        Function0<FirUnknownTypeExpression> $fun$thisRef$2 = new Function0<FirUnknownTypeExpression>(member){
            final /* synthetic */ boolean $member;

            @NotNull
            public final FirUnknownTypeExpression invoke() {
                FirUnknownTypeExpression firUnknownTypeExpression;
                if (this.$member) {
                    FirQualifiedAccessExpressionImpl firQualifiedAccessExpressionImpl = new FirQualifiedAccessExpressionImpl(null, false, 2, null);
                    boolean bl = false;
                    boolean bl2 = false;
                    FirQualifiedAccessExpressionImpl $this$apply = firQualifiedAccessExpressionImpl;
                    boolean bl3 = false;
                    $this$apply.setCalleeReference(new FirExplicitThisReference(null, null));
                    firUnknownTypeExpression = firQualifiedAccessExpressionImpl;
                } else {
                    firUnknownTypeExpression = new FirConstExpressionImpl<Object>(null, IrConstKind.Null.INSTANCE, null);
                }
                return firUnknownTypeExpression;
            }
            {
                this.$member = bl;
                super(0);
            }
        };
        Function0<FirCallableReferenceAccessImpl> $fun$propertyRef$3 = new Function0<FirCallableReferenceAccessImpl>(variable2){
            final /* synthetic */ FirVariable $variable;

            @NotNull
            public final FirCallableReferenceAccessImpl invoke() {
                FirCallableReferenceAccessImpl firCallableReferenceAccessImpl = new FirCallableReferenceAccessImpl(null);
                boolean bl = false;
                boolean bl2 = false;
                FirCallableReferenceAccessImpl $this$apply = firCallableReferenceAccessImpl;
                boolean bl3 = false;
                $this$apply.setCalleeReference(new FirResolvedCallableReferenceImpl(null, this.$variable.getName(), (AbstractFirBasedSymbol)this.$variable.getSymbol()));
                $this$apply.setTypeRef(new FirImplicitKPropertyTypeRef(null, ConeStarProjection.INSTANCE));
                return firCallableReferenceAccessImpl;
            }
            {
                this.$variable = firVariable;
                super(0);
            }
        };
        Object object4 = delegate;
        if (stubMode) {
            firExpression2 = new FirExpressionStub(null);
        } else {
            firAbstractAnnotatedElement2 = new FirFunctionCallImpl(null, false, 2, null);
            object3 = object4;
            bl3 = false;
            bl2 = false;
            $this$apply = firAbstractAnnotatedElement2;
            boolean bl4 = false;
            $this$apply.setExplicitReceiver(delegate.getExpression());
            $this$apply.setCalleeReference(new FirSimpleNamedReference(null, PROVIDE_DELEGATE));
            object2 = $this$apply.getArguments();
            object = $fun$thisRef$2.invoke();
            bl = false;
            object2.add(object);
            object2 = $this$apply.getArguments();
            object = $fun$propertyRef$3.invoke();
            bl = false;
            object2.add(object);
            firAbstractAnnotatedElement = firAbstractAnnotatedElement2;
            object4 = object3;
            firExpression2 = firAbstractAnnotatedElement;
        }
        ((FirWrappedDelegateExpressionImpl)object4).setDelegateProvider(firExpression2);
        if (stubMode) {
            return;
        }
        Object object5 = $this$generateAccessorsByDelegate;
        FirPropertyAccessor firPropertyAccessor3 = $this$generateAccessorsByDelegate.getGetter();
        if (!(firPropertyAccessor3 instanceof FirPropertyAccessorImpl)) {
            firPropertyAccessor3 = null;
        }
        FirPropertyAccessorImpl firPropertyAccessorImpl = (FirPropertyAccessorImpl)firPropertyAccessor3;
        if (firPropertyAccessorImpl != null) {
            firPropertyAccessor2 = firPropertyAccessorImpl;
        } else {
            Visibility visibility = Visibilities.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.UNKNOWN");
            firAbstractAnnotatedElement2 = new FirPropertyAccessorImpl(session, null, true, visibility, new FirImplicitTypeRefImpl(null), new FirPropertyAccessorSymbol());
            object3 = object5;
            bl3 = false;
            bl2 = false;
            FirAbstractAnnotatedElement $this$Accessor = firAbstractAnnotatedElement2;
            boolean bl5 = false;
            object2 = new FirFunctionCallImpl(null, false, 2, null);
            object = null;
            FirAbstractAnnotatedElement firAbstractAnnotatedElement3 = $this$Accessor;
            boolean bl6 = false;
            boolean bl7 = false;
            Object $this$apply2 = object2;
            boolean bl8 = false;
            ((FirFunctionCallImpl)$this$apply2).setExplicitReceiver((FirExpression)$fun$delegateAccess$1.invoke());
            ((FirFunctionCallImpl)$this$apply2).setCalleeReference(new FirSimpleNamedReference(null, GET_VALUE));
            Collection collection = ((FirCallWithArgumentList)$this$apply2).getArguments();
            Object object6 = $fun$thisRef$2.invoke();
            boolean bl9 = false;
            collection.add(object6);
            collection = ((FirCallWithArgumentList)$this$apply2).getArguments();
            object6 = $fun$propertyRef$3.invoke();
            bl9 = false;
            collection.add(object6);
            Object object7 = object2;
            FirExpression firExpression4 = (FirExpression)object7;
            Object object8 = object;
            object2 = new FirReturnExpressionImpl((PsiElement)object8, firExpression4);
            bl6 = false;
            bl7 = false;
            $this$apply2 = object2;
            boolean bl10 = false;
            ((FirReturnExpressionImpl)$this$apply2).setTarget(new FirFunctionTarget(null));
            ((FirReturnExpressionImpl)$this$apply2).getTarget().bind((FirFunction<?>)((FirTargetElement)((Object)$this$Accessor)));
            Object object9 = object2;
            FirStatement firStatement = (FirStatement)object9;
            ((FirPropertyAccessorImpl)firAbstractAnnotatedElement3).setBody(new FirSingleExpressionBlock(firStatement));
            firAbstractAnnotatedElement = firAbstractAnnotatedElement2;
            object5 = object3;
            firPropertyAccessor2 = (FirPropertyAccessor)((Object)firAbstractAnnotatedElement);
        }
        object5.setGetter(firPropertyAccessor2);
        Object object10 = $this$generateAccessorsByDelegate;
        FirPropertyAccessor firPropertyAccessor4 = $this$generateAccessorsByDelegate.getSetter();
        if (!(firPropertyAccessor4 instanceof FirPropertyAccessorImpl)) {
            firPropertyAccessor4 = null;
        }
        FirPropertyAccessorImpl firPropertyAccessorImpl2 = (FirPropertyAccessorImpl)firPropertyAccessor4;
        if (firPropertyAccessorImpl2 != null) {
            firPropertyAccessor = firPropertyAccessorImpl2;
        } else {
            Visibility visibility = Visibilities.UNKNOWN;
            Intrinsics.checkExpressionValueIsNotNull((Object)visibility, (String)"Visibilities.UNKNOWN");
            firAbstractAnnotatedElement2 = new FirPropertyAccessorImpl(session, null, false, visibility, session.getBuiltinTypes().getUnitType(), new FirPropertyAccessorSymbol());
            object3 = object10;
            bl3 = false;
            bl2 = false;
            $this$apply = firAbstractAnnotatedElement2;
            boolean bl11 = false;
            FirValueParameterImpl parameter = new FirValueParameterImpl(session, null, DELEGATED_SETTER_PARAM, new FirImplicitTypeRefImpl(null), null, false, false, false, null, 256, null);
            object = ((FirPropertyAccessorImpl)((Object)$this$apply)).getValueParameters();
            bl = false;
            object.add(parameter);
            object = new FirFunctionCallImpl(null, false, 2, null);
            FirFunctionCallImpl firFunctionCallImpl = $this$apply;
            bl = false;
            boolean bl12 = false;
            Object $this$apply3 = object;
            boolean bl13 = false;
            ((FirFunctionCallImpl)$this$apply3).setExplicitReceiver((FirExpression)$fun$delegateAccess$1.invoke());
            ((FirFunctionCallImpl)$this$apply3).setCalleeReference(new FirSimpleNamedReference(null, SET_VALUE));
            Collection collection = ((FirCallWithArgumentList)$this$apply3).getArguments();
            Object object11 = $fun$thisRef$2.invoke();
            boolean bl14 = false;
            collection.add(object11);
            collection = ((FirCallWithArgumentList)$this$apply3).getArguments();
            object11 = $fun$propertyRef$3.invoke();
            bl14 = false;
            collection.add(object11);
            collection = ((FirCallWithArgumentList)$this$apply3).getArguments();
            object11 = new FirQualifiedAccessExpressionImpl(null, false, 2, null);
            bl14 = false;
            boolean bl15 = false;
            Object $this$apply4 = object11;
            boolean bl16 = false;
            ((FirQualifiedAccessExpressionImpl)$this$apply4).setCalleeReference(new FirResolvedCallableReferenceImpl(((FirAbstractElement)$this$apply4).getPsi(), DELEGATED_SETTER_PARAM, parameter.getSymbol()));
            bl14 = false;
            collection.add(object11);
            Object object12 = object;
            FirStatement firStatement = (FirStatement)object12;
            ((FirPropertyAccessorImpl)((Object)firFunctionCallImpl)).setBody(new FirSingleExpressionBlock(firStatement));
            firAbstractAnnotatedElement = firAbstractAnnotatedElement2;
            object10 = object3;
            firPropertyAccessor = (FirPropertyAccessor)((Object)firAbstractAnnotatedElement);
        }
        object10.setSetter(firPropertyAccessor);
    }

    static {
        Name name = Name.identifier("getValue");
        Intrinsics.checkExpressionValueIsNotNull((Object)name, (String)"Name.identifier(\"getValue\")");
        GET_VALUE = name;
        Name name2 = Name.identifier("setValue");
        Intrinsics.checkExpressionValueIsNotNull((Object)name2, (String)"Name.identifier(\"setValue\")");
        SET_VALUE = name2;
        Name name3 = Name.identifier("provideDelegate");
        Intrinsics.checkExpressionValueIsNotNull((Object)name3, (String)"Name.identifier(\"provideDelegate\")");
        PROVIDE_DELEGATE = name3;
        Name name4 = Name.special("<set-?>");
        Intrinsics.checkExpressionValueIsNotNull((Object)name4, (String)"Name.special(\"<set-?>\")");
        DELEGATED_SETTER_PARAM = name4;
    }
}

