/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptorWithTypeParameters;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptorWithSource;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.calls.util.FakeCallableDescriptorForTypeAliasObject;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageChecker;
import org.jetbrains.kotlin.resolve.checkers.ClassifierUsageCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a*\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"checkClassifierUsages", "", "declarations", "", "Lcom/intellij/psi/PsiElement;", "checkers", "", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageChecker;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/ClassifierUsageCheckerContext;", "frontend"})
public final class ClassifierUsageCheckerKt {
    public static final void checkClassifierUsages(@NotNull Collection<? extends PsiElement> declarations2, @NotNull Iterable<? extends ClassifierUsageChecker> checkers, @NotNull ClassifierUsageCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(declarations2, (String)"declarations");
        Intrinsics.checkParameterIsNotNull(checkers, (String)"checkers");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        KtTreeVisitorVoid visitor2 = new KtTreeVisitorVoid(context, checkers){
            final /* synthetic */ ClassifierUsageCheckerContext $context;
            final /* synthetic */ Iterable $checkers;

            public void visitReferenceExpression(@NotNull KtReferenceExpression expression2) {
                Intrinsics.checkParameterIsNotNull((Object)expression2, (String)"expression");
                super.visitReferenceExpression(expression2);
                if (expression2 instanceof KtNameReferenceExpression && Intrinsics.areEqual((Object)((KtNameReferenceExpression)expression2).getReferencedNameElementType(), (Object)KtTokens.SUPER_KEYWORD)) {
                    return;
                }
                List<ClassifierDescriptor> targets = this.getReferencedClassifiers(expression2);
                for (ClassifierDescriptor target : targets) {
                    this.runCheckersWithTarget(target, expression2);
                }
            }

            public void visitFunctionType(@NotNull KtFunctionType type2) {
                ClassifierDescriptor descriptor2;
                Intrinsics.checkParameterIsNotNull((Object)type2, (String)"type");
                super.visitFunctionType(type2);
                BindingTrace bindingTrace = this.$context.getTrace();
                ReadOnlySlice readOnlySlice = BindingContext.TYPE;
                PsiElement psiElement = type2.getParent();
                if (!(psiElement instanceof KtTypeReference)) {
                    psiElement = null;
                }
                KtTypeReference ktTypeReference = (KtTypeReference)psiElement;
                if (ktTypeReference == null) {
                    return;
                }
                KotlinType kotlinType = (KotlinType)bindingTrace.get(readOnlySlice, ktTypeReference);
                if (kotlinType != null && (descriptor2 = kotlinType.getConstructor().getDeclarationDescriptor()) instanceof ClassifierDescriptor) {
                    this.runCheckersWithTarget(descriptor2, type2);
                }
            }

            private final void runCheckersWithTarget(ClassifierDescriptor target, KtElement expression2) {
                for (ClassifierUsageChecker checker : this.$checkers) {
                    checker.check(target, expression2, this.$context);
                }
            }

            /*
             * WARNING - void declaration
             */
            private final List<ClassifierDescriptor> getReferencedClassifiers(KtReferenceExpression expression2) {
                List list2;
                DeclarationDescriptor target = (DeclarationDescriptor)this.$context.getTrace().get(BindingContext.REFERENCE_TARGET, expression2);
                DeclarationDescriptor declarationDescriptor = target;
                if (declarationDescriptor instanceof ClassifierDescriptor) {
                    list2 = CollectionsKt.listOfNotNull((Object[])new ClassifierDescriptor[]{(ClassifierDescriptor)target, this.getClassifierUsedToReferenceCompanionObject((ClassifierDescriptor)target, expression2)});
                } else if (declarationDescriptor instanceof ClassConstructorDescriptor) {
                    list2 = CollectionsKt.listOf((Object)((ClassConstructorDescriptor)target).getConstructedClass());
                } else if (declarationDescriptor instanceof FakeCallableDescriptorForTypeAliasObject) {
                    TypeAliasDescriptor referencedTypeAlias;
                    ClassDescriptor referencedObject = ((FakeCallableDescriptorForTypeAliasObject)target).getReferencedObject();
                    list2 = Intrinsics.areEqual((Object)referencedObject, (Object)(referencedTypeAlias = ((FakeCallableDescriptorForTypeAliasObject)target).getTypeAliasDescriptor()).getClassDescriptor()) ^ true ? CollectionsKt.listOf((Object[])new ClassifierDescriptorWithTypeParameters[]{referencedObject, referencedTypeAlias}) : CollectionsKt.listOf((Object)referencedTypeAlias);
                } else {
                    void $receiver$iv$iv;
                    void $receiver$iv$iv2;
                    Iterable $receiver$iv;
                    Collection collection = (Collection)this.$context.getTrace().get(BindingContext.AMBIGUOUS_REFERENCE_TARGET, expression2);
                    if (collection == null) {
                        return CollectionsKt.emptyList();
                    }
                    Collection targets = collection;
                    Iterable iterable = $receiver$iv = (Iterable)targets;
                    Object destination$iv$iv = new LinkedHashMap<K, V>();
                    for (T element$iv$iv : $receiver$iv$iv2) {
                        Object object;
                        DeclarationDescriptor it = (DeclarationDescriptor)element$iv$iv;
                        DeclarationDescriptor declarationDescriptor2 = it;
                        if (!(declarationDescriptor2 instanceof DeclarationDescriptorWithSource)) {
                            declarationDescriptor2 = null;
                        }
                        DeclarationDescriptorWithSource declarationDescriptorWithSource = (DeclarationDescriptorWithSource)declarationDescriptor2;
                        Object $receiver$iv$iv$iv = destination$iv$iv;
                        SourceElement key$iv$iv = declarationDescriptorWithSource != null ? declarationDescriptorWithSource.getSource() : null;
                        V value$iv$iv$iv = $receiver$iv$iv$iv.get(key$iv$iv);
                        if (value$iv$iv$iv == null) {
                            ArrayList<E> answer$iv$iv$iv = new ArrayList<E>();
                            $receiver$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                            object = answer$iv$iv$iv;
                        } else {
                            object = value$iv$iv$iv;
                        }
                        List list$iv$iv = (List)object;
                        list$iv$iv.add(element$iv$iv);
                    }
                    if (destination$iv$iv.size() != 1) {
                        return CollectionsKt.emptyList();
                    }
                    Iterable $receiver$iv2 = targets;
                    destination$iv$iv = $receiver$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        if (!(element$iv$iv instanceof ClassifierDescriptor)) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List targetClassifiers = (List)destination$iv$iv2;
                    list2 = targetClassifiers.size() == 1 ? targetClassifiers : CollectionsKt.emptyList();
                }
                return list2;
            }

            private final ClassifierDescriptor getClassifierUsedToReferenceCompanionObject(ClassifierDescriptor referencedObject, KtReferenceExpression expression2) {
                return DescriptorUtilsKt.isCompanionObject(referencedObject) ? (ClassifierDescriptorWithTypeParameters)this.$context.getTrace().get(BindingContext.SHORT_REFERENCE_TO_COMPANION_OBJECT, expression2) : null;
            }
            {
                this.$context = $captured_local_variable$0;
                this.$checkers = $captured_local_variable$1;
            }
        };
        for (PsiElement psiElement : declarations2) {
            psiElement.accept(visitor2);
        }
    }
}

