/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl.bpmn2;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.drools.core.xml.ExtensibleXmlParser;
import org.jbpm.bpmn2.xml.UserTaskHandler;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescRepoHelper;
import org.jbpm.kie.services.impl.bpmn2.ProcessDescriptionRepository;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.node.HumanTaskNode;
import org.jbpm.workflow.core.node.WorkItemNode;
import org.kie.internal.task.api.TaskModelProvider;
import org.kie.internal.task.api.model.TaskDef;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.xml.sax.SAXException;

@ApplicationScoped
public class HumanTaskGetInformationHandler
extends UserTaskHandler {
    private ProcessDescRepoHelper repositoryHelper;
    @Inject
    private ProcessDescriptionRepository repository;

    protected void readIoSpecification(org.w3c.dom.Node xmlNode, Map<String, String> dataInputs, Map<String, String> dataOutputs) {
        dataInputs.clear();
        dataOutputs.clear();
        org.w3c.dom.Node subNode = xmlNode.getFirstChild();
        while (subNode instanceof Element) {
            String id;
            String subNodeName = subNode.getNodeName();
            if ("dataInput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String inputName = ((Element)subNode).getAttribute("name");
                dataInputs.put(id, inputName);
            }
            if ("dataOutput".equals(subNodeName)) {
                id = ((Element)subNode).getAttribute("id");
                String outputName = ((Element)subNode).getAttribute("name");
                dataOutputs.put(id, outputName);
            }
            subNode = subNode.getNextSibling();
        }
        NamedNodeMap map = xmlNode.getParentNode().getAttributes();
        org.w3c.dom.Node nodeName = map.getNamedItem("name");
        String name = nodeName.getNodeValue();
        TaskDef task = TaskModelProvider.getFactory().newTaskDef();
        task.setName(name);
        HashMap<String, String> inputParams = new HashMap<String, String>();
        String mainProcessId = this.repositoryHelper.getProcess().getId();
        for (Map.Entry<String, String> in : dataInputs.entrySet()) {
            inputParams.put(in.getKey(), in.getValue());
        }
        HashMap<String, String> outputParams = new HashMap<String, String>();
        for (Map.Entry<String, String> out : dataOutputs.entrySet()) {
            outputParams.put(out.getKey(), out.getValue());
        }
        this.repository.getProcessDesc(mainProcessId).getTasks().put(task.getName(), task);
        this.repository.getProcessDesc(mainProcessId).getTaskInputMappings().put(task.getName(), inputParams);
        this.repository.getProcessDesc(mainProcessId).getTaskOutputMappings().put(task.getName(), outputParams);
    }

    protected void handleNode(Node node, Element element, String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        super.handleNode(node, element, uri, localName, parser);
        WorkItemNode humanTaskNode = (WorkItemNode)node;
        Map parameters = humanTaskNode.getWork().getParameters();
        String mainProcessId = this.repositoryHelper.getProcess().getId();
        for (String parameter : parameters.keySet()) {
            if (!parameter.equals("GroupId")) continue;
            String currentAssignment = "";
            if (this.repository.getProcessDesc(mainProcessId).getTaskAssignments().get(humanTaskNode.getName()) != null) {
                currentAssignment = this.repository.getProcessDesc(mainProcessId).getTaskAssignments().get(humanTaskNode.getName());
            }
            if (!currentAssignment.equals("")) {
                this.repository.getProcessDesc(mainProcessId).getTaskAssignments().put(humanTaskNode.getName(), humanTaskNode.getWork().getParameter(parameter).toString() + "," + currentAssignment);
                continue;
            }
            this.repository.getProcessDesc(mainProcessId).getTaskAssignments().put(humanTaskNode.getName(), humanTaskNode.getWork().getParameter(parameter).toString());
        }
    }

    protected String readPotentialOwner(org.w3c.dom.Node xmlNode, HumanTaskNode humanTaskNode) {
        String user = xmlNode.getFirstChild().getFirstChild().getFirstChild().getTextContent();
        String mainProcessId = this.repositoryHelper.getProcess().getId();
        String currentAssignment = "";
        if (this.repository.getProcessDesc(mainProcessId).getTaskAssignments().get(humanTaskNode.getName()) != null) {
            currentAssignment = this.repository.getProcessDesc(mainProcessId).getTaskAssignments().get(humanTaskNode.getName());
        }
        if (!currentAssignment.equals("")) {
            this.repository.getProcessDesc(mainProcessId).getTaskAssignments().put(humanTaskNode.getName(), user + "," + currentAssignment);
        } else {
            this.repository.getProcessDesc(mainProcessId).getTaskAssignments().put(humanTaskNode.getName(), user);
        }
        return user;
    }

    public void setRepositoryHelper(ProcessDescRepoHelper repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public void setRepository(ProcessDescriptionRepository repository) {
        this.repository = repository;
    }
}

