/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.rpc;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServiceFactory {
    private static Logger log = Logger.getLogger(ServiceFactory.class.getName());
    private static ServiceFactory factory;
    public static final String SERVICEFACTORY_PROPERTY = "javax.xml.rpc.ServiceFactory";
    private static final String DEFAULT_SERVICE_FACTORY = "org.jboss.ws.core.jaxrpc.client.ServiceFactoryImpl";
    private static final String[] alternativeFactories;

    protected ServiceFactory() {
    }

    public static ServiceFactory newInstance() throws ServiceException {
        if (factory == null) {
            PropertyAccessAction action = new PropertyAccessAction(SERVICEFACTORY_PROPERTY, DEFAULT_SERVICE_FACTORY);
            String factoryName = (String)AccessController.doPrivileged(action);
            ClassLoader loader = ServiceFactory.getContextClassLoader();
            try {
                try {
                    Class<?> factoryClass = ServiceFactory.loadClass(loader, factoryName);
                    factory = (ServiceFactory)factoryClass.newInstance();
                }
                catch (ClassNotFoundException e) {
                    if (!factoryName.equals(DEFAULT_SERVICE_FACTORY)) {
                        throw e;
                    }
                    for (int i = 0; i < alternativeFactories.length; ++i) {
                        factoryName = alternativeFactories[i];
                        try {
                            Class<?> factoryClass = ServiceFactory.loadClass(loader, factoryName);
                            return (ServiceFactory)factoryClass.newInstance();
                        }
                        catch (ClassNotFoundException e1) {
                            log.severe("Cannot load factory: " + factoryName);
                            continue;
                        }
                    }
                }
            }
            catch (Throwable e) {
                throw new ServiceException("Failed to create factory: " + factoryName, e);
            }
        }
        if (factory == null) {
            throw new ServiceException("Cannot find ServiceFactory implementation");
        }
        return factory;
    }

    public abstract Service createService(URL var1, QName var2) throws ServiceException;

    public abstract Service createService(QName var1) throws ServiceException;

    public abstract Service loadService(Class var1) throws ServiceException;

    public abstract Service loadService(URL var1, Class var2, Properties var3) throws ServiceException;

    public abstract Service loadService(URL var1, QName var2, Properties var3) throws ServiceException;

    private static Class<?> loadClass(final ClassLoader cl, final String name) throws PrivilegedActionException, ClassNotFoundException {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return cl.loadClass(name);
        }
        return (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws PrivilegedActionException {
                try {
                    return cl.loadClass(name);
                }
                catch (Exception e) {
                    throw new PrivilegedActionException(e);
                }
            }
        });
    }

    private static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static {
        alternativeFactories = new String[0];
    }

    private static class PropertyAccessAction
    implements PrivilegedAction {
        private String name;
        private String defaultValue;

        PropertyAccessAction(String name, String defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        public Object run() {
            return System.getProperty(this.name, this.defaultValue);
        }
    }
}

