/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.weld.environment.servlet.deployment;

import java.net.URL;
import org.jboss.weld.environment.servlet.deployment.Scanner;
import org.jboss.weld.environment.servlet.deployment.WebAppBeanDeploymentArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractScanner
implements Scanner {
    private static final Logger log = LoggerFactory.getLogger(Scanner.class);
    private final ClassLoader classLoader;
    private final WebAppBeanDeploymentArchive webAppBeanDeploymentArchive;

    public AbstractScanner(ClassLoader classLoader, WebAppBeanDeploymentArchive webBeanDiscovery) {
        this.classLoader = classLoader;
        this.webAppBeanDeploymentArchive = webBeanDiscovery;
    }

    protected void handle(String name, URL url) {
        if (name.endsWith(".class")) {
            String className = AbstractScanner.filenameToClassname(name);
            try {
                this.webAppBeanDeploymentArchive.getBeanClasses().add(this.getClassLoader().loadClass(className));
            }
            catch (NoClassDefFoundError e) {
                log.error("Error loading " + name, e);
            }
            catch (ClassNotFoundException e) {
                log.error("Error loading " + name, e);
            }
        } else if (name.equals("META-INF/beans.xml")) {
            this.webAppBeanDeploymentArchive.getWeldUrls().add(url);
        }
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static String filenameToClassname(String filename) {
        return filename.substring(0, filename.lastIndexOf(".class")).replace('/', '.').replace('\\', '.');
    }
}

